/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.util.Util;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class CharIterator
implements Iterator<Character> {
    private final String aValue;
    private int aBoundIndex;
    private int aCurrentIndex;

    public CharIterator(String value) {
        this.aValue = value;
        this.aBoundIndex = this.aValue.length();
        this.aCurrentIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.aCurrentIndex < this.aBoundIndex;
    }

    public void skip(int n) {
        this.aCurrentIndex += n;
    }

    public void skip() {
        this.skip(1);
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int offset) {
        int pos = this.aCurrentIndex + offset;
        if (pos < 0 || pos >= this.aBoundIndex) {
            return '\u0000';
        }
        return this.aValue.charAt(pos);
    }

    @Override
    public Character next() {
        try {
            return Character.valueOf(this.aValue.charAt(this.aCurrentIndex++));
        }
        catch (StringIndexOutOfBoundsException e) {
            NoSuchElementException noSuchElementException = new NoSuchElementException(e.getMessage());
            noSuchElementException.initCause(e);
            throw noSuchElementException;
        }
    }

    public String next(int length) {
        int upTo = this.aCurrentIndex + length;
        if (upTo > this.aBoundIndex) {
            upTo = this.aBoundIndex;
        }
        String substring = this.aValue.substring(this.aCurrentIndex, upTo);
        this.aCurrentIndex = upTo;
        return substring;
    }

    public String context() {
        return this.context(this.aCurrentIndex - 1);
    }

    public String context(int index) {
        int start = Math.max(0, index - 5);
        int end = Math.min(this.aBoundIndex, index + 5);
        int offsetOfPointer = start == 0 ? index : 5;
        return "\n'" + this.aValue.substring(start, end) + "'\n" + Util.repeat_char(' ', 1 + offsetOfPointer) + '^';
    }

    public int remaining() {
        return this.aBoundIndex - this.aCurrentIndex;
    }

    public String nextUntil(char c) {
        return this.nextUntil((str, fromIdx) -> str.indexOf(c, (int)fromIdx), 1, true);
    }

    public String nextUntil(String s) {
        return this.nextUntil((str, fromIdx) -> str.indexOf(s, (int)fromIdx), s.length(), false);
    }

    private String nextUntil(BiFunction<String, Integer, Integer> indexOf, int len, boolean mustExist) {
        int substringEnd;
        int startIndex = this.aCurrentIndex;
        while (true) {
            this.aCurrentIndex = indexOf.apply(this.aValue, this.aCurrentIndex);
            if (this.aCurrentIndex + len > this.aBoundIndex) {
                substringEnd = this.aCurrentIndex = this.aBoundIndex;
                break;
            }
            if (this.aCurrentIndex == -1) {
                if (mustExist) {
                    throw new NoSuchElementException("Could not find termination sequence/character in string: '" + this.aValue.substring(startIndex));
                }
                substringEnd = this.aCurrentIndex = this.aBoundIndex;
                break;
            }
            int cnt = 1;
            while (this.aValue.charAt(this.aCurrentIndex - cnt) == '\\') {
                ++cnt;
            }
            if (cnt % 2 != 0) {
                substringEnd = this.aCurrentIndex;
                this.aCurrentIndex += len;
                break;
            }
            ++this.aCurrentIndex;
        }
        return this.aValue.substring(startIndex, substringEnd);
    }

    public String takeWhile(Predicate<Character> condition) {
        int startIndex = this.aCurrentIndex;
        while (this.hasNext()) {
            if (condition.test(this.next())) continue;
            --this.aCurrentIndex;
            break;
        }
        return this.aValue.substring(startIndex, this.aCurrentIndex);
    }

    public char lastChar() {
        return this.aValue.charAt(this.aBoundIndex - 1);
    }

    public void modifyBound(int offset) {
        this.aBoundIndex += offset;
    }

    public int prevPos() {
        return this.aCurrentIndex - 1;
    }

    public String substringToCurrPos(int pos) {
        return this.aValue.substring(pos, this.aCurrentIndex);
    }
}

