/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import redis.embedded.util.CheckedRunnable;

public final class IO
extends Enum<IO> {
    private static final /* synthetic */ IO[] $VALUES;

    public static IO[] values() {
        return (IO[])$VALUES.clone();
    }

    public static IO valueOf(String name) {
        return Enum.valueOf(IO.class, name);
    }

    public static File newTempDirForBinary() throws IOException {
        File tempDirectory = Files.createDirectories(Files.createTempDirectory("redis-", new FileAttribute[0]), new FileAttribute[0]).toFile();
        tempDirectory.deleteOnExit();
        return tempDirectory;
    }

    public static File writeResourceToExecutableFile(File tempDirectory, String resourcePath) throws IOException {
        File executable = new File(tempDirectory, resourcePath);
        try (InputStream in = IO.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new FileNotFoundException("Could not find Redis executable at " + resourcePath);
            }
            Files.copy(in, executable.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        executable.deleteOnExit();
        if (!executable.setExecutable(true)) {
            throw new IOException("Failed to set executable permission for binary " + resourcePath + " at temporary location " + executable);
        }
        return executable;
    }

    public static Runnable checkedToRuntime(CheckedRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void addShutdownHook(String name, Runnable run) {
        Runtime.getRuntime().addShutdownHook(new Thread(run, name));
    }

    public static void logStream(InputStream stream, Consumer<String> logConsumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                logConsumer.accept(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Thread newDaemonThread(Runnable run) {
        Thread thread = new Thread(run);
        thread.setDaemon(true);
        return thread;
    }

    public static boolean findMatchInStream(InputStream in, Pattern pattern, Consumer<String> soutListener, StringBuilder processOutput) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (soutListener != null) {
                    soutListener.accept(line);
                }
                processOutput.append('\n').append(line);
                if (!pattern.matcher(line).matches()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static String readFully(InputStream in, Consumer<String> listener) {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (listener != null) {
                    listener.accept(line);
                }
                ret.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret.toString();
    }

    public static Stream<String> processToLines(String command) throws IOException {
        Process proc = Runtime.getRuntime().exec(command);
        return new BufferedReader(new InputStreamReader(proc.getInputStream())).lines();
    }

    public static Path findBinaryInPath(String name) throws FileNotFoundException {
        return IO.findBinaryInPath(name, System.getenv("PATH"));
    }

    private static Path findBinaryInPath(String name, String pathVar) throws FileNotFoundException {
        Optional<Path> location = Stream.of(pathVar.split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).map(path -> path.resolve(name)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findAny();
        if (!location.isPresent()) {
            throw new FileNotFoundException("Could not find binary '" + name + "' in PATH");
        }
        return location.get();
    }

    private static /* synthetic */ IO[] $values() {
        return new IO[0];
    }

    static {
        $VALUES = IO.$values();
    }
}

