/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.model;

import redis.embedded.model.Architecture;
import redis.embedded.model.OS;

public class OsArchitecture {
    public static final OsArchitecture WINDOWS_x86 = new OsArchitecture(OS.WINDOWS, Architecture.x86);
    public static final OsArchitecture WINDOWS_x86_64 = new OsArchitecture(OS.WINDOWS, Architecture.x86_64);
    public static final OsArchitecture UNIX_x86 = new OsArchitecture(OS.UNIX, Architecture.x86);
    public static final OsArchitecture UNIX_x86_64 = new OsArchitecture(OS.UNIX, Architecture.x86_64);
    public static final OsArchitecture UNIX_AARCH64 = new OsArchitecture(OS.UNIX, Architecture.aarch64);
    public static final OsArchitecture MAC_OS_X_x86_64 = new OsArchitecture(OS.MAC_OS_X, Architecture.x86_64);
    public static final OsArchitecture MAC_OS_X_ARM64 = new OsArchitecture(OS.MAC_OS_X, Architecture.aarch64);
    public final OS os;
    public final Architecture arch;

    public static OsArchitecture detectOSandArchitecture() {
        OS os = OS.detectOS();
        Architecture arch = os.detectArchitecture();
        return new OsArchitecture(os, arch);
    }

    public OsArchitecture(OS os, Architecture arch) {
        this.os = os;
        this.arch = arch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OsArchitecture that = (OsArchitecture)o;
        return this.arch == that.arch && this.os == that.os;
    }

    public int hashCode() {
        int result = this.os.hashCode();
        result = 31 * result + this.arch.hashCode();
        return result;
    }
}

