/*
 * Decompiled with CFR 0.152.
 */
package space.fei.code.onvif.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import space.fei.code.onvif.diagnostics.logging.Logger;
import space.fei.code.onvif.diagnostics.logging.Loggers;
import space.fei.code.onvif.discovery.SingleIPCDiscovery;
import space.fei.code.onvif.model.OnvifDeviceInfo;
import space.fei.code.onvif.model.ProfileInfo;
import space.fei.code.onvif.model.UsernameToken;
import space.fei.code.onvif.model.VideoInfo;
import space.fei.code.onvif.service.CapabilitiesService;
import space.fei.code.onvif.util.EncryptUtils;
import space.fei.code.onvif.util.HttpAuths;
import space.fei.code.onvif.util.OkHttpUtils;
import space.fei.code.onvif.util.RegexUtils;

public class OnvifService {
    private static final Logger LOGGER = Loggers.getLogger(OnvifService.class);
    private static OkHttpUtils okHttpUtils = new OkHttpUtils();

    public static List<ProfileInfo> getVideoInfo(OnvifDeviceInfo onvifDeviceInfo) throws Exception {
        if (StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getIp()) || !RegexUtils.isIp(onvifDeviceInfo.getIp())) {
            throw new Exception("onvif \u8bbe\u5907\u7684ip\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getUsername()) || StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getPassword())) {
            throw new Exception("onvif\u8bbe\u5907\u7684\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e3a\u7a7a");
        }
        try {
            SingleIPCDiscovery.fillOnvifAddress(onvifDeviceInfo);
            UsernameToken usernameToken = EncryptUtils.generate(onvifDeviceInfo.getUsername(), onvifDeviceInfo.getPassword());
            String mediaUrl = CapabilitiesService.getMediaUrl(onvifDeviceInfo, usernameToken);
            List<ProfileInfo> profiles = CapabilitiesService.getProfiles(mediaUrl, usernameToken);
            for (ProfileInfo profile : profiles) {
                String streamUri = CapabilitiesService.getStreamUri(mediaUrl, profile.getToken(), usernameToken);
                if (!streamUri.startsWith("rtsp://")) continue;
                StringBuilder fillStreamUrl = new StringBuilder(streamUri.substring(0, 7)).append(onvifDeviceInfo.getUsername()).append(":").append(onvifDeviceInfo.getPassword()).append("@").append(streamUri.substring(7));
                VideoInfo videoInfo = profile.getVideoInfo();
                videoInfo.setStreamUri(fillStreamUrl.toString());
                profile.setVideoInfo(videoInfo);
            }
            return profiles;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0e\u6444\u50cf\u673a[" + onvifDeviceInfo + "]\u4ea4\u4e92\u901a\u4fe1\u53d1\u751f\u9519\u8bef, " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new Exception("\u4e0e\u6444\u50cf\u673a\u4ea4\u4e92\u901a\u4fe1\u53d1\u751f\u9519\u8bef,\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u8fde\u901a\u3001\u6444\u50cf\u673a\u662f\u5426\u652f\u6301Onvif\u534f\u8bae\u6216\u8005\u6444\u50cf\u673a\u662f\u5426\u6b63\u5e38\u5de5\u4f5c");
        }
    }

    public static byte[] snap(OnvifDeviceInfo onvifDeviceInfo) throws Exception {
        if (StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getIp()) || !RegexUtils.isIp(onvifDeviceInfo.getIp())) {
            throw new Exception("Ip\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getUsername()) || StringUtils.isEmpty((CharSequence)onvifDeviceInfo.getPassword())) {
            throw new Exception("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5408\u6cd5");
        }
        byte[] img = new byte[]{};
        SingleIPCDiscovery.fillOnvifAddress(onvifDeviceInfo);
        UsernameToken usernameToken = EncryptUtils.generate(onvifDeviceInfo.getUsername(), onvifDeviceInfo.getPassword());
        String mediaUrl = CapabilitiesService.getMediaUrl(onvifDeviceInfo, usernameToken);
        List<ProfileInfo> profiles = CapabilitiesService.getProfiles(mediaUrl, usernameToken);
        String authorization = HttpAuths.baseAuthGenerate(onvifDeviceInfo.getUsername(), onvifDeviceInfo.getPassword());
        for (int i = 0; i < profiles.size(); ++i) {
            block5: {
                String snapshotUri = CapabilitiesService.getSnapshotUri(mediaUrl, profiles.get(i).getToken(), usernameToken);
                try {
                    img = okHttpUtils.getFile(snapshotUri, authorization);
                }
                catch (Exception e) {
                    LOGGER.error("\u6839\u636e\u6293\u62cduri[" + snapshotUri + "]\u83b7\u53d6\u56fe\u7247\u51fa\u9519, " + ExceptionUtils.getStackTrace((Throwable)e));
                    if (i != profiles.size() - 1) break block5;
                    throw new Exception(e);
                }
            }
            if (img.length > 0) break;
        }
        return img;
    }
}

