/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.filepicker.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.View;
import com.github.angads25.filepicker.R;
import com.github.angads25.filepicker.controller.DialogSelectionListener;
import com.github.angads25.filepicker.model.DialogProperties;
import com.github.angads25.filepicker.view.FilePickerDialog;
import java.io.File;

public class FilePickerPreference
extends Preference
implements DialogSelectionListener,
Preference.OnPreferenceClickListener {
    private FilePickerDialog mDialog;
    private DialogProperties properties = new DialogProperties();
    private String titleText = null;

    public FilePickerPreference(Context context) {
        super(context);
        this.setOnPreferenceClickListener(this);
    }

    public FilePickerPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initProperties(attrs);
        this.setOnPreferenceClickListener(this);
    }

    public FilePickerPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initProperties(attrs);
        this.setOnPreferenceClickListener(this);
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return super.onGetDefaultValue(a, index);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        super.onSetInitialValue(restorePersistedValue, defaultValue);
    }

    protected void onBindView(View view) {
        super.onBindView(view);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.dialogBundle = this.mDialog.onSaveInstanceState();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.showDialog(myState.dialogBundle);
    }

    private void showDialog(Bundle state) {
        this.mDialog = new FilePickerDialog(this.getContext());
        this.setProperties(this.properties);
        this.mDialog.setDialogSelectionListener(this);
        if (state != null) {
            this.mDialog.onRestoreInstanceState(state);
        }
        this.mDialog.setTitle(this.titleText);
        this.mDialog.show();
    }

    @Override
    public void onSelectedFilePaths(String[] files) {
        StringBuilder buff = new StringBuilder();
        for (String path : files) {
            buff.append(path).append(":");
        }
        String dFiles = buff.toString();
        if (this.isPersistent()) {
            this.persistString(dFiles);
        }
        try {
            this.getOnPreferenceChangeListener().onPreferenceChange((Preference)this, (Object)dFiles);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public boolean onPreferenceClick(Preference preference) {
        this.showDialog(null);
        return false;
    }

    public void setProperties(DialogProperties properties) {
        this.mDialog.setProperties(properties);
    }

    private void initProperties(AttributeSet attrs) {
        TypedArray tarr = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.FilePickerPreference, 0, 0);
        int N = tarr.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = tarr.getIndex(i);
            if (attr == R.styleable.FilePickerPreference_selection_mode) {
                this.properties.selection_mode = tarr.getInteger(R.styleable.FilePickerPreference_selection_mode, 0);
                continue;
            }
            if (attr == R.styleable.FilePickerPreference_selection_type) {
                this.properties.selection_type = tarr.getInteger(R.styleable.FilePickerPreference_selection_type, 0);
                continue;
            }
            if (attr == R.styleable.FilePickerPreference_root_dir) {
                String root_dir = tarr.getString(R.styleable.FilePickerPreference_root_dir);
                if (root_dir == null || root_dir.equals("")) continue;
                this.properties.root = new File(root_dir);
                continue;
            }
            if (attr == R.styleable.FilePickerPreference_error_dir) {
                String error_dir = tarr.getString(R.styleable.FilePickerPreference_error_dir);
                if (error_dir == null || error_dir.equals("")) continue;
                this.properties.error_dir = new File(error_dir);
                continue;
            }
            if (attr == R.styleable.FilePickerPreference_offset_dir) {
                String offset_dir = tarr.getString(R.styleable.FilePickerPreference_offset_dir);
                if (offset_dir == null || offset_dir.equals("")) continue;
                this.properties.offset = new File(offset_dir);
                continue;
            }
            if (attr == R.styleable.FilePickerPreference_extensions) {
                String extensions = tarr.getString(R.styleable.FilePickerPreference_extensions);
                if (extensions == null || extensions.equals("")) continue;
                this.properties.extensions = extensions.split(":");
                continue;
            }
            if (attr != R.styleable.FilePickerPreference_title_text) continue;
            this.titleText = tarr.getString(R.styleable.FilePickerPreference_title_text);
        }
        tarr.recycle();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        Bundle dialogBundle;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.dialogBundle = source.readBundle(((Object)((Object)this)).getClass().getClassLoader());
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeBundle(this.dialogBundle);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

