/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif.requests;

import be.teletask.onvif.listeners.OnvifResponseListener;
import be.teletask.onvif.models.OnvifMediaProfile;
import be.teletask.onvif.models.OnvifPreset;
import be.teletask.onvif.models.OnvifType;
import be.teletask.onvif.requests.OnvifRequest;

public class GotoPresetRequest
implements OnvifRequest {
    public static final String TAG = GotoPresetRequest.class.getSimpleName();
    private OnvifResponseListener listener;
    private OnvifMediaProfile mediaProfile;
    private OnvifPreset preset;

    public GotoPresetRequest(OnvifMediaProfile mediaProfile, OnvifPreset preset) {
        this.mediaProfile = mediaProfile;
        this.preset = preset;
    }

    public GotoPresetRequest(OnvifMediaProfile mediaProfile, OnvifPreset preset, OnvifResponseListener listener) {
        this.mediaProfile = mediaProfile;
        this.preset = preset;
        this.listener = listener;
    }

    @Override
    public String getXml() {
        return "<GotoPreset xmlns=\"http://www.onvif.org/ver20/ptz/wsdl\"><ProfileToken>" + this.mediaProfile.getToken() + "</ProfileToken><PresetToken>" + this.preset.getToken() + "</PresetToken></GotoPreset>";
    }

    @Override
    public OnvifType getType() {
        return OnvifType.GOTO_PRESET;
    }

    public OnvifResponseListener getListener() {
        return this.listener;
    }

    public OnvifMediaProfile getMediaProfile() {
        return this.mediaProfile;
    }

    public OnvifPreset getPreset() {
        return this.preset;
    }

    public GotoPresetRequest() {
    }
}

