/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif;

import be.teletask.onvif.OnvifExecutor;
import be.teletask.onvif.listeners.OnvifConfigurationsListener;
import be.teletask.onvif.listeners.OnvifDeviceInformationListener;
import be.teletask.onvif.listeners.OnvifMediaProfilesListener;
import be.teletask.onvif.listeners.OnvifMediaStreamURIListener;
import be.teletask.onvif.listeners.OnvifPresetListener;
import be.teletask.onvif.listeners.OnvifPresetsListener;
import be.teletask.onvif.listeners.OnvifResponseListener;
import be.teletask.onvif.listeners.OnvifServicesListener;
import be.teletask.onvif.listeners.OnvifSnapshotURIListener;
import be.teletask.onvif.listeners.OnvifStatusListener;
import be.teletask.onvif.models.OnvifDevice;
import be.teletask.onvif.models.OnvifMediaProfile;
import be.teletask.onvif.models.OnvifPreset;
import be.teletask.onvif.requests.AbsoluteMoveRequest;
import be.teletask.onvif.requests.GetConfigurationsRequest;
import be.teletask.onvif.requests.GetDeviceInformationRequest;
import be.teletask.onvif.requests.GetMediaProfilesRequest;
import be.teletask.onvif.requests.GetMediaStreamRequest;
import be.teletask.onvif.requests.GetPresetsRequest;
import be.teletask.onvif.requests.GetServicesRequest;
import be.teletask.onvif.requests.GetSnapshotUriRequest;
import be.teletask.onvif.requests.GetStatusRequest;
import be.teletask.onvif.requests.GotoHomePositionRequest;
import be.teletask.onvif.requests.GotoPresetRequest;
import be.teletask.onvif.requests.OnvifRequest;
import be.teletask.onvif.requests.RemovePresetRequest;
import be.teletask.onvif.requests.SetPresetRequest;
import be.teletask.onvif.responses.OnvifResponse;

public class OnvifManager
implements OnvifResponseListener {
    public static final String TAG = OnvifManager.class.getSimpleName();
    private OnvifExecutor executor;
    private OnvifResponseListener onvifResponseListener;

    public OnvifManager(OnvifResponseListener onvifResponseListener) {
        this.onvifResponseListener = onvifResponseListener;
        this.executor = new OnvifExecutor(this);
    }

    public void getServices(OnvifDevice device, OnvifServicesListener listener) {
        GetServicesRequest request = new GetServicesRequest(listener);
        this.executor.sendRequest(device, request);
    }

    public void getDeviceInformation(OnvifDevice device, OnvifDeviceInformationListener listener) {
        GetDeviceInformationRequest request = new GetDeviceInformationRequest(listener);
        this.executor.sendRequest(device, request);
    }

    public void getMediaProfiles(OnvifDevice device, OnvifMediaProfilesListener listener) {
        GetMediaProfilesRequest request = new GetMediaProfilesRequest(listener);
        this.executor.sendRequest(device, request);
    }

    public void getMediaStreamURI(OnvifDevice device, OnvifMediaProfile profile, OnvifMediaStreamURIListener listener) {
        GetMediaStreamRequest request = new GetMediaStreamRequest(profile, listener);
        this.executor.sendRequest(device, request);
    }

    public void getSnapshotURI(OnvifDevice device, OnvifMediaProfile profile, OnvifSnapshotURIListener listener) {
        GetSnapshotUriRequest request = new GetSnapshotUriRequest(profile, listener);
        this.executor.sendRequest(device, request);
    }

    public void getStatus(OnvifDevice device, OnvifMediaProfile profile, OnvifStatusListener listener) {
        GetStatusRequest request = new GetStatusRequest(profile, listener);
        this.executor.sendRequest(device, request);
    }

    public void getPresets(OnvifDevice device, OnvifMediaProfile profile, OnvifPresetsListener listener) {
        GetPresetsRequest request = new GetPresetsRequest(profile, listener);
        this.executor.sendRequest(device, request);
    }

    public void setPreset(OnvifDevice device, OnvifMediaProfile profile, String name, String token, OnvifPresetListener listener) {
        SetPresetRequest request = new SetPresetRequest(profile, name, token, listener);
        this.executor.sendRequest(device, request);
    }

    public void removePreset(OnvifDevice device, OnvifMediaProfile profile, String token) {
        RemovePresetRequest request = new RemovePresetRequest(profile, token);
        this.executor.sendRequest(device, request);
    }

    public void getConfigurations(OnvifDevice device, OnvifConfigurationsListener listener) {
        GetConfigurationsRequest request = new GetConfigurationsRequest(listener);
        this.executor.sendRequest(device, request);
    }

    public void gotoHomePosition(OnvifDevice device, OnvifMediaProfile profile) {
        GotoHomePositionRequest request = new GotoHomePositionRequest(profile);
        this.executor.sendRequest(device, request);
    }

    public void gotoPreset(OnvifDevice device, OnvifMediaProfile profile, OnvifPreset preset) {
        GotoPresetRequest request = new GotoPresetRequest(profile, preset);
        this.executor.sendRequest(device, request);
    }

    public void absoluteMove(OnvifDevice device, OnvifMediaProfile profile, double pan, double tilt, double zoom) {
        AbsoluteMoveRequest request = new AbsoluteMoveRequest(profile, pan, tilt, zoom);
        this.executor.sendRequest(device, request);
    }

    public void sendOnvifRequest(OnvifDevice device, OnvifRequest request) {
        this.executor.sendRequest(device, request);
    }

    public void destroy() {
        this.onvifResponseListener = null;
        this.executor.cleanUp();
    }

    @Override
    public void onResponse(OnvifDevice onvifDevice, OnvifResponse response) {
        if (this.onvifResponseListener != null) {
            this.onvifResponseListener.onResponse(onvifDevice, response);
        }
    }

    @Override
    public void onError(OnvifDevice onvifDevice, int errorCode, String errorMessage) {
        if (this.onvifResponseListener != null) {
            this.onvifResponseListener.onError(onvifDevice, errorCode, errorMessage);
        }
    }
}

