/* Automatically generated by wasm2c */
#include <assert.h>
#include <math.h>
#include <stdarg.h>
#include <stddef.h>
#include <string.h>
#if defined(__MINGW32__)
#include <malloc.h>
#elif defined(_MSC_VER)
#include <intrin.h>
#include <malloc.h>
#define alloca _alloca
#elif defined(__FreeBSD__) || defined(__OpenBSD__)
#include <stdlib.h>
#else
#include <alloca.h>
#endif

#include "hermes_sandbox_impl_dbg_compiled.h"

#define TRAP(x) (wasm_rt_trap(WASM_RT_TRAP_##x), 0)

#if WASM_RT_USE_STACK_DEPTH_COUNT
#define FUNC_PROLOGUE                                            \
  if (++wasm_rt_call_stack_depth > WASM_RT_MAX_CALL_STACK_DEPTH) \
    TRAP(EXHAUSTION);

#define FUNC_EPILOGUE --wasm_rt_call_stack_depth
#else
#define FUNC_PROLOGUE

#define FUNC_EPILOGUE
#endif

#define UNREACHABLE TRAP(UNREACHABLE)

static inline bool func_types_eq(const wasm_rt_func_type_t a,
                                 const wasm_rt_func_type_t b) {
  return (a == b) || LIKELY(a && b && !memcmp(a, b, 32));
}

#define CALL_INDIRECT(table, t, ft, x, ...)              \
  (LIKELY((x) < table.size && table.data[x].func &&      \
          func_types_eq(ft, table.data[x].func_type)) || \
       TRAP(CALL_INDIRECT),                              \
   ((t)table.data[x].func)(__VA_ARGS__))

#ifdef SUPPORT_MEMORY64
#define RANGE_CHECK(mem, offset, len)              \
  do {                                             \
    uint64_t res;                                  \
    if (__builtin_add_overflow(offset, len, &res)) \
      TRAP(OOB);                                   \
    if (UNLIKELY(res > mem->size))                 \
      TRAP(OOB);                                   \
  } while (0);
#else
#define RANGE_CHECK(mem, offset, len)               \
  if (UNLIKELY(offset + (uint64_t)len > mem->size)) \
    TRAP(OOB);
#endif

#if WASM_RT_MEMCHECK_GUARD_PAGES
#define MEMCHECK(mem, a, t)
#else
#define MEMCHECK(mem, a, t) RANGE_CHECK(mem, a, sizeof(t))
#endif

#ifdef __GNUC__
#define wasm_asm __asm__
#else
#define wasm_asm(X)
#endif

#if WABT_BIG_ENDIAN
static inline void load_data(void* dest, const void* src, size_t n) {
  if (!n) {
    return;
  }
  size_t i = 0;
  u8* dest_chars = dest;
  memcpy(dest, src, n);
  for (i = 0; i < (n >> 1); i++) {
    u8 cursor = dest_chars[i];
    dest_chars[i] = dest_chars[n - i - 1];
    dest_chars[n - i - 1] = cursor;
  }
}
#define LOAD_DATA(m, o, i, s)                   \
  do {                                          \
    RANGE_CHECK((&m), m.size - o - s, s);       \
    load_data(&(m.data[m.size - o - s]), i, s); \
  } while (0)
#define DEFINE_LOAD(name, t1, t2, t3)                                  \
  static inline t3 name(wasm_rt_memory_t* mem, u64 addr) {             \
    MEMCHECK(mem, addr, t1);                                           \
    t1 result;                                                         \
    wasm_rt_memcpy(&result, &mem->data[mem->size - addr - sizeof(t1)], \
                   sizeof(t1));                                        \
    wasm_asm("" ::"r"(result));                                        \
    return (t3)(t2)result;                                             \
  }

#define DEFINE_STORE(name, t1, t2)                                      \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, t2 value) {  \
    MEMCHECK(mem, addr, t1);                                            \
    t1 wrapped = (t1)value;                                             \
    wasm_rt_memcpy(&mem->data[mem->size - addr - sizeof(t1)], &wrapped, \
                   sizeof(t1));                                         \
  }
#else
static inline void load_data(void* dest, const void* src, size_t n) {
  if (!n) {
    return;
  }
  memcpy(dest, src, n);
}
#define LOAD_DATA(m, o, i, s)      \
  do {                             \
    RANGE_CHECK((&m), o, s);       \
    load_data(&(m.data[o]), i, s); \
  } while (0)
#define DEFINE_LOAD(name, t1, t2, t3)                      \
  static inline t3 name(wasm_rt_memory_t* mem, u64 addr) { \
    MEMCHECK(mem, addr, t1);                               \
    t1 result;                                             \
    wasm_rt_memcpy(&result, &mem->data[addr], sizeof(t1)); \
    wasm_asm("" ::"r"(result));                            \
    return (t3)(t2)result;                                 \
  }

#define DEFINE_STORE(name, t1, t2)                                     \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, t2 value) { \
    MEMCHECK(mem, addr, t1);                                           \
    t1 wrapped = (t1)value;                                            \
    wasm_rt_memcpy(&mem->data[addr], &wrapped, sizeof(t1));            \
  }
#endif

DEFINE_LOAD(i32_load, u32, u32, u32)
DEFINE_LOAD(i64_load, u64, u64, u64)
DEFINE_LOAD(f32_load, f32, f32, f32)
DEFINE_LOAD(f64_load, f64, f64, f64)
DEFINE_LOAD(i32_load8_s, s8, s32, u32)
DEFINE_LOAD(i64_load8_s, s8, s64, u64)
DEFINE_LOAD(i32_load8_u, u8, u32, u32)
DEFINE_LOAD(i64_load8_u, u8, u64, u64)
DEFINE_LOAD(i32_load16_s, s16, s32, u32)
DEFINE_LOAD(i64_load16_s, s16, s64, u64)
DEFINE_LOAD(i32_load16_u, u16, u32, u32)
DEFINE_LOAD(i64_load16_u, u16, u64, u64)
DEFINE_LOAD(i64_load32_s, s32, s64, u64)
DEFINE_LOAD(i64_load32_u, u32, u64, u64)
DEFINE_STORE(i32_store, u32, u32)
DEFINE_STORE(i64_store, u64, u64)
DEFINE_STORE(f32_store, f32, f32)
DEFINE_STORE(f64_store, f64, f64)
DEFINE_STORE(i32_store8, u8, u32)
DEFINE_STORE(i32_store16, u16, u32)
DEFINE_STORE(i64_store8, u8, u64)
DEFINE_STORE(i64_store16, u16, u64)
DEFINE_STORE(i64_store32, u32, u64)

#if defined(_MSC_VER)

// Adapted from
// https://github.com/nemequ/portable-snippets/blob/master/builtin/builtin.h

static inline int I64_CLZ(unsigned long long v) {
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  if (_BitScanReverse64(&r, v)) {
    return 63 - r;
  }
#else
  if (_BitScanReverse(&r, (unsigned long)(v >> 32))) {
    return 31 - r;
  } else if (_BitScanReverse(&r, (unsigned long)v)) {
    return 63 - r;
  }
#endif
  return 64;
}

static inline int I32_CLZ(unsigned long v) {
  unsigned long r = 0;
  if (_BitScanReverse(&r, v)) {
    return 31 - r;
  }
  return 32;
}

static inline int I64_CTZ(unsigned long long v) {
  if (!v) {
    return 64;
  }
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  _BitScanForward64(&r, v);
  return (int)r;
#else
  if (_BitScanForward(&r, (unsigned int)(v))) {
    return (int)(r);
  }

  _BitScanForward(&r, (unsigned int)(v >> 32));
  return (int)(r + 32);
#endif
}

static inline int I32_CTZ(unsigned long v) {
  if (!v) {
    return 32;
  }
  unsigned long r = 0;
  _BitScanForward(&r, v);
  return (int)r;
}

#define POPCOUNT_DEFINE_PORTABLE(f_n, T)                            \
  static inline u32 f_n(T x) {                                      \
    x = x - ((x >> 1) & (T) ~(T)0 / 3);                             \
    x = (x & (T) ~(T)0 / 15 * 3) + ((x >> 2) & (T) ~(T)0 / 15 * 3); \
    x = (x + (x >> 4)) & (T) ~(T)0 / 255 * 15;                      \
    return (T)(x * ((T) ~(T)0 / 255)) >> (sizeof(T) - 1) * 8;       \
  }

POPCOUNT_DEFINE_PORTABLE(I32_POPCNT, u32)
POPCOUNT_DEFINE_PORTABLE(I64_POPCNT, u64)

#undef POPCOUNT_DEFINE_PORTABLE

#else

#define I32_CLZ(x) ((x) ? __builtin_clz(x) : 32)
#define I64_CLZ(x) ((x) ? __builtin_clzll(x) : 64)
#define I32_CTZ(x) ((x) ? __builtin_ctz(x) : 32)
#define I64_CTZ(x) ((x) ? __builtin_ctzll(x) : 64)
#define I32_POPCNT(x) (__builtin_popcount(x))
#define I64_POPCNT(x) (__builtin_popcountll(x))

#endif

#define DIV_S(ut, min, x, y)                                      \
  ((UNLIKELY((y) == 0))                                           \
       ? TRAP(DIV_BY_ZERO)                                        \
       : (UNLIKELY((x) == min && (y) == -1)) ? TRAP(INT_OVERFLOW) \
                                             : (ut)((x) / (y)))

#define REM_S(ut, min, x, y) \
  ((UNLIKELY((y) == 0))      \
       ? TRAP(DIV_BY_ZERO)   \
       : (UNLIKELY((x) == min && (y) == -1)) ? 0 : (ut)((x) % (y)))

#define I32_DIV_S(x, y) DIV_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_DIV_S(x, y) DIV_S(u64, INT64_MIN, (s64)x, (s64)y)
#define I32_REM_S(x, y) REM_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_REM_S(x, y) REM_S(u64, INT64_MIN, (s64)x, (s64)y)

#define DIVREM_U(op, x, y) \
  ((UNLIKELY((y) == 0)) ? TRAP(DIV_BY_ZERO) : ((x)op(y)))

#define DIV_U(x, y) DIVREM_U(/, x, y)
#define REM_U(x, y) DIVREM_U(%, x, y)

#define ROTL(x, y, mask) \
  (((x) << ((y) & (mask))) | ((x) >> (((mask) - (y) + 1) & (mask))))
#define ROTR(x, y, mask) \
  (((x) >> ((y) & (mask))) | ((x) << (((mask) - (y) + 1) & (mask))))

#define I32_ROTL(x, y) ROTL(x, y, 31)
#define I64_ROTL(x, y) ROTL(x, y, 63)
#define I32_ROTR(x, y) ROTR(x, y, 31)
#define I64_ROTR(x, y) ROTR(x, y, 63)

#define FMIN(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? x : y) \
                                                : (x < y) ? x : y)

#define FMAX(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? y : x) \
                                                : (x > y) ? x : y)

#define TRUNC_S(ut, st, ft, min, minop, max, x)                           \
  ((UNLIKELY((x) != (x)))                                                 \
       ? TRAP(INVALID_CONVERSION)                                         \
       : (UNLIKELY(!((x)minop(min) && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                     : (ut)(st)(x))

#define I32_TRUNC_S_F32(x) \
  TRUNC_S(u32, s32, f32, (f32)INT32_MIN, >=, 2147483648.f, x)
#define I64_TRUNC_S_F32(x) \
  TRUNC_S(u64, s64, f32, (f32)INT64_MIN, >=, (f32)INT64_MAX, x)
#define I32_TRUNC_S_F64(x) \
  TRUNC_S(u32, s32, f64, -2147483649., >, 2147483648., x)
#define I64_TRUNC_S_F64(x) \
  TRUNC_S(u64, s64, f64, (f64)INT64_MIN, >=, (f64)INT64_MAX, x)

#define TRUNC_U(ut, ft, max, x)                                          \
  ((UNLIKELY((x) != (x)))                                                \
       ? TRAP(INVALID_CONVERSION)                                        \
       : (UNLIKELY(!((x) > (ft)-1 && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                    : (ut)(x))

#define I32_TRUNC_U_F32(x) TRUNC_U(u32, f32, 4294967296.f, x)
#define I64_TRUNC_U_F32(x) TRUNC_U(u64, f32, (f32)UINT64_MAX, x)
#define I32_TRUNC_U_F64(x) TRUNC_U(u32, f64, 4294967296., x)
#define I64_TRUNC_U_F64(x) TRUNC_U(u64, f64, (f64)UINT64_MAX, x)

#define TRUNC_SAT_S(ut, st, ft, min, smin, minop, max, smax, x) \
  ((UNLIKELY((x) != (x)))                                       \
       ? 0                                                      \
       : (UNLIKELY(!((x)minop(min))))                           \
             ? smin                                             \
             : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(st)(x))

#define I32_TRUNC_SAT_S_F32(x)                                            \
  TRUNC_SAT_S(u32, s32, f32, (f32)INT32_MIN, INT32_MIN, >=, 2147483648.f, \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F32(x)                                              \
  TRUNC_SAT_S(u64, s64, f32, (f32)INT64_MIN, INT64_MIN, >=, (f32)INT64_MAX, \
              INT64_MAX, x)
#define I32_TRUNC_SAT_S_F64(x)                                        \
  TRUNC_SAT_S(u32, s32, f64, -2147483649., INT32_MIN, >, 2147483648., \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F64(x)                                              \
  TRUNC_SAT_S(u64, s64, f64, (f64)INT64_MIN, INT64_MIN, >=, (f64)INT64_MAX, \
              INT64_MAX, x)

#define TRUNC_SAT_U(ut, ft, max, smax, x)               \
  ((UNLIKELY((x) != (x))) ? 0                           \
                          : (UNLIKELY(!((x) > (ft)-1))) \
                                ? 0                     \
                                : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(x))

#define I32_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u32, f32, 4294967296.f, UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u64, f32, (f32)UINT64_MAX, UINT64_MAX, x)
#define I32_TRUNC_SAT_U_F64(x) TRUNC_SAT_U(u32, f64, 4294967296., UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F64(x) \
  TRUNC_SAT_U(u64, f64, (f64)UINT64_MAX, UINT64_MAX, x)

#define DEFINE_REINTERPRET(name, t1, t2) \
  static inline t2 name(t1 x) {          \
    t2 result;                           \
    memcpy(&result, &x, sizeof(result)); \
    return result;                       \
  }

DEFINE_REINTERPRET(f32_reinterpret_i32, u32, f32)
DEFINE_REINTERPRET(i32_reinterpret_f32, f32, u32)
DEFINE_REINTERPRET(f64_reinterpret_i64, u64, f64)
DEFINE_REINTERPRET(i64_reinterpret_f64, f64, u64)

static float quiet_nanf(float x) {
  uint32_t tmp;
  memcpy(&tmp, &x, 4);
  tmp |= 0x7fc00000lu;
  memcpy(&x, &tmp, 4);
  return x;
}

static double quiet_nan(double x) {
  uint64_t tmp;
  memcpy(&tmp, &x, 8);
  tmp |= 0x7ff8000000000000llu;
  memcpy(&x, &tmp, 8);
  return x;
}

static double wasm_quiet(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return x;
}

static float wasm_quietf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return x;
}

static double wasm_floor(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return floor(x);
}

static float wasm_floorf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return floorf(x);
}

static double wasm_ceil(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return ceil(x);
}

static float wasm_ceilf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return ceilf(x);
}

static double wasm_trunc(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return trunc(x);
}

static float wasm_truncf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return truncf(x);
}

static float wasm_nearbyintf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return nearbyintf(x);
}

static double wasm_nearbyint(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return nearbyint(x);
}

static float wasm_fabsf(float x) {
  if (UNLIKELY(isnan(x))) {
    uint32_t tmp;
    memcpy(&tmp, &x, 4);
    tmp = tmp & ~(1UL << 31);
    memcpy(&x, &tmp, 4);
    return x;
  }
  return fabsf(x);
}

static double wasm_fabs(double x) {
  if (UNLIKELY(isnan(x))) {
    uint64_t tmp;
    memcpy(&tmp, &x, 8);
    tmp = tmp & ~(1ULL << 63);
    memcpy(&x, &tmp, 8);
    return x;
  }
  return fabs(x);
}

static double wasm_sqrt(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return sqrt(x);
}

static float wasm_sqrtf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return sqrtf(x);
}

static inline void memory_fill(wasm_rt_memory_t* mem, u32 d, u32 val, u32 n) {
  RANGE_CHECK(mem, d, n);
  memset(mem->data + d, val, n);
}

static inline void memory_copy(wasm_rt_memory_t* dest,
                               const wasm_rt_memory_t* src,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  RANGE_CHECK(dest, dest_addr, n);
  RANGE_CHECK(src, src_addr, n);
  memmove(dest->data + dest_addr, src->data + src_addr, n);
}

static inline void memory_init(wasm_rt_memory_t* dest,
                               const u8* src,
                               u32 src_size,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  LOAD_DATA((*dest), dest_addr, src + src_addr, n);
}

typedef struct {
  wasm_rt_func_type_t type;
  wasm_rt_function_ptr_t func;
  size_t module_offset;
} wasm_elem_segment_expr_t;

static inline void funcref_table_init(wasm_rt_funcref_table_t* dest,
                                      const wasm_elem_segment_expr_t* src,
                                      u32 src_size,
                                      u32 dest_addr,
                                      u32 src_addr,
                                      u32 n,
                                      void* module_instance) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    const wasm_elem_segment_expr_t* src_expr = &src[src_addr + i];
    dest->data[dest_addr + i] =
        (wasm_rt_funcref_t){src_expr->type, src_expr->func,
                            (char*)module_instance + src_expr->module_offset};
  }
}

// Currently Wasm only supports initializing externref tables with ref.null.
static inline void externref_table_init(wasm_rt_externref_table_t* dest,
                                        u32 src_size,
                                        u32 dest_addr,
                                        u32 src_addr,
                                        u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    dest->data[dest_addr + i] = wasm_rt_externref_null_value;
  }
}

#define DEFINE_TABLE_COPY(type)                                              \
  static inline void type##_table_copy(wasm_rt_##type##_table_t* dest,       \
                                       const wasm_rt_##type##_table_t* src,  \
                                       u32 dest_addr, u32 src_addr, u32 n) { \
    if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))                      \
      TRAP(OOB);                                                             \
    if (UNLIKELY(src_addr + (uint64_t)n > src->size))                        \
      TRAP(OOB);                                                             \
                                                                             \
    memmove(dest->data + dest_addr, src->data + src_addr,                    \
            n * sizeof(wasm_rt_##type##_t));                                 \
  }

DEFINE_TABLE_COPY(funcref)
DEFINE_TABLE_COPY(externref)

#define DEFINE_TABLE_GET(type)                        \
  static inline wasm_rt_##type##_t type##_table_get(  \
      const wasm_rt_##type##_table_t* table, u32 i) { \
    if (UNLIKELY(i >= table->size))                   \
      TRAP(OOB);                                      \
    return table->data[i];                            \
  }

DEFINE_TABLE_GET(funcref)
DEFINE_TABLE_GET(externref)

#define DEFINE_TABLE_SET(type)                                               \
  static inline void type##_table_set(const wasm_rt_##type##_table_t* table, \
                                      u32 i, const wasm_rt_##type##_t val) { \
    if (UNLIKELY(i >= table->size))                                          \
      TRAP(OOB);                                                             \
    table->data[i] = val;                                                    \
  }

DEFINE_TABLE_SET(funcref)
DEFINE_TABLE_SET(externref)

#define DEFINE_TABLE_FILL(type)                                               \
  static inline void type##_table_fill(const wasm_rt_##type##_table_t* table, \
                                       u32 d, const wasm_rt_##type##_t val,   \
                                       u32 n) {                               \
    if (UNLIKELY((uint64_t)d + n > table->size))                              \
      TRAP(OOB);                                                              \
    for (uint32_t i = d; i < d + n; i++) {                                    \
      table->data[i] = val;                                                   \
    }                                                                         \
  }

DEFINE_TABLE_FILL(funcref)
DEFINE_TABLE_FILL(externref)

#if defined(__GNUC__) || defined(__clang__)
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char* const x
#define FUNC_TYPE_EXTERN_T(x) const char* const x
#define FUNC_TYPE_T(x) static const char* const x
#else
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char x[]
#define FUNC_TYPE_EXTERN_T(x) const char x[]
#define FUNC_TYPE_T(x) static const char x[]
#endif

FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t0);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t1);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t2);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t3);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t4);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t5);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t6);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t7);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t8);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t9);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t10);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t11);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t12);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t13);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t14);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t15);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t16);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t17);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t18);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t19);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t20);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t21);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t22);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t23);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t24);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t25);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t26);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t27);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t28);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t29);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t30);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t31);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t32);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t33);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t34);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t35);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t36);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t37);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t38);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t39);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t40);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t41);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t42);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t43);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t44);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t45);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t46);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t47);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t48);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t49);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t50);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t51);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t52);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t53);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t54);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t55);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t56);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t57);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t58);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t59);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t60);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t61);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t62);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t63);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t64);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t65);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t66);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t67);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t68);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t69);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t70);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t71);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t72);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t73);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t74);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t75);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t76);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t77);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t78);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t79);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t80);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t81);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t82);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t83);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t84);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t85);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t86);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t87);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t88);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t89);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t90);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t91);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t92);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t93);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t94);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t95);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t96);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t97);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t98);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t99);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t100);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t101);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t102);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t103);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t104);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t105);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t106);

void w2c_hermes_0x5F_wasm_call_ctors(w2c_hermes*);
u32 w2c_hermes_getentropy(w2c_hermes*, u32, u32);
u32 w2c_hermes_test_wasm_host_timeout(w2c_hermes*);
u32 w2c_hermes_test_and_clear_wasm_host_timeout(w2c_hermes*);
u32 w2c_hermes_get_global_base_0(w2c_hermes*);
void w2c_hermes_0x5Finitialize_0(w2c_hermes*);
u32 w2c_hermes_emscripten_get_heap_size(w2c_hermes*);
void w2c_hermes_0x5FExit(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_errno_location_0(w2c_hermes*);
u32 w2c_hermes_0x5F_wasi_syscall_ret(w2c_hermes*, u32);
u32 w2c_hermes_strcmp(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_clock_gettime(w2c_hermes*, u32, u32);
u32 w2c_hermes_strlen(w2c_hermes*, u32);
void w2c_hermes_abort(w2c_hermes*);
void w2c_hermes_0x5F_wasi_timestamp_to_timespec(w2c_hermes*, u32, u64);
u32 w2c_hermes_0x5Fmmap_js(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_0x5Fmunmap_js(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_0x5F_syscall_openat(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x5F_syscall_fstat64(w2c_hermes*, u32, u32);
u32 w2c_hermes_emscripten_resize_heap(w2c_hermes*, u32);
void w2c_hermes_0x5F_call_sighandler(w2c_hermes*, u32, u32);
u32 w2c_hermes_sbrk(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_memcpy(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x5F_memset(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_dlmalloc(w2c_hermes*, u32);
void w2c_hermes_dlfree(w2c_hermes*, u32);
u32 w2c_hermes_dlrealloc(w2c_hermes*, u32, u32);
u32 w2c_hermes_try_realloc_chunk(w2c_hermes*, u32, u32);
u32 w2c_hermes_dlmemalign(w2c_hermes*, u32, u32);
u32 w2c_hermes_internal_memalign(w2c_hermes*, u32, u32);
u32 w2c_hermes_dlposix_memalign(w2c_hermes*, u32, u32, u32);
void w2c_hermes_dlmallinfo(w2c_hermes*, u32);
void w2c_hermes_dispose_chunk(w2c_hermes*, u32, u32);
u32 w2c_hermes_dlcalloc(w2c_hermes*, u32, u32);
void w2c_hermes_abort_message(w2c_hermes*, u32, u32);
void w2c_hermes_demangling_terminate_handler0x280x29(w2c_hermes*);
u32 w2c_hermes_void0x200x280x2Astd0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3A_0x5Flibcpp_atomic_load0x5Babi0x3Av150070x5D0x3Cvoid0x200x280x2A0x290x280x290x3E0x28void0x200x280x2A0x20const0x2A0x290x280x290x2C0x20int0x290x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3Aget_terminate0x280x29(w2c_hermes*);
void w2c_hermes_std0x3A0x3A_0x5Fterminate0x28void0x200x280x2A0x290x280x290x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3Aterminate0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3Aget_new_handler0x280x29(w2c_hermes*);
u32 w2c_hermes_operator0x20new0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Anothrow_t0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_operator0x20new0x5B0x5D0x28unsigned0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_operator0x20delete0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_operator0x20delete0x5B0x5D0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_operator0x20new0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_aligned_alloc0x5Babi0x3Av150070x5D0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_operator0x20delete0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_aligned_free0x5Babi0x3Av150070x5D0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxa_pure_virtual(w2c_hermes*);
u32 w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3A0x7E_0x5Fshim_type_info0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop20x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3A0x7E_0x5Fclass_type_info0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3A0x7E_0x5Fsi_class_type_info0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_is_equal0x28std0x3A0x3Atype_info0x20const0x2A0x2C0x20std0x3A0x3Atype_info0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3Atype_info0x3A0x3Aname0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x5F_dynamic_cast(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_found_base_class0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABuffer0x3A0x3A0x7EBuffer0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ABuffer0x3A0x3A0x7EBuffer0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCTripwireContext0x3A0x3A0x7EGCTripwireContext0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACrashManager0x3A0x3A0x7ECrashManager0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3A0x7ENopCrashManager0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AregisterMemory0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AunregisterMemory0x28void0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AsetCustomData0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AremoveCustomData0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AsetContextualCustomData0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AremoveContextualCustomData0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AregisterCallback0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28int0x290x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AunregisterCallback0x28int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AsetHeapInfo0x28hermes0x3A0x3Avm0x3A0x3ACrashManager0x3A0x3AHeapInformation0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_memcmp(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x5F_lockfile(w2c_hermes*, u32);
void w2c_hermes_0x5F_unlockfile(w2c_hermes*, u32);
void w2c_hermes_dummy(w2c_hermes*);
void w2c_hermes_libc_exit_fini(w2c_hermes*);
void w2c_hermes_exit(w2c_hermes*, u32);
u32 w2c_hermes_emscripten_futex_wake(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_pthread_mutex_lock(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_pthread_mutex_unlock(w2c_hermes*, u32);
u32 w2c_hermes_pthread_mutex_destroy(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_pthread_create(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x5F_pthread_join(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_pthread_key_create(w2c_hermes*, u32, u32);
u32 w2c_hermes_pthread_setspecific(w2c_hermes*, u32, u32);
u32 w2c_hermes_pthread_cond_wait(w2c_hermes*, u32, u32);
u32 w2c_hermes_pthread_cond_signal(w2c_hermes*, u32);
u32 w2c_hermes_pthread_cond_broadcast(w2c_hermes*, u32);
u32 w2c_hermes_pthread_cond_destroy(w2c_hermes*, u32);
void w2c_hermes_0x5F_lock(w2c_hermes*, u32);
void w2c_hermes_0x5F_unlock(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_ofl_lock(w2c_hermes*);
void w2c_hermes_0x5F_stdio_exit(w2c_hermes*);
void w2c_hermes_close_file(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_towrite(w2c_hermes*, u32);
u32 w2c_hermes_isdigit(w2c_hermes*, u32);
u32 w2c_hermes_memchr(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_strnlen(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_syscall_getpid(w2c_hermes*);
u32 w2c_hermes_0x5F_syscall_getrusage(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_syscall_mprotect(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_getpid(w2c_hermes*);
u32 w2c_hermes_0x5F_get_tp(w2c_hermes*);
void w2c_hermes_init_pthread_self(w2c_hermes*);
u32 w2c_hermes_wcrtomb(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_wctomb(w2c_hermes*, u32, u32);
f64 w2c_hermes_frexp(w2c_hermes*, f64, u32);
void w2c_hermes_0x5F_ashlti3(w2c_hermes*, u32, u64, u64, u32);
void w2c_hermes_0x5F_lshrti3(w2c_hermes*, u32, u64, u64, u32);
f64 w2c_hermes_0x5F_trunctfdf2(w2c_hermes*, u64, u64);
u32 w2c_hermes_0x5F_fwritex(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_fwrite(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x5F_vfprintf_internal(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_printf_core(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_out(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_getint(w2c_hermes*, u32);
void w2c_hermes_pop_arg(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_fmt_x(w2c_hermes*, u64, u32, u32);
u32 w2c_hermes_fmt_o(w2c_hermes*, u64, u32);
u32 w2c_hermes_fmt_u(w2c_hermes*, u64, u32);
void w2c_hermes_pad(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_vfprintf(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_fmt_fp(w2c_hermes*, u32, f64, u32, u32, u32, u32);
void w2c_hermes_pop_arg_long_double(w2c_hermes*, u32, u32);
u64 w2c_hermes_0x5F_DOUBLE_BITS(w2c_hermes*, f64);
u32 w2c_hermes_vfiprintf(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_vsnprintf(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_sn_write(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_snprintf(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_fprintf(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_fiprintf(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x5F_overflow(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_lctrans(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_strerror_l(w2c_hermes*, u32, u32);
u32 w2c_hermes_strerror(w2c_hermes*, u32);
u32 w2c_hermes_memmove(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_isspace(w2c_hermes*, u32);
u32 w2c_hermes_dummy0x2E1(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_stdio_close(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_stdio_write(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_0x5F_lseek(w2c_hermes*, u32, u64, u32);
u64 w2c_hermes_0x5F_stdio_seek(w2c_hermes*, u32, u64, u32);
f64 w2c_hermes_scalbn(w2c_hermes*, f64, u32);
u32 w2c_hermes_unsigned0x20long0x20const0x260x20std0x3A0x3A_0x5F20x3A0x3Amin0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x20const0x260x2C0x20unsigned0x20long0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acapacity0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_pointer0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_address0x5Babi0x3Av150070x5D0x3Cchar0x3E0x28char0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Amove0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fnull_terminate_at0x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fgrow_by_and_replace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20long0x20const0x260x20std0x3A0x3A_0x5F20x3A0x3Amin0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x3E0x28unsigned0x20long0x20const0x260x2C0x20unsigned0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_long_cap0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_long_pointer0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_short_pointer0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fchar_traits_move0x3Cchar0x3E0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fset_size0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finvalidate_iterators_past0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Aassign0x28char0x260x2C0x20char0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Amax_size0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20long0x20const0x260x20std0x3A0x3A_0x5F20x3A0x3Amax0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x20const0x260x2C0x20unsigned0x20long0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frecommend0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Falloc0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fallocation_result0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apointer0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fallocate_at_least0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fbegin_lifetime0x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_invalidate_all0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Acopy0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Adeallocate0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x260x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fset_long_pointer0x5Babi0x3Av150070x5D0x28char0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fset_long_cap0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fset_long_size0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Ffits_in_sso0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fset_short_size0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Falloc0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20long0x20std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Amax_size0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x2C0x20void0x2C0x20void0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Anumeric_limits0x3Cunsigned0x20long0x3E0x3A0x3Amax0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_length_error0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afirst0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apointer_traits0x3Cchar0x2A0x3E0x3A0x3Apointer_to0x5Babi0x3Av150070x5D0x28char0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3A0x3Aallocate0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Asecond0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20long0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Falign_it0x5Babi0x3Av150070x5D0x3C16ul0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_random_access_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20char0x2A0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Acopy_n0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20char0x2A0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A0x7Ebasic_string0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_erase_c0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3A0x3Adeallocate0x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fgrow_by0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Aassign0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20char0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3Afill_n0x5Babi0x3Av150070x5D0x3Cchar0x2A0x2C0x20unsigned0x20long0x2C0x20char0x3E0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20char0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit_copy_ctor_external0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_external0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fshrink_or_extend0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_unsigned0x20long0x20const0x260x20std0x3A0x3A_0x5F20x3A0x3Amax0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x3E0x28unsigned0x20long0x20const0x260x2C0x20unsigned0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fcompressed_pair0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_insert_c0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x2C0x20void0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Cfalse0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Ctrue0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apush_back0x28char0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28unsigned0x20long0x2C0x20char0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Ferase_external_with_move0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Acompare0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Acompare0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x2C0x20char0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Ferase_to_end0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aget_allocator0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aselect_on_container_copy_construction0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x2C0x20void0x2C0x20void0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Funinitialized_size_tag0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fzero0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aallocate0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Anullptr_t0x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fcompressed_pair0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Av150070x5D0x3Cchar0x2A0x2C0x20void0x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3Ai_to_string0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20unsigned0x20int0x3E0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ato_chars_result0x20std0x3A0x3A_0x5F20x3A0x3Ato_chars0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3Ai_to_string0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20unsigned0x20long0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ato_chars_result0x20std0x3A0x3A_0x5F20x3A0x3Ato_chars0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x2C0x2000x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20long0x2C0x20unsigned0x20long0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28unsigned0x20long0x20const0x260x2C0x20unsigned0x20long0x20const0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Asecond0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_numeric_limits0x3Cunsigned0x20long0x2C0x20true0x3E0x3A0x3Amax0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_allocate0x5Babi0x3Av150070x5D0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fis_overaligned_for_new0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_void0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_operator_new0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x3E0x28unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_void0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_operator_new0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3Acopy0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20char0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcopy0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x2C0x2000x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_auto0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_range0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_decltype0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x2A0x2C0x20true0x3E0x3A0x3A_0x5Funwrap0x28std0x3A0x3Adeclval0x3Cchar0x2A0x3E0x280x290x290x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter0x5Babi0x3Av150070x5D0x3Cchar0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x2A0x2C0x20true0x3E0x2C0x2000x3E0x28char0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20char0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcopy_impl0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2C0x20char0x2C0x20void0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_char0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Frewrap_range0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Frewrap_iter0x5Babi0x3Av150070x5D0x3Cchar0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x2A0x2C0x20true0x3E0x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_ref_decay0x3Cchar0x20const0x2A0x3E0x3A0x3Atype0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_ref_decay0x3Cchar0x2A0x3E0x3A0x3Atype0x3E0x20std0x3A0x3A_0x5F20x3A0x3Amake_pair0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x2A0x3E0x28char0x20const0x2A0x260x260x2C0x20char0x2A0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_range_impl0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x3A0x3A_0x5Funwrap0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x2A0x2C0x20true0x3E0x3A0x3A_0x5Funwrap0x5Babi0x3Av150070x5D0x28char0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20char0x2A0x3E0x3A0x3Apair0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x2A0x2C0x200x28void0x2A0x2900x3E0x28char0x20const0x2A0x260x260x2C0x20char0x2A0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_range_impl0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x3A0x3A_0x5Frewrap0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x2A0x2C0x20true0x3E0x3A0x3A_0x5Frewrap0x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_decltype0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x20const0x2A0x2C0x20true0x3E0x3A0x3A_0x5Funwrap0x28std0x3A0x3Adeclval0x3Cchar0x20const0x2A0x3E0x280x290x290x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x20const0x2A0x2C0x20true0x3E0x2C0x2000x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x3A0x3Apair0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x200x28void0x2A0x2900x3E0x28char0x20const0x2A0x260x260x2C0x20char0x20const0x2A0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x20const0x2A0x2C0x20true0x3E0x3A0x3A_0x5Funwrap0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_char0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Frewrap_iter0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x20const0x2A0x2C0x20true0x3E0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Funwrap_iter_impl0x3Cchar0x20const0x2A0x2C0x20true0x3E0x3A0x3A_0x5Frewrap0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_deallocate0x5Babi0x3Av150070x5D0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_deallocate_handle_size0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Aalign_val_t0x3E0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_deallocate_handle_size0x5Babi0x3Av150070x5D0x3C0x3E0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_operator_delete0x5Babi0x3Av150070x5D0x3Cvoid0x2A0x2C0x20std0x3A0x3Aalign_val_t0x3E0x28void0x2A0x2C0x20std0x3A0x3Aalign_val_t0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_operator_delete0x5Babi0x3Av150070x5D0x3Cvoid0x2A0x3E0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fconvert_to_integral0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ffill_n0x5Babi0x3Av150070x5D0x3Cchar0x2A0x2C0x20unsigned0x20long0x2C0x20char0x3E0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20char0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3A0x3Aallocator0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnon_trivial_if0x3Ctrue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fnon_trivial_if0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x2A0x3E0x3A0x3Avalue0x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit0x3Cchar0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ato_chars_result0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_chars_itoa0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Ftraits_base0x3Cunsigned0x20int0x2C0x20void0x3E0x3A0x3A_0x5Fwidth0x5Babi0x3Av150070x5D0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Ftraits_base0x3Cunsigned0x20int0x2C0x20void0x3E0x3A0x3A_0x5Fconvert0x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_clz0x5Babi0x3Av150070x5D0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fbase_10_u320x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend10x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend20x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend30x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend40x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend50x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend60x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend70x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend80x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend90x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_char0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend100x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x3E0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_random_access_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20char0x2A0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Acopy_n0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20int0x2C0x20char0x2A0x3E0x28char0x20const0x2A0x2C0x20int0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cchar0x2A0x3E0x3A0x3Adifference_type0x20std0x3A0x3A_0x5F20x3A0x3Adistance0x5Babi0x3Av150070x5D0x3Cchar0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cchar0x2A0x3E0x3A0x3Adifference_type0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdistance0x5Babi0x3Av150070x5D0x3Cchar0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Arandom_access_iterator_tag0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_strerror_r(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Adefault_error_condition0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x3A0x3Aerror_condition0x5Babi0x3Av150070x5D0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_category0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aoperator0x3D0x3D0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x3A0x3Acategory0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aoperator0x3D0x3D0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Aerror_category0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x3A0x3Avalue0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_code0x3A0x3Acategory0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_code0x3A0x3Avalue0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdo_message0x3A0x3Amessage0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3Ado_strerror_r0x28int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3Ahandle_strerror_r_return0x28int0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Aname0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Amessage0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ageneric_category0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Aname0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Amessage0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Adefault_error_condition0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Asystem_category0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3A0x7Eerror_category0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_code0x3A0x3Amessage0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_system_error0x28int0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3A0x7E_0x5Fgeneric_error_category0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3A0x7E_0x5Fsystem_error_category0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Arandom_device0x3A0x3Arandom_device0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x210x3D0x5Babi0x3Av150070x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ac_str0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x3D0x3D0x5Babi0x3Av150070x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Adata0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Arandom_device0x3A0x3A0x7Erandom_device0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Arandom_device0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Alength0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Asize0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fis_long0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_long_size0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_short_size0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Afirst0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Frep0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_pointer0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_char0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_address0x5Babi0x3Av150070x5D0x3Cchar0x20const0x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_long_pointer0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fget_short_pointer0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apointer_traits0x3Cchar0x20const0x2A0x3E0x3A0x3Apointer_to0x5Babi0x3Av150070x5D0x28char0x20const0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_getpagesize(w2c_hermes*);
u32 w2c_hermes_0x5F_cxa_atexit(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x5F_assert_fail(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_write(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Allvm_is_multithreaded0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Acondition_variable0x3A0x3A0x7Econdition_variable0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_condvar_destroy0x5Babi0x3Av150070x5D0x28pthread_cond_t0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Amutex0x3A0x3A0x7Emutex0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_mutex_destroy0x5Babi0x3Av150070x5D0x28pthread_mutex_t0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_syscall_ret(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A0x7E_0x5Fshared_count0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Frelease_weak0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_long0x20std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3A_0x5Flibcpp_atomic_load0x5Babi0x3Av150070x5D0x3Clong0x3E0x28long0x20const0x2A0x2C0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Fget_deleter0x28std0x3A0x3Atype_info0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x3A0x3A_0x5Fmake_ready0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Afuture0x3Cvoid0x3E0x3A0x3A0x7Efuture0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Athread0x3A0x3A0x7Ethread0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_thread_isnull0x5Babi0x3Av150070x5D0x28unsigned0x20long0x20const0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Athread0x3A0x3Ajoin0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_thread_join0x5Babi0x3Av150070x5D0x28unsigned0x20long0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_local_data0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_specific_ptr0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3E0x3A0x3A_0x5Fthread_specific_ptr0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_specific_ptr0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3E0x3A0x3A_0x5Fat_thread_exit0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_tls_create0x5Babi0x3Av150070x5D0x28unsigned0x20int0x2A0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct_imp0x3A0x3A0x7E_0x5Fthread_struct_imp0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Abegin0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Aend0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x210x3D0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Abegin0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Aend0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x210x3D0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x3A0x3Aoperator0x2A0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_count0x3A0x3A_0x5Frelease_shared0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x3A0x3Aoperator0x2B0x2B0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x3A0x3Aoperator0x2D0x3E0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x3A0x3Aoperator0x2B0x2B0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A0x7Evector0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A0x7Evector0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x3A0x3A_0x5Fwrap_iter0x5Babi0x3Av150070x5D0x28void0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x3D0x3D0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_address0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x3A0x3A_0x5Fwrap_iter0x5Babi0x3Av150070x5D0x28void0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x3D0x3D0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_long0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_atomic_refcount_decrement0x5Babi0x3Av150070x5D0x3Clong0x3E0x28long0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3A_0x5Fdestroy_vector0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3A_0x5Fdestroy_vector0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fdestroy_vector0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3A0x3A_0x5Fthread_struct0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct_imp0x3A0x3A_0x5Fthread_struct_imp0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Avector0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Avector0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3A0x3A0x7E_0x5Fthread_struct0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x3E0x3A0x3Abase0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x3E0x3A0x3Abase0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fannotate_delete0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_erase_c0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fclear0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Falloc0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Acapacity0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Adeallocate0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Adata0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Asize0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fannotate_contiguous_container0x5Babi0x3Av150070x5D0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fbase_destruct_at_end0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3A0x3Adeallocate0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Asecond0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fend_cap0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Adestroy0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20void0x2C0x20void0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Adestroy_at0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x2000x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdestroy_at0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x2000x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Afirst0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fannotate_delete0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_erase_c0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fclear0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Falloc0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Acapacity0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Adeallocate0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Adata0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Asize0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fannotate_contiguous_container0x5Babi0x3Av150070x5D0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fbase_destruct_at_end0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3A0x3Adeallocate0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Asecond0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fend_cap0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fto_address0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Adestroy0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20void0x2C0x20void0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Adestroy_at0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x2000x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdestroy_at0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x2000x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Afirst0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fget0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Anullptr_t0x2C0x20void0x3E0x28std0x3A0x3Anullptr_t0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fconvert_to_integral0x5Babi0x3Av150070x5D0x28long0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x2000x2C0x20false0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Anullptr_t0x2C0x20void0x3E0x28std0x3A0x3Anullptr_t0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3A_0x5Fcompressed_pair0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Anullptr_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x3E0x28std0x3A0x3Anullptr_t0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_insert_c0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3A_0x5Fcompressed_pair0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Anullptr_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x3E0x28std0x3A0x3Anullptr_t0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdebug_db_insert_c0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcompressed_pair_elem0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x2C0x2010x2C0x20true0x3E0x3A0x3A_0x5Fcompressed_pair_elem0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdefault_init_tag0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Acondition_variable0x3A0x3Anotify_one0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_condvar_signal0x5Babi0x3Av150070x5D0x28pthread_cond_t0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Acondition_variable0x3A0x3Anotify_all0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x20long0x3E0x28long0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_convertible0x3Clong0x20long0x20const0x260x2C0x20long0x20long0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x200x21treat_as_floating_point0x3Clong0x20long0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x3A0x3Acount0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3A0x3Acount0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fno_overflow0x3Cstd0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x20_0x5Fno_overflow0x3Cstd0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3A0x3Atype0x3A0x3Aden0x200x3D0x3D0x2010x200x260x260x200x21treat_as_floating_point0x3Clong0x20long0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x20long0x3E0x28long0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_convertible0x3Clong0x20long0x20const0x260x2C0x20long0x20long0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x200x21treat_as_floating_point0x3Clong0x20long0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_duration0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration_cast0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x2C0x20long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x29(w2c_hermes*, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3A_0x5Fduration_cast0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1000000000ll0x2C0x201ll0x3E0x2C0x20false0x2C0x20true0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Amutex0x3A0x3Alock0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_mutex_lock0x5Babi0x3Av150070x5D0x28pthread_mutex_t0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Amutex0x3A0x3Aunlock0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_mutex_unlock0x5Babi0x3Av150070x5D0x28pthread_mutex_t0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aunique_lock0x3Cstd0x3A0x3A_0x5F20x3A0x3Amutex0x3E0x3A0x3Aunique_lock0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Amutex0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aunique_lock0x3Cstd0x3A0x3A_0x5F20x3A0x3Amutex0x3E0x3A0x3A0x7Eunique_lock0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once0x28unsigned0x20long0x20volatile0x260x2C0x20void0x2A0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_condvar_wait0x5Babi0x3Av150070x5D0x28pthread_cond_t0x2A0x2C0x20pthread_mutex_t0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3A_0x5Flibcpp_relaxed_store0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x20volatile0x2C0x20unsigned0x20long0x3E0x28unsigned0x20long0x20volatile0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A0x28anonymous0x20namespace0x290x3A0x3A_0x5Flibcpp_atomic_store0x5Babi0x3Av150070x5D0x3Cunsigned0x20long0x20volatile0x2C0x20unsigned0x20long0x3E0x28unsigned0x20long0x20volatile0x2A0x2C0x20unsigned0x20long0x2C0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_condvar_broadcast0x5Babi0x3Av150070x5D0x28pthread_cond_t0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Flibcpp_thread_get_id0x5Babi0x3Av150070x5D0x28unsigned0x20long0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AMutexImpl0x3A0x3AMutexImpl0x28bool0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AMutexImpl0x3A0x3A0x7EMutexImpl0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AMutexImpl0x3A0x3Aacquire0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AMutexImpl0x3A0x3Arelease0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AManagedStaticBase0x3A0x3ARegisterManagedStatic0x28void0x2A0x200x280x2A0x290x280x290x2C0x20void0x200x280x2A0x290x28void0x2A0x290x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_initializeMutex0x280x29(w2c_hermes*);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once_proxy0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Cvoid0x200x280x260x290x280x290x3E0x3E0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_sigaltstack(w2c_hermes*, u32, u32);
u32 w2c_hermes_sigemptyset(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_sigaction(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_sigfillset(w2c_hermes*, u32);
u32 w2c_hermes_sigismember(w2c_hermes*, u32, u32);
u32 w2c_hermes_sigorset(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_sigandset(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_sigdelset(w2c_hermes*, u32, u32);
u32 w2c_hermes_sigaddset(w2c_hermes*, u32, u32);
u32 w2c_hermes_raise(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_sig_is_blocked(w2c_hermes*, u32);
u32 w2c_hermes_pthread_sigmask(w2c_hermes*, u32, u32, u32);
void w2c_hermes_siginvertset(w2c_hermes*, u32, u32);
u32 w2c_hermes_sigprocmask(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3ARunSignalHandlers0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3ARunInterruptHandlers0x280x29(w2c_hermes*);
void w2c_hermes_RegisterHandlers0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3Cllvh0x3A0x3Asys0x3A0x3ASmartMutex0x3Ctrue0x3E0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3Cllvh0x3A0x3Asys0x3A0x3ASmartMutex0x3Ctrue0x3E0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_SignalHandler0x28int0x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3AAddSignalHandler0x28void0x200x280x2A0x290x28void0x2A0x290x2C0x20void0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_hashable_data0x3Cunsigned0x20int0x20const0x3E0x3A0x3Avalue0x2C0x20llvh0x3A0x3Ahash_code0x3E0x3A0x3Atype0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_range_impl0x3Cunsigned0x20int0x20const0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3AAddPointer0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3AAddInteger0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3AComputeHash0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3Aoperator0x3D0x3D0x28llvh0x3A0x3AFoldingSetNodeID0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ABumpPtrAllocatorImpl0x3Cllvh0x3A0x3AMallocAllocator0x2C0x204096ul0x2C0x204096ul0x3E0x3A0x3AAllocate0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AFoldingSetBase0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3A0x7EFoldingSetBase0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AGrowBucketCount0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AInsertNode0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AFindNodeOrInsertPos0x28llvh0x3A0x3AFoldingSetNodeID0x20const0x260x2C0x20void0x2A0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetIteratorImpl0x3A0x3AFoldingSetIteratorImpl0x28void0x2A0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetIteratorImpl0x3A0x3Aadvance0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ABumpPtrAllocatorImpl0x3Cllvh0x3A0x3AMallocAllocator0x2C0x204096ul0x2C0x204096ul0x3E0x3A0x3AStartNewSlab0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AinitSlowCase0x28unsigned0x20long0x20long0x2C0x20bool0x29(w2c_hermes*, u32, u64, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AinitFromArray0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20long0x20long0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AAPInt0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20long0x20long0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AAPInt0x28unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20long0x20long0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AAPInt0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20unsigned0x20char0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AfromString0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20unsigned0x20char0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AshlSlowCase0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcMultiplyPart0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32, u64, u64, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Anegate0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Aoperator0x2B0x2B0x280x29(w2c_hermes*, u32);
u64 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcAdd0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u64, u32);
u64 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcAddPart0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u64, u32);
u64 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcSubtract0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u64, u32);
u64 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcSubtractPart0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u64, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Aoperator0x2A0x28llvh0x3A0x3AAPInt0x20const0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AAPInt0x28unsigned0x20int0x2C0x20unsigned0x20long0x20long0x2C0x20bool0x29(w2c_hermes*, u32, u32, u64, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcAnd0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcOr0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcXor0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Aoperator0x2A0x3D0x28llvh0x3A0x3AAPInt0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcCompare0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AflipAllBitsSlowCase0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcComplement0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Aoperator0x3D0x28llvh0x3A0x3AAPInt0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AlshrInPlace0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AcountLeadingZerosSlowCase0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AcountTrailingZerosSlowCase0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AAPIntOps0x3A0x3ARoundDoubleToAPInt0x28double0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, f64, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Atrunc0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Azext0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AlshrSlowCase0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcShiftRight0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcShiftLeft0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Audiv0x28llvh0x3A0x3AAPInt0x20const0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Adivide0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Audivrem0x28llvh0x3A0x3AAPInt0x20const0x260x2C0x20llvh0x3A0x3AAPInt0x20const0x260x2C0x20llvh0x3A0x3AAPInt0x260x2C0x20llvh0x3A0x3AAPInt0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Aoperator0x3D0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Audivrem0x28llvh0x3A0x3AAPInt0x20const0x260x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3AAPInt0x260x2C0x20unsigned0x20long0x20long0x260x29(w2c_hermes*, u32, u64, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtoString0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20unsigned0x20int0x2C0x20bool0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Adump0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcSet0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u64, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcAssign0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcIsZero0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcExtractBit0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcSetBit0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcLSB0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcMSB0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcNegate0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcFullMultiply0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcDivide0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcSetLeastSignificantBits0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPFloatBase0x3A0x3APPCDoubleDouble0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AcopySignificand0x28llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AIEEEFloat0x28llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AaddOrSubtract0x28llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x20const0x260x2C0x20llvh0x3A0x3AAPFloatBase0x3A0x3AroundingMode0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AcompareAbsoluteValue0x28llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3Anormalize0x28llvh0x3A0x3AAPFloatBase0x3A0x3AroundingMode0x2C0x20llvh0x3A0x3AlostFraction0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AshiftSignificandLeft0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AshiftSignificandRight0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AroundAwayFromZero0x28llvh0x3A0x3AAPFloatBase0x3A0x3AroundingMode0x2C0x20llvh0x3A0x3AlostFraction0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3A0x7EIEEEFloat0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3Aconvert0x28llvh0x3A0x3AfltSemantics0x20const0x260x2C0x20llvh0x3A0x3AAPFloatBase0x3A0x3AroundingMode0x2C0x20bool0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AaddOrSubtractSignificand0x28llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AaddOrSubtractSpecials0x28llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_char0x2A0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_recursive_helper0x3A0x3Acombine_data0x3Cunsigned0x20int0x3E0x28unsigned0x20long0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_recursive_helper0x3A0x3Acombine0x28unsigned0x20long0x2C0x20char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_char0x2A0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_recursive_helper0x3A0x3Acombine_data0x3Cunsigned0x20long0x3E0x28unsigned0x20long0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AconvertF80LongDoubleAPFloatToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AconvertPPCDoubleDoubleAPFloatToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AconvertDoubleAPFloatToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AconvertQuadrupleAPFloatToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AconvertFloatAPFloatToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AconvertHalfAPFloatToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AbitcastToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AinitFromPPCDoubleDoubleAPInt0x28llvh0x3A0x3AAPInt0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3AIEEEFloat0x3A0x3AtoString0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cchar0x2C0x20true0x3E0x3A0x3Apush_back0x28char0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADoubleAPFloat0x3A0x3AbitcastToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPFloat0x3A0x3AbitcastToAPInt0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADoubleAPFloat0x3A0x3AtoString0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPFloat0x3A0x3AtoString0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPFloat0x3A0x3Aprint0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPFloat0x3A0x3Adump0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_state0x3A0x3Amix0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x2A0x2C0x20char0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Frotate0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20char0x2A0x2C0x20char0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Afind0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Afind_first_of0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Afind_first_not_of0x28char0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Afind_first_not_of0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Afind_last_of0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Asplit0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x2C0x20char0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Acount0x28llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_GetAutoSenseRadix0x28llvh0x3A0x3AStringRef0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AconsumeSignedInteger0x28llvh0x3A0x3AStringRef0x260x2C0x20unsigned0x20int0x2C0x20long0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AgetAsUnsignedInteger0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20unsigned0x20long0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AgetAsSignedInteger0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20long0x20long0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AAPFloat0x200x5B0x5D0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AAPFloat0x200x5B0x5D0x3E0x3E0x3A0x3Areset0x5Babi0x3Av150070x5D0x28std0x3A0x3Anullptr_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Ahash_value0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_hashable_data0x3Cchar0x20const0x3E0x3A0x3Avalue0x2C0x20llvh0x3A0x3Ahash_code0x3E0x3A0x3Atype0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_range_impl0x3Cchar0x20const0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x3A0x3AisEqual0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_isalpha(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_strchrnul(w2c_hermes*, u32, u32);
void w2c_hermes_0x5F_emscripten_environ_constructor(w2c_hermes*);
u32 w2c_hermes_strncmp(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_getenv(w2c_hermes*, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Asystem_clock0x3A0x3Anow0x280x29(w2c_hermes*);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3A_0x5Flibcpp_system_clock_now0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x3E0x28long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_convertible0x3Clong0x20const0x260x2C0x20long0x20long0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x200x21treat_as_floating_point0x3Clong0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Acommon_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aoperator0x2B0x5Babi0x3Av150070x5D0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x2C0x20long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Atime_point0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Asystem_clock0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3E0x3A0x3Atime_point0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fno_overflow0x3Cstd0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x20_0x5Fno_overflow0x3Cstd0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3A0x3Atype0x3A0x3Aden0x200x3D0x3D0x2010x200x260x260x200x21treat_as_floating_point0x3Clong0x20long0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_duration0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration_cast0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x2C0x20long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x29(w2c_hermes*, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3A0x3Acount0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Asteady_clock0x3A0x3Anow0x280x29(w2c_hermes*);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3A_0x5Flibcpp_steady_clock_now0x280x29(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x3E0x28long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_convertible0x3Clong0x20const0x260x2C0x20long0x20long0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x200x21treat_as_floating_point0x3Clong0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Acommon_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aoperator0x2B0x5Babi0x3Av150070x5D0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x2C0x20long0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Atime_point0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Asteady_clock0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3E0x3A0x3Atime_point0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x3A0x3Aduration0x5Babi0x3Av150070x5D0x3Clong0x20long0x3E0x28long0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_convertible0x3Clong0x20long0x20const0x260x2C0x20long0x20long0x3E0x3A0x3Avalue0x200x260x260x200x28std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3A0x3Avalue0x200x7C0x7C0x200x21treat_as_floating_point0x3Clong0x20long0x3E0x3A0x3Avalue0x290x2C0x20void0x3E0x3A0x3Atype0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3A_0x5Fduration_cast0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000ll0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1000000ll0x2C0x201ll0x3E0x2C0x20false0x2C0x20true0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201ll0x3E0x3E0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_getrusage(w2c_hermes*, u32, u32);
u32 w2c_hermes_open(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_close(w2c_hermes*, u32);
u32 w2c_hermes_isatty(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AGetMallocUsage0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AGetTimeUsage0x28std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Atime_point0x3Cstd0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Asystem_clock0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Aduration0x3Clong0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aratio0x3C1ll0x2C0x201000000000ll0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3ASafelyCloseFileDescriptor0x28int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AFileDescriptorIsDisplayed0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AFileDescriptorHasColors0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AColorNeedsFlush0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AOutputColor0x28char0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AOutputBold0x28bool0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AOutputReverse0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AProcess0x3A0x3AResetColor0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_syscall_munmap(w2c_hermes*, u32, u32);
u32 w2c_hermes_find_mapping(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_syscall_mmap2(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_dummy0x2E2(w2c_hermes*);
u32 w2c_hermes_0x5F_mmap(w2c_hermes*, u32, u32, u32, u32, u32, u64);
u32 w2c_hermes_0x5F_munmap(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Abegin0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aconst_iterator0x3A0x3Aoperator0x2B0x2B0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aroot_dir_start0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Afilename_pos0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aroot_path0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aroot_directory0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aappend0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Ahas_root_name0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aparent_path_end0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aremove_filename0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x3A0x3Aswap0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Ahas_root_directory0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Ais_absolute0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aremove_dots0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20bool0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3AopenFile0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20int0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3ACreationDisposition0x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3AFileAccess0x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3AOpenFlags0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3AChangeStdoutToBinary0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AMemoryBuffer0x3A0x3Ainit0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AMemoryBuffer0x3A0x3AgetMemBuffer0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_operator0x20new0x28unsigned0x20long0x2C0x200x28anonymous0x20namespace0x290x3A0x3ANamedBufferAlloc0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AMemoryBuffer0x3A0x3AgetMemBufferCopy0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AWritableMemoryBuffer0x3A0x3AgetNewUninitMemBuffer0x28unsigned0x20long0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3A0x3A0x7EMemoryBufferMem0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3A0x3AgetBufferIdentifier0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3A0x3AgetBufferKind0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AMemoryBuffer0x3A0x3A0x7EMemoryBuffer0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AWritableMemoryBuffer0x3E0x3A0x3A0x7EMemoryBufferMem0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AWritableMemoryBuffer0x3E0x3A0x3AgetBufferIdentifier0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AWritableMemoryBuffer0x3E0x3A0x3AgetBufferKind0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AisLegalUTF80x28unsigned0x20char0x20const0x2A0x2C0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AgetNumBytesForUTF80x28unsigned0x20char0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AConvertUTF8toUTF160x28unsigned0x20char0x20const0x2A0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20short0x2A0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20llvh0x3A0x3AConversionFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AConvertUTF8toUTF32Impl0x28unsigned0x20char0x20const0x2A0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2A0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20llvh0x3A0x3AConversionFlags0x2C0x20unsigned0x20char0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AfindMaximalSubpartOfIllFormedUTF8Sequence0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AConvertUTF8toUTF320x28unsigned0x20char0x20const0x2A0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2A0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20llvh0x3A0x3AConversionFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AconvertUTF8ToUTF16String0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cunsigned0x20short0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cunsigned0x20short0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asafe_calloc0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3ALookupBucketFor0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3AFindKey0x28llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3ARemoveKey0x28llvh0x3A0x3AStringMapEntryBase0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3ARemoveKey0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3ARehashTable0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x5F_qsort_r(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_sift(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_shr(w2c_hermes*, u32, u32);
void w2c_hermes_trinkle(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_shl(w2c_hermes*, u32, u32);
u32 w2c_hermes_pntz(w2c_hermes*, u32);
void w2c_hermes_cycle(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x5F_builtin_ctz(w2c_hermes*, u32);
u32 w2c_hermes_a_ctz_32(w2c_hermes*, u32);
void w2c_hermes_qsort(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_wrapper_cmp(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3Ainsert_imp_big0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3AGrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3AFindBucketFor0x28void0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3ASmallPtrSetImplBase0x28void0x20const0x2A0x2A0x2C0x20llvh0x3A0x3ASmallPtrSetImplBase0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3ASmallPtrSetImplBase0x28void0x20const0x2A0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ASmallPtrSetImplBase0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3Aerror0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Araw_ostream0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Abasic_parser_impl0x3A0x3AgetOptionWidth0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Abasic_parser_impl0x3A0x3AprintOptionInfo0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3AprintHelpStr0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3A0x3AprintOptionDiff0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3Acl0x3A0x3AOptionValue0x3Cunsigned0x20int0x3E0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3AaddArgument0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3C0x28anonymous0x20namespace0x290x3A0x3ACommandLineParser0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3C0x28anonymous0x20namespace0x290x3A0x3ACommandLineParser0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3Cllvh0x3A0x3Acl0x3A0x3ASubCommand0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3Cllvh0x3A0x3Acl0x3A0x3ASubCommand0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACommandLineParser0x3A0x3AaddOption0x28llvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3AprintOptionDiff0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Acl0x3A0x3AOptionValue0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x20const0x260x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3A0x3Aparse0x28llvh0x3A0x3Acl0x3A0x3AOption0x260x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20bool0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3A0x3AprintOptionDiff0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x2C0x20bool0x2C0x20llvh0x3A0x3Acl0x3A0x3AOptionValue0x3Cbool0x3E0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValue0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACommandLineParser0x3A0x3AaddLiteralOption0x28llvh0x3A0x3Acl0x3A0x3AOption0x260x2C0x20llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3AsetArgStr0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACommandLineParser0x3A0x3AupdateArgStr0x28llvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionCategory0x3A0x3AregisterCategory0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x3E0x3A0x3Ainsert0x28llvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACommandLineParser0x3A0x3AregisterSubCommand0x28llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Cllvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x3E0x3A0x3Ainsert0x28llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3AaddOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Abasic_parser_impl0x3A0x3AprintOptionName0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Abasic_parser_impl0x3A0x3AprintOptionNoValue0x28llvh0x3A0x3Acl0x3A0x3AOption0x20const0x260x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x3A0x3A0x7EHelpPrinter0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E52(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E56(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E60(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E64(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E68(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E72(w2c_hermes*, u32);
void w2c_hermes_sortOpts0x28llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x260x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x3E0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E74(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E78(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x3A0x3AprintHelp0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_SubNameCompare0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3ASubCommand0x2A0x3E0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x3A0x3Aprint0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3A0x7EOption0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueCopy0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3A0x3AgetValueName0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3A0x3AgetValueName0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3AgetValueName0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cunsigned0x20int0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cunsigned0x20int0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20false0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringMapIterator0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Acl0x3A0x3AOption0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x3A0x3AprintOptions0x28llvh0x3A0x3ASmallVector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x2C0x20128u0x3E0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x3A0x3A0x7EHelpPrinter0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACategorizedHelpPrinter0x3A0x3AprintOptions0x28llvh0x3A0x3ASmallVector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x2C0x20128u0x3E0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACategorizedHelpPrinter0x3A0x3AOptionCategoryCompare0x28llvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x3E0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cllvh0x3A0x3Acl0x3A0x3AOptionCategory0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x3E0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACategorizedHelpPrinter0x3A0x3A0x7ECategorizedHelpPrinter0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Cllvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x3A0x3Ainsert0x28llvh0x3A0x3Acl0x3A0x3AOption0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_OptNameCompare0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cchar0x20const0x2A0x2C0x20llvh0x3A0x3Acl0x3A0x3AOption0x2A0x3E0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueBase0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinter0x2C0x20true0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueBase0x3C0x28anonymous0x20namespace0x290x3A0x3AHelpPrinterWrapper0x2C0x20true0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28llvh0x3A0x3Araw_ostream0x260x290x3E0x3A0x3Aoperator0x280x290x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueBase0x3C0x28anonymous0x20namespace0x290x3A0x3AVersionPrinter0x2C0x20true0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_0x5FGLOBAL_0x5Fsub_I_CommandLine0x2Ecpp(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Acircular_raw_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acircular_raw_ostream0x3A0x3AflushBufferWithBanner0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acircular_raw_ostream0x3A0x3A0x7Ecircular_raw_ostream0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acircular_raw_ostream0x3A0x3A0x7Ecircular_raw_ostream0x280x290x2E1(w2c_hermes*, u32);
u64 w2c_hermes_llvh0x3A0x3Acircular_raw_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AisCurrentDebugType0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOption0x3A0x3A0x7EOption0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E5(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E10(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Adbgs0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Adbgs0x280x290x3A0x3Adbgstream0x3A0x3Adbgstream0x280x29(w2c_hermes*);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E11(w2c_hermes*, u32);
void w2c_hermes_debug_user_sig_handler0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cbool0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cbool0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueCopy0x3Cbool0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueCopy0x3Cunsigned0x20int0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3AOptionValueBase0x3C0x28anonymous0x20namespace0x290x3A0x3ADebugOnlyOpt0x2C0x20true0x3E0x3A0x3Acompare0x28llvh0x3A0x3Acl0x3A0x3AGenericOptionValue0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_0x5FGLOBAL_0x5Fsub_I_Debug0x2Ecpp(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Areport_fatal_error0x28char0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Areport_fatal_error0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Areport_fatal_error0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Areport_bad_alloc_error0x28char0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Allvm_unreachable_internal0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorBase0x3A0x3Agrow_pod0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_writeWithCommas0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20write_unsigned_impl0x3Cunsigned0x20int0x3E0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Awrite_integer0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x29(w2c_hermes*, u32, u64, u32, u32);
void w2c_hermes_void0x20write_unsigned0x3Cunsigned0x20long0x20long0x3E0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x2C0x20bool0x29(w2c_hermes*, u32, u64, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Awrite_integer0x28llvh0x3A0x3Araw_ostream0x260x2C0x20long0x20long0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x29(w2c_hermes*, u32, u64, u32, u32);
void w2c_hermes_llvh0x3A0x3Awrite_hex0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3AHexPrintStyle0x2C0x20llvh0x3A0x3AOptional0x3Cunsigned0x20long0x3E0x29(w2c_hermes*, u32, u64, u32, u32);
void w2c_hermes_llvh0x3A0x3Awrite_double0x28llvh0x3A0x3Araw_ostream0x260x2C0x20double0x2C0x20llvh0x3A0x3AFloatStyle0x2C0x20llvh0x3A0x3AOptional0x3Cunsigned0x20long0x3E0x29(w2c_hermes*, u32, f64, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3A0x7Eraw_ostream0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Apreferred_buffer_size0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3ASetBuffered0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3ASetBufferAndMode0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3Araw_ostream0x3A0x3ABufferKind0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Awrite_hex0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Aformat_object_base0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Awrite0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Awrite_escaped0x28llvh0x3A0x3AStringRef0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28char0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20char0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28double0x29(w2c_hermes*, u32, f64);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aflush_nonempty0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Awrite0x28unsigned0x20char0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Acopy_to_buffer0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Aformatv_object_base0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Aformatv_object_base0x3A0x3Aformat0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFmtAlign0x3A0x3Aformat0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aindent0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3AFormattedNumber0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3A0x7Eraw_ostream0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Aformat_object_base0x3A0x3Ahome0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Araw_fd_ostream0x28llvh0x3A0x3AStringRef0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3ACreationDisposition0x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3AFileAccess0x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3AOpenFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Araw_fd_ostream0x28llvh0x3A0x3AStringRef0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Afs0x3A0x3AOpenFlags0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Araw_fd_ostream0x28int0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3A0x7Eraw_fd_ostream0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x5Babi0x3Av150070x5D0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3A0x7Eraw_fd_ostream0x280x290x2E1(w2c_hermes*, u32);
u64 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Aseek0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Apwrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Apreferred_buffer_size0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3AchangeColor0x28llvh0x3A0x3Araw_ostream0x3A0x3AColors0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3AresetColor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3AreverseColor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Ais_displayed0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Ahas_colors0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aouts0x280x29(w2c_hermes*);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E1(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aerrs0x280x29(w2c_hermes*);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E21(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3A0x7Eraw_string_ostream0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3A0x7Eraw_string_ostream0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3Apwrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u32, u64);
void w2c_hermes_llvh0x3A0x3Araw_pwrite_stream0x3A0x3Aanchor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3AchangeColor0x28llvh0x3A0x3Araw_ostream0x3A0x3AColors0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3AresetColor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3AreverseColor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Ais_displayed0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Ahas_colors0x280x290x20const(w2c_hermes*, u32);
u64 w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3A0x7Eraw_svector_ostream0x280x29(w2c_hermes*, u32);
u64 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3Astr0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AtoStringRef0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AgetSingleStringRef0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AprintOneChild0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3ATwine0x3A0x3AChild0x2C0x20llvh0x3A0x3ATwine0x3A0x3ANodeKind0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AtoVector0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3Aprint0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AtoNullTerminatedStringRef0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AprintOneChildRepr0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3ATwine0x3A0x3AChild0x2C0x20llvh0x3A0x3ATwine0x3A0x3ANodeKind0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AprintRepr0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3Adump0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AdumpRepr0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E2(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Amake_error_code0x28hermes0x3A0x3AOOMError0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aconvert_error_to_message0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahermes_fatal0x28char0x20const0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahermes_fatal0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahermes_fatal0x28llvh0x3A0x3AStringRef0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoom_category0x280x290x3A0x3AOOMErrorCategory0x3A0x3A0x7EOOMErrorCategory0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aoom_category0x280x290x3A0x3AOOMErrorCategory0x3A0x3Aname0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aoom_category0x280x290x3A0x3AOOMErrorCategory0x3A0x3Amessage0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_aligned_alloc(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_mprotect(w2c_hermes*, u32, u32, u32);
void w2c_hermes_emscripten_stack_init(w2c_hermes*);
u32 w2c_hermes_emscripten_stack_get_base(w2c_hermes*);
u32 w2c_hermes_emscripten_stack_get_end(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Apage_size0x280x29(w2c_hermes*);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_allocate0x28unsigned0x20long0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_allocate_aligned0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_free0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_free_aligned0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_prefetch0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_name0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_protect0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20hermes0x3A0x3Aoscompat0x3A0x3AProtectMode0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_madvise0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20hermes0x3A0x3Aoscompat0x3A0x3AMAdvice0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Apeak_rss0x280x29(w2c_hermes*);
u64 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Acurrent_rss0x280x29(w2c_hermes*);
u64 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Acurrent_private_dirty0x280x29(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Anum_context_switches0x28long0x260x2C0x20long0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Athread_stack_bounds0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Athread_cpu_time0x280x29(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3AcheckedMalloc0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AcheckedCalloc0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStorageProvider0x3A0x3A0x7EStorageProvider0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStorageProvider0x3A0x3AmmapProvider0x280x29(w2c_hermes*);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStorageProvider0x3A0x3AnewStorage0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStorageProvider0x3A0x3AdeleteStorage0x28void0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStorageProvider0x3A0x3A0x7EStorageProvider0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AVMAllocateStorageProvider0x3A0x3A0x7EVMAllocateStorageProvider0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AVMAllocateStorageProvider0x3A0x3AnewStorageImpl0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AVMAllocateStorageProvider0x3A0x3AdeleteStorageImpl0x28void0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AMetadata0x28hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3ABuilder0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28hermes0x3A0x3Avm0x3A0x3AGCSymbolID0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCSymbolID0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddArray0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AArrayData0x3A0x3AArrayType0x2C0x20void0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3Aimpl0x3A0x3AFakeAtomic0x3Cunsigned0x20int0x3E0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3Abuild0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AArrayData0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AArrayData0x3A0x3AArrayType0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x200ul0x3E0x3E0x3A0x3Avalue0x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x3A0x3A_0x5Fconstruct_at_end0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x200ul0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x200ul0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x200ul0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x2000x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcopy_unaligned0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x2000x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x2000x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fbit_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cbool0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cbool0x3E0x3E0x2C0x20false0x2C0x2000x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5FGLOBAL_0x5Fsub_I_Metadata0x2Ecpp(w2c_hermes*);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AdirtyCardsForAddressRange0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AfindNextCardWithStatus0x28hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3ACardStatus0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AupdateBoundaries0x28hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3ABoundary0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AfirstObjForCard0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcellKindStr0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AUninitializedBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AFillerCellBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3AStorageProvider0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3AAlignedStorage0x28hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3Aoperator0x3D0x28hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3A0x7EAlignedStorage0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3AresetLevel0x3C0x28hermes0x3A0x3Avm0x3A0x3AAdviseUnused0x2900x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3AAlignedHeapSegment0x28hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3A0x7EAlignedHeapSegment0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3AsetEffectiveEnd0x28char0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3AclearExternalMemoryCharge0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3AcheckUnwritten0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AencodeUTF80x28char0x2A0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AconvertUTF16ToUTF8WithReplacements0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x3Cchar0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AconvertUTF16ToUTF8BufferWithReplacements0x28llvh0x3A0x3AMutableArrayRef0x3Cunsigned0x20char0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AconvertUTF16ToUTF8WithSingleSurrogates0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisAllASCII0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF8WithReplacements0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Ctrue0x2C0x20char16_t0x2A0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cchar16_t0x2A0x3E0x28char16_t0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20char16_t0x2A0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cchar16_t0x2A0x3E0x28char16_t0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x3A0x3AmarkGCScopes0x28hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCScope0x3A0x3A0x7EGCScope0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCScope0x3A0x3A_newChunkAndPHV0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3ACompactArray0x3A0x3AscaleUp0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3AlookupString0x3Cchar0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3AlookupString0x3Cchar16_t0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3Ainsert0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ACompactTable0x3A0x3Aset0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3AgrowAndRehash0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ACompactArray0x3A0x3Aset0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3Aremove0x28hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ACompactTable0x3A0x3AmarkAsDeleted0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcreateASCIIRef0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AIdentifierTable0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetSymbolHandle0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2900x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetOrCreateIdentifier0x3Cchar16_t0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACompactTable0x3A0x3Aget0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocateDynamicString0x3Cchar16_t0x2C0x20true0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocIDAndInsert0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetSymbolHandle0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2900x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetOrCreateIdentifier0x3Cchar0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocateDynamicString0x3Cchar0x2C0x20true0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASymbolID0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AregisterLazyIdentifierImpl0x3Cchar0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocNextID0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AregisterLazyIdentifier0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASymbolID0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AregisterLazyIdentifierImpl0x3Cchar16_t0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AregisterLazyIdentifier0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetSymbolHandleFromPrimitive0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetStringPrim0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AmaterializeLazyIdentifier0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetStringView0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetStringViewForDev0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AconvertSymbolToUTF80x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AmarkIdentifiers0x28hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AvisitIdentifiers0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AConservativeVector0x3Chermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3ALookupEntry0x3E0x3A0x3Aemplace_back0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20true0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20true0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20true0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20true0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AfreeSymbol0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AfreeID0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AunmarkSymbols0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AfreeUnmarkedSymbols0x28llvh0x3A0x3ABitVector0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AIDTracker0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ABitVector0x3A0x3Aflip0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ABitVector0x3A0x3Afind_first_in0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AcreateNotUniquedLazySymbol0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AcreateNotUniquedSymbol0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocateDynamicString0x3Cchar0x2C0x20false0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocateDynamicString0x3Cchar16_t0x2C0x20false0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20true0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20true0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20true0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20true0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20unsigned0x20long0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20long0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x3A0x3AcreateLongLived0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x3A0x3AcreateLongLived0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3AcreateLongLived0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_void0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AallocWork0x3Cfalse0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2910x3E0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3AcreateLongLived0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3A0x3ABufferedStringPrimitive0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3A0x3Aappend0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cunsigned0x20char0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3Aappend0x3Cunsigned0x20char0x20const0x2A0x3E0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar16_t0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3Aappend0x3Cchar16_t0x20const0x2A0x3E0x28char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3E0x3A0x3AHandle0x28hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar0x3E0x3A0x3ABufferedStringPrimitive0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar0x3E0x3A0x3Aappend0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar0x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3E0x3A0x3AHandle0x28hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicASCIIStringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicUTF16StringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicUniquedASCIIStringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicUniquedUTF16StringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalASCIIStringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalUTF16StringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficientImpl0x3Cchar0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3A_0x5Fgrow_by0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficientImpl0x3Cchar16_t0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateDynamicWithKnownEncoding0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateDynamic0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHermesValue0x3A0x3AgetString0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AsliceEquals0x28unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aequals0x28hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aequals0x28hermes0x3A0x3Avm0x3A0x3AStringView0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Acompare0x28hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aconcat0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AinternalConcatStringPrimitives0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AcreateStringBuilder0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3ASafeUInt320x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendStringPrim0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AgetStringPrimitive0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x3A0x3Aoperator0x2A0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendStringPrim0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aslice0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendASCIIRef0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendUTF16Ref0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x3A0x3Aoperator0x2D0x3E0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcastToUTF16PointerForWrite0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateStringView0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3AStringView0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateStringViewMustBeFlat0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AappendUTF16String0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedASCIIStringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedUTF16StringPrimitiveBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3A_0x5Fgrow_by_and_replace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2910x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x3E0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMapBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3AgetMaxCapacity0x280x29(w2c_hermes*);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ATwineChar160x3A0x3ATwineChar160x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2A0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmakeAVariable0x3Chermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3AlookupEntryFor0x28hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3Agrow0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3AfindOrAdd0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3Aerase0x28hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3APropertyPos0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3AallocatePropertySlot0x28hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2900x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AappendSignedLEB1280x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_hermes0x3A0x3AreadSignedLEB1280x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x2C0x20long0x20long0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E3(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E6(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A0x7Eopt0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ACreateInfoOutputFile0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ACreateDefaultTimerGroup0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3Cllvh0x3A0x3ATimerGroup0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aassign0x3Cchar0x20const0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AaddTimer0x28llvh0x3A0x3ATimer0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATimer0x3A0x3Ainit0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ATimerGroup0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ATimer0x3A0x3A0x7ETimer0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AremoveTimer0x28llvh0x3A0x3ATimer0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cllvh0x3A0x3ATimeRecord0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x3E0x28llvh0x3A0x3ATimeRecord0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3APrintQueuedTimers0x28llvh0x3A0x3Araw_ostream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATimer0x3A0x3AstartTimer0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATimer0x3A0x3AstopTimer0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATimeRecord0x3A0x3Aprint0x28llvh0x3A0x3ATimeRecord0x20const0x260x2C0x20llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ANamedRegionTimer0x3A0x3ANamedRegionTimer0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3C0x28anonymous0x20namespace0x290x3A0x3AName2PairMap0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3C0x28anonymous0x20namespace0x290x3A0x3AName2PairMap0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringMapIterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ATimerGroup0x2A0x2C0x20llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3ATimer0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3E0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3AStringMap0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ATimerGroup0x2A0x2C0x20llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3ATimer0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3E0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3Atry_emplace0x3C0x3E0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3ATimerGroup0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringMapIterator0x3Cllvh0x3A0x3ATimer0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3ATimer0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3Atry_emplace0x3C0x3E0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ATimeRegion0x3A0x3ATimeRegion0x28llvh0x3A0x3ATimer0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3A0x7ETimerGroup0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AprepareToPrintList0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AprintJSONValue0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x20const0x260x2C0x20char0x20const0x2A0x2C0x20double0x29(w2c_hermes*, u32, u32, u32, u32, f64);
u32 w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AprintJSONValues0x28llvh0x3A0x3Araw_ostream0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AprintAllJSONValues0x28llvh0x3A0x3Araw_ostream0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3AConstructTimerLists0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AhandleOccurrence0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AgetValueExpectedFlagDefault0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A0x7Eopt0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AgetOptionWidth0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AprintOptionInfo0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AprintOptionValue0x28unsigned0x20long0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AsetDefault0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20llvh0x3A0x3Acl0x3A0x3Aparser0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AgetExtraOptionNames0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3AStringRef0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Acl0x3A0x3Aopt_storage0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20true0x2C0x20true0x3E0x3A0x3AsetLocation0x28llvh0x3A0x3Acl0x3A0x3AOption0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cdouble0x2C0x20double0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Clong0x20long0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_IterOps0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x3E0x3A0x3Aiter_swap0x5Babi0x3Av150070x5D0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x260x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort50x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_down0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x3A0x3Adifference_type0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpop_heap0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_up0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x28llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2C0x20llvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ATimerGroup0x3A0x3APrintRecord0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cint0x2C0x20double0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3ATimer0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3A0x7EStringMap0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x5FGLOBAL_0x5Fsub_I_Timer0x2Ecpp(w2c_hermes*);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E4(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E50x2E1(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AStatistic0x3A0x3ARegisterStatistic0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aobject_creator0x3C0x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3E0x3A0x3Acall0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Aobject_deleter0x3C0x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3E0x3A0x3Acall0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AAreStatisticsEnabled0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3APrintStatistics0x28llvh0x3A0x3Araw_ostream0x260x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fstable_sort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Avalue_type0x2A0x2C0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3APrintStatisticsJSON0x28llvh0x3A0x3Araw_ostream0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Ayaml0x3A0x3AneedsQuotes0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Ayaml0x3A0x3AisNumeric0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3APrintStatistics0x280x29(w2c_hermes*);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fstable_sort_move0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Avalue_type0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finplace_merge0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStatisticInfo0x3A0x3Asort0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x3A0x3Avalue_type0x2A0x2C0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Frotate0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cllvh0x3A0x3AStatistic0x2A0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x5FGLOBAL_0x5Fsub_I_Statistic0x2Ecpp(w2c_hermes*);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x260x20std0x3A0x3A_0x5F20x3A0x3Avector0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x3E0x3E0x3A0x3Aemplace_back0x3Cunsigned0x20int0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x260x3E0x28unsigned0x20int0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adeque0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fadd_back_capacity0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Ctrue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cstd0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cstd0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3A0x3Aoperator0x3D0x5Babi0x3Av150070x5D0x28char16_t0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x260x20std0x3A0x3A_0x5F20x3A0x3Avector0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x3E0x3E0x3A0x3Aemplace_back0x3Cunsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x3E0x28unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3ApackIntoStorage0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3AappendU16Storage0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3AgenerateStringTable0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3A0x7EStringTableBuilder0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cunsigned0x20char0x20const0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20char0x20const0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Ainsert0x3Cunsigned0x20char0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x20const0x2A0x3E0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar16_t0x20const0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cchar16_t0x20const0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar16_t0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3Ainsert0x3Cchar16_t0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar16_t0x20const0x2A0x3E0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28unsigned0x20int0x260x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AradixQuicksort0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AlayoutIfNeeded0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Cunsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28unsigned0x20long0x20long0x260x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AradixQuicksort0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AlayoutIfNeeded0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AStringTableEntry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AStringTableEntry0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AConsecutiveStringStorage0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AConsecutiveStringStorage0x3Cllvh0x3A0x3AStringRef0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x3E0x28llvh0x3A0x3AStringRef0x20const0x2A0x2C0x20llvh0x3A0x3AStringRef0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20false0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AConsecutiveStringStorage0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20const0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20const0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20const0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20true0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AgetEntryHash0x28unsigned0x20long0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AappendStorage0x28hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AgetStringAtIndex0x28unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AgetStringFromEntry0x28hermes0x3A0x3AStringTableEntry0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x20const0x260x2C0x20unsigned0x20int0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cunsigned0x20long0x20long0x3E0x28unsigned0x20long0x20long0x20const0x260x2C0x20unsigned0x20long0x20long0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x3A0x3ALookupBucketFor0x3Cunsigned0x20long0x20long0x3E0x28unsigned0x20long0x20long0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cunsigned0x20long0x20long0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x3E0x3E0x3A0x3Apush_back0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x3E0x3E0x3A0x3Apush_front0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x3E0x260x3E0x3A0x3Apush_back0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x3E0x260x3E0x3A0x3Apush_front0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceMap0x3A0x3AgetLocationForAddressFIndex0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceMap0x3A0x3AgetLocationForAddress0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E7(w2c_hermes*, u32);
void w2c_hermes_ACQUIRE_DTOA_LOCK(w2c_hermes*, u32);
void w2c_hermes_FREE_DTOA_LOCK(w2c_hermes*, u32);
void w2c_hermes_0x5FGLOBAL_0x5Fsub_I_locks0x2Ecpp(w2c_hermes*);
u32 w2c_hermes_dtoa_alloc_init(w2c_hermes*, u32, u32);
void w2c_hermes_dtoa_alloc_done(w2c_hermes*, u32);
void w2c_hermes_dalloc_done(w2c_hermes*, u32);
f64 w2c_hermes_hermes_g_strtod(w2c_hermes*, u32, u32);
u32 w2c_hermes_multadd(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_d2b(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_pow5mult(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_mult(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_lshift(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_diff(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_b2d(w2c_hermes*, u32, u32);
u32 w2c_hermes_quorem(w2c_hermes*, u32, u32);
void w2c_hermes_g_freedtoa(w2c_hermes*, u32, u32);
u32 w2c_hermes_g_dtoa(w2c_hermes*, u32, f64, u32, u32, u32, u32, u32);
u32 w2c_hermes_dtoa_fixedpoint(w2c_hermes*, u32, f64, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AtruncateToInt32SlowPath0x28double0x29(w2c_hermes*, f64);
u32 w2c_hermes_hermes0x3A0x3AnumberToString0x28double0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, f64, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AwillEmitValue0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28double0x29(w2c_hermes*, u32, f64);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AprimitiveEmitString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AencodeUTF160x3Cstd0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x202u0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x202u0x3E0x3E0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitKey0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AopenDict0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AcloseDict0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AopenArray0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AcloseArray0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x202u0x3E0x3E0x3A0x3Aoperator0x3D0x5Babi0x3Av150070x5D0x28char16_t0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3AallocateNewSlab0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cvoid0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x3E0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2A0x3E0x28hermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3AallocateHuge0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3AUnicodeCharSet0x3A0x3ArangesAreValid0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Aunicode0x3A0x3AcolumnWidthUTF80x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Alocale0x3A0x3AcolumnWidth0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3A0x7ESrcBuffer0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AFindBufferContainingLoc0x28llvh0x3A0x3ASMLoc0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3ASrcBuffer0x28llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AFindLine0x28llvh0x3A0x3ASMLoc0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetLineNumber0x3Cunsigned0x20char0x3E0x28char0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetLineNumber0x3Cunsigned0x20short0x3E0x28char0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetLineNumber0x3Cunsigned0x20int0x3E0x28char0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetOffsets0x3Cunsigned0x20char0x3E0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2A0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetOffsets0x3Cunsigned0x20short0x3E0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x2A0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetOffsets0x3Cunsigned0x20int0x3E0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AgetLineRef0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3APrintIncludeStack0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AGetMessage0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASourceMgr0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMRange0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMFixIt0x3E0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASMDiagnostic0x3A0x3ASMDiagnostic0x28llvh0x3A0x3ASourceMgr0x20const0x260x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3AStringRef0x2C0x20int0x2C0x20int0x2C0x20llvh0x3A0x3ASourceMgr0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AArrayRef0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMFixIt0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3APrintMessage0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASMDiagnostic0x3A0x3Aprint0x28char0x20const0x2A0x2C0x20llvh0x3A0x3Araw_ostream0x260x2C0x20bool0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_printSourceLine0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3APrintMessage0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASourceMgr0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMRange0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMFixIt0x3E0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3APrintMessage0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASourceMgr0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMRange0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMFixIt0x3E0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASMFixIt0x3E0x3A0x3Aappend0x3Cllvh0x3A0x3ASMFixIt0x20const0x2A0x2C0x20void0x3E0x28llvh0x3A0x3ASMFixIt0x20const0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ASMFixIt0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cllvh0x3A0x3ASMFixIt0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort50x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASMFixIt0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartial_sort_impl0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_down0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ASMFixIt0x2A0x3E0x3A0x3Adifference_type0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASMFixIt0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ffloyd_sift_down0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ASMFixIt0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_up0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ASMFixIt0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AICoordTranslator0x3A0x3A0x7EICoordTranslator0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3ASourceErrorManager0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AprintDiagnostic0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20void0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AbuildSourceAndCaretLine0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20hermes0x3A0x3ASourceErrorOutputOptions0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3AMessageData0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3AMessageData0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x260x2C0x20llvh0x3A0x3ASMLoc0x260x2C0x20llvh0x3A0x3ASMRange0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x260x2C0x20llvh0x3A0x3ASMLoc0x260x2C0x20llvh0x3A0x3ASMRange0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AenableBuffering0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AaddNewSourceBuffer0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AMemoryBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AAddNewSourceBuffer0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AMemoryBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cllvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cllvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3E0x28llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AaddNewVirtualSourceBuffer0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AgetSourceUrl0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AfindBufferLineAndLoc0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ASourceCoords0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AcountAndGenMessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AdoGenMessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x260x2C0x20llvh0x3A0x3ASMLoc0x260x2C0x20llvh0x3A0x3ASMRange0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x260x2C0x20llvh0x3A0x3ASMLoc0x260x2C0x20llvh0x3A0x3ASMRange0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3AWarning0x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ACollectMessagesRAII0x3A0x3AStoredMessage0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ACollectMessagesRAII0x3A0x3AStoredMessage0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x260x2C0x20llvh0x3A0x3ASMLoc0x260x2C0x20llvh0x3A0x3ASMRange0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x260x2C0x20llvh0x3A0x3ASMLoc0x260x2C0x20llvh0x3A0x3ASMRange0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AfindBufferLineAndLoc0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ASourceCoords0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Ctrue0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AbuildSourceAndCaretLine0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20hermes0x3A0x3ASourceErrorOutputOptions0x290x3A0x3A0x24_00x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AbuildSourceAndCaretLine0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20hermes0x3A0x3ASourceErrorOutputOptions0x290x3A0x3A0x24_00x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar32_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar32_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar32_t0x3E0x3E0x3A0x3A_0x5Fgrow_by0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar32_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar32_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar32_t0x3E0x3E0x3A0x3Areplace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char32_t0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x5Babi0x3Av150070x5D0x3Cchar0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AconvertEndToLocation0x28llvh0x3A0x3ASMRange0x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort5_wrap_policy0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeOnlyLetter0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeOnlySpace0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeCombiningMark0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeDigit0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeConnectorPunctuation0x28unsigned0x20int0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AmakeCanonicallyEquivalent0x28hermes0x3A0x3ACodePointSet0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ACodePointRange0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ACodePointRange0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Acanonicalize0x28unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fequal_range0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x3E0x28hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x260x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ACodePointRange0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ACodePointRange0x3E0x3A0x3Aerase0x28hermes0x3A0x3ACodePointRange0x20const0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACodePointRange0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flower_bound_impl0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x3E0x28hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x260x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACodePointRange0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fupper_bound0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x3E0x28hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x260x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AtokenKindStr0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AJSLexer0x28unsigned0x20int0x2C0x20hermes0x3A0x3ASourceErrorManager0x260x2C0x20hermes0x3A0x3ABacktrackingBumpPtrAllocator0x260x2C0x20hermes0x3A0x3AStringTable0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AinitializeHTMLEntities0x280x29(w2c_hermes*);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E8(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AinitializeWithBufferId0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AinitializeReservedIdentifiers0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AJSLexer0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AMemoryBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3E0x2C0x20hermes0x3A0x3ASourceErrorManager0x260x2C0x20hermes0x3A0x3ABacktrackingBumpPtrAllocator0x260x2C0x20hermes0x3A0x3AStringTable0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3Aadvance0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AgetStringLiteral0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanLineComment0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AskipBlockComment0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanRegExp0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanPrivateIdentifier0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanNumber0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierFastPath0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2910x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierFastPath0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2920x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierFastPath0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeUnicodeEscape0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AappendUnicodeToStorage0x28unsigned0x20int0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2910x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2920x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanString0x3Ctrue0x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanString0x3Cfalse0x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanTemplateLiteral0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Cfalse0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AdecodeUTF80x280x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AdecodeUTF80x280x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AstoreCurrentToken0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3Aerror0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconvertSurrogatesInString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AlineCommentHelper0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AsetSourceUrl0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AsetSourceMappingUrl0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Cfalse0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_decodeUTF8SlowPath0x28char0x20const0x2A0x260x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_decodeUTF8SlowPath0x28char0x20const0x2A0x260x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeOneIdentifierPartNoEscape0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeIdentifierStart0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AerrorRange0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AOptValue0x3Cdouble0x3E0x20hermes0x3A0x3AparseIntWithRadix0x3Ctrue0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeBracedCodePoint0x28bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeIDStart0x28unsigned0x20int0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeUnicodeEscapeOptional0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cchar0x2C0x20true0x3E0x3A0x3Apop_back0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AadvanceInJSXChild0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeHTMLEntityOptional0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AisCurrentTokenADirective0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Cfalse0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_peekUTF80x28char0x20const0x2A0x290x20const0x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_peekUTF80x28char0x20const0x2A0x290x20const0x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3ArescanRBraceInTemplateLiteral0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3Alookahead10x28hermes0x3A0x3AOptValue0x3Chermes0x3A0x3Aparser0x3A0x3ATokenKind0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeOctal0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x20const0x260x2C0x20unsigned0x20int0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanReservedWord0x28char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AinitStorageWith0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeIDContinue0x28unsigned0x20int0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2910x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeOneIdentifierPartNoEscape0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2910x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2920x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeOneIdentifierPartNoEscape0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2920x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AdecodeUTF80x280x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3A0x3Aoperator0x280x290x28llvh0x3A0x3ATwine0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_decodeUTF8SlowPath0x28char0x20const0x2A0x260x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3A0x3Aoperator0x280x290x28llvh0x3A0x3ATwine0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AStringTable0x3A0x3AgetString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AStringSetVector0x3A0x3Ainsert0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Adeque0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Aemplace_back0x3Cchar0x20const0x2A0x2C0x20char0x20const0x2A0x3E0x28char0x20const0x2A0x260x260x2C0x20char0x20const0x2A0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceMap0x3A0x3AgetSourceFullPath0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceMap0x3A0x3A0x7ESourceMap0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adeque0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fadd_back_capacity0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x3E0x3A0x3Apush_back0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x3E0x3A0x3Apush_front0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x260x3E0x3A0x3Apush_back0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x3E0x260x3E0x3A0x3Apush_front0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AUniquingFilenameTable0x3A0x3AaddFilename0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AUniquingFilenameTable0x3A0x3AtoStorage0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingFilenameTable0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugScopeDescriptor0x3A0x3AFlags0x3A0x3AFlags0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendString0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Atry_emplace0x3Cunsigned0x20long0x3E0x28hermes0x3A0x3AUniqueString0x2A0x260x260x2C0x20unsigned0x20long0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Cfalse0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendString0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20hermes0x3A0x3AIdentifier0x290x3A0x3A0x24_00x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendString0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20hermes0x3A0x3AIdentifier0x290x3A0x3A0x24_00x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cchar0x20const0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Ainsert0x3Cchar0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x20const0x2A0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfo0x3A0x3AgetLocationForAddress0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AFunctionDebugInfoDeserializer0x3A0x3Anext0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfo0x3A0x3AgetTextifiedCalleeUTF80x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendSourceLocations0x28hermes0x3A0x3Ahbc0x3A0x3ADebugSourceLocation0x20const0x260x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugSourceLocation0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3ADebugInfoGenerator0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingFilenameTable0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendTextifiedCalleeData0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugTextifiedCallee0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendScopeDesc0x28hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ADebugScopeDescriptor0x3A0x3AFlags0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AIdentifier0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AserializeWithMove0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Ainsert0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfo0x3A0x3ADebugInfo0x28hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x260x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugFileRegion0x2C0x201u0x3E0x260x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AStreamVector0x3Cunsigned0x20char0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20unsigned0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASHA10x3A0x3AhashBlock0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASHA10x3A0x3Apad0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASHA10x3A0x3Ahash0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AsanityCheck0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABytecodeForm0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Ahbc0x3A0x3AvisitBytecodeSegmentsInOrder0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFileFields0x3Cfalse0x3E0x3A0x3ApopulateFromBuffer0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABytecodeForm0x290x3A0x3ABytecodeFileFieldsPopulator0x3E0x28hermes0x3A0x3Ahbc0x3A0x3ABytecodeFileFields0x3Cfalse0x3E0x3A0x3ApopulateFromBuffer0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABytecodeForm0x290x3A0x3ABytecodeFileFieldsPopulator0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFileFields0x3Cfalse0x3E0x3A0x3ApopulateFromBuffer0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABytecodeForm0x290x3A0x3ABytecodeFileFieldsPopulator0x3A0x3AvisitCJSModuleTable0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3A0x3AfindCatchTargetOffset0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3A0x3AgetVirtualOffsetForFunction0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AstopWarmup0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AstartWarmup0x28unsigned0x20char0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3Awarmup0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aatomic0x3Cbool0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_void0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_proxy0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3E0x3E0x2C0x20void0x200x280x2A0x290x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aatomic0x3Cbool0x3E0x2A0x290x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aatomic0x3Cbool0x3E0x2A0x3E0x3E0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3Amadvise0x28hermes0x3A0x3Aoscompat0x3A0x3AMAdvice0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AadviseStringTableSequential0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AadviseStringTableRandom0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AwillNeedStringTable0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AstartPageAccessTracker0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3ABCProviderFromBuffer0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABuffer0x20const0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABuffer0x20const0x3E0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABytecodeForm0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetEpilogue0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetSourceHash0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AcreateDebugInfo0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugFileRegion0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugFileRegion0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetExceptionTableAndDebugOffsets0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ASmallFuncHeader0x3A0x3AgetLargeHeaderOffset0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AbytecodeHashIsValid0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetStringTableEntry0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetFunctionHeader0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetBytecode0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetExceptionTable0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetDebugOffsets0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3A0x7EBCProviderFromBuffer0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AisFunctionLazy0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AisLazy0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetPageAccessTracker0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetRawBuffer0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASimpleDiagHandler0x3A0x3Ahandler0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20void0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASMDiagnostic0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Aassign0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASMFixIt0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASMFixIt0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASimpleDiagHandler0x3A0x3AgetErrorString0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASimpleDiagHandlerRAII0x3A0x3ASimpleDiagHandlerRAII0x28hermes0x3A0x3ASourceErrorManager0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASimpleDiagHandlerRAII0x3A0x3A0x7ESimpleDiagHandlerRAII0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ASMDiagnostic0x3A0x3A0x7ESMDiagnostic0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_isprint(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AgetBuiltinMethodName0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ATerminatorInst0x3A0x3AgetNumSuccessors0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ATerminatorInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACondBranchInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AGetPNamesInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AGetNextPNameInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACheckHasInstanceInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ATryStartInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACompareBranchInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchImmInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASaveAndYieldInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3AgetCasePair0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASwitchImmInst0x3A0x3AgetCasePair0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AUnaryOperatorInst0x3A0x3AparseOperator0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AUnaryOperatorInst0x3A0x3AgetSideEffect0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABinaryOperatorInst0x3A0x3AparseOperator0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABinaryOperatorInst0x3A0x3AparseAssignmentOperator0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABinaryOperatorInst0x3A0x3AgetBinarySideEffect0x28hermes0x3A0x3AType0x2C0x20hermes0x3A0x3AType0x2C0x20hermes0x3A0x3ABinaryOperatorInst0x3A0x3AOpKind0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3ASwitchInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ALiteral0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3AgetNumCasePair0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3AgetDefaultDestination0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3AgetInputValue0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3APhiInst0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AValue0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AgetNumEntries0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AgetEntry0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AupdateEntry0x28unsigned0x20int0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AaddEntry0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AremoveEntry0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AGetPNamesInst0x3A0x3AGetPNamesInst0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AGetNextPNameInst0x3A0x3AGetNextPNameInst0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchImmInst0x3A0x3ASwitchImmInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ALiteralNumber0x2A0x2C0x20hermes0x3A0x3ALiteralNumber0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ALiteralNumber0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AisIdenticalTo0x28hermes0x3A0x3AInstruction0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetHashCode0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Ahash_code0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_recursive_helper0x3A0x3Acombine0x3Chermes0x3A0x3AInstruction0x3A0x3AVariety0x2C0x20unsigned0x20int0x3E0x28unsigned0x20long0x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20hermes0x3A0x3AInstruction0x3A0x3AVariety0x20const0x260x2C0x20unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AescapeStr0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AquoteStr0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstructionNamer0x3A0x3AgetNumber0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintTypeLabel0x28hermes0x3A0x3AType0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintValueLabel0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACallBuiltinInst0x3A0x3AgetBuiltinIndex0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AGetBuiltinClosureInst0x3A0x3AgetBuiltinIndex0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Acast_retty0x3Chermes0x3A0x3AFunction0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x3A0x3Aret_type0x20llvh0x3A0x3Adyn_cast0x3Chermes0x3A0x3AFunction0x2C0x20hermes0x3A0x3AValue0x3E0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionName0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AIRPrinter0x3A0x3APrintFunctionParams0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintScopeLabel0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintVariableName0x28hermes0x3A0x3AVariable0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintScopeChain0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintScopeRange0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionHeader0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionVariables0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AFunction0x3A0x3AforEachScopeImpl0x3Chermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionVariables0x28hermes0x3A0x3AFunction0x2A0x290x3A0x3A0x24_00x3E0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionVariables0x28hermes0x3A0x3AFunction0x2A0x290x3A0x3A0x24_00x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintInstructionDestination0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintInstruction0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x3A0x3AcopyFrom0x28llvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28hermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACodeGenerationSettings0x3A0x3A0x7ECodeGenerationSettings0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintSourceLocation0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintSourceLocation0x28llvh0x3A0x3ASMRange0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitModule0x28hermes0x3A0x3AModule0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitScope0x28hermes0x3A0x3AScopeDesc0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitInstruction0x28hermes0x3A0x3AInstruction0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitBasicBlock0x28hermes0x3A0x3ABasicBlock0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitFunction0x28hermes0x3A0x3AFunction0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3A0x7EIRPrinter0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3A0x7EIRPrinter0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AInstruction0x2A0x3E0x28hermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20hermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AInstruction0x2A0x3E0x28hermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnext_prime0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3Alower_bound0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C4ul0x200x3D0x3D0x2040x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcheck_for_overflow0x5Babi0x3Av150070x5D0x3C4ul0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3Alower_bound0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_overflow_error0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Flower_bound_impl0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x20const0x2A0x3E0x3A0x3Adifference_type0x20std0x3A0x3A_0x5F20x3A0x3A_IterOps0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x3E0x3A0x3Adistance0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_integral0x3Clong0x3E0x3A0x3Avalue0x2C0x20long0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhalf_positive0x5Babi0x3Av150070x5D0x3Clong0x3E0x28long0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_IterOps0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x3E0x3A0x3Aadvance0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x2C0x20long0x3E0x28unsigned0x20int0x20const0x2A0x260x2C0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_decltype0x28std0x3A0x3Adeclval0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x3E0x280x290x28std0x3A0x3Adeclval0x3Cunsigned0x20int0x20const0x260x3E0x280x290x290x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finvoke0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x2C0x20unsigned0x20int0x20const0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x2C0x20unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_decltype0x28std0x3A0x3Adeclval0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x260x3E0x280x290x28std0x3A0x3Adeclval0x3Cunsigned0x20int0x20const0x260x3E0x280x290x2C0x20std0x3A0x3Adeclval0x3Cunsigned0x20long0x20const0x260x3E0x280x290x290x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finvoke0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x260x2C0x20unsigned0x20int0x20const0x260x2C0x20unsigned0x20long0x20const0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x260x2C0x20unsigned0x20int0x20const0x260x2C0x20unsigned0x20long0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x20const0x2A0x3E0x3A0x3Adifference_type0x20std0x3A0x3A_0x5F20x3A0x3Adistance0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Aadvance0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x2C0x20long0x2C0x20long0x2C0x20void0x3E0x28unsigned0x20int0x20const0x2A0x260x2C0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20long0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28unsigned0x20int0x20const0x260x2C0x20unsigned0x20long0x20const0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20const0x260x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x3A0x3Aoperator0x280x290x3Cunsigned0x20int0x20const0x260x3E0x28unsigned0x20int0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x20const0x2A0x3E0x3A0x3Adifference_type0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdistance0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Arandom_access_iterator_tag0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fadvance0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x3E0x28unsigned0x20int0x20const0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x20const0x2A0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Arandom_access_iterator_tag0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AValue0x3A0x3Adestroy0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3A0x7EInstruction0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AAllocStackInst0x3A0x3A0x7EAllocStackInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AScopeDesc0x3A0x3A0x7EScopeDesc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aiplist_impl0x3Cllvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AInstruction0x3E0x2C0x20llvh0x3A0x3Ailist_traits0x3Chermes0x3A0x3AInstruction0x3E0x3E0x3A0x3A0x7Eiplist_impl0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AFunction0x3A0x3A0x7EFunction0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3A0x7EModule0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AValue0x3A0x3AgetUsers0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AValue0x3A0x3AgetNumUsers0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AValue0x3A0x3AhasUsers0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AValue0x3A0x3AhasOneUser0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AValue0x3A0x3AremoveUse0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AValue0x3A0x3AreplaceAllUsesWith0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AsetOperand0x28hermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AreplaceFirstOperandWith0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AScopeDesc0x3A0x3AisGlobalScope0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AFunction0x28hermes0x3A0x3AValueKind0x2C0x20hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20bool0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AderiveUniqueInternalName0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Atry_emplace0x3Cint0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20int0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AgetDefinitionKindStr0x28bool0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AgetDescriptiveDefinitionKindStr0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AgetSourceRepresentationStr0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3ABasicBlock0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRVisitor0x3Chermes0x3A0x3AIRPrinter0x2C0x20void0x3E0x3A0x3Avisit0x28hermes0x3A0x3AValue0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Chermes0x3A0x3AValue0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AgetContext0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3AprintAsOperand0x28llvh0x3A0x3Araw_ostream0x260x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetNumOperands0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3ApushOperand0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetOperand0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AremoveOperand0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AmoveBefore0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AeraseFromParent0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AeraseFromParentNoDestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3AeraseFromParent0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetName0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetDerivedSideEffect0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABinaryOperatorInst0x3A0x3AgetSideEffect0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ACompareBranchInst0x3A0x3AgetSideEffect0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetChangedOperands0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AParameter0x3A0x3AParameter0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AVariable0x3A0x3AVariable0x28hermes0x3A0x3AValueKind0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AVariable0x3A0x3AgetIndexInVariableList0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AParameter0x3A0x3AgetName0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3AgetTerminator0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3AgetTerminator0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3Ashrink_and_clear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Chermes0x3A0x3AModule0x3A0x3ACJSModule0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AModule0x3A0x3ACJSModule0x3E0x3E0x3A0x3A0x7E_0x5Fdeque_base0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AaddGlobalProperty0x28hermes0x3A0x3AIdentifier0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AIdentifier0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetLiteralString0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20void0x2A0x3E0x2A0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3AFunction0x2A0x260x260x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x3E0x28hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3AFunction0x2A0x260x260x3E0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3AFunction0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetFunctionsInSegment0x28unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AFunction0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3A0x3Apop_back0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20void0x2A0x3E0x2A0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3AFunction0x2A0x20const0x260x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x3E0x28hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3AFunction0x2A0x20const0x260x3E0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3A0x3Ainsert0x3Cllvh0x3A0x3ASmallPtrSetIterator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x28llvh0x3A0x3ASmallPtrSetIterator0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3ASmallPtrSetIterator0x3Chermes0x3A0x3AFunction0x2A0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28hermes0x3A0x3AFunction0x2A0x260x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetTemplateObjectID0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20hermes0x3A0x3AModule0x3A0x3AHashRawStrings0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AModule0x3A0x3AHashRawStrings0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20int0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x260x260x2C0x20int0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetContext0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3Adump0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AModule0x3A0x3Adump0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetLiteralNumber0x28double0x29(w2c_hermes*, u32, f64);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetLiteralBigInt0x28hermes0x3A0x3AUniqueString0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetLiteralBool0x28bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AType0x3A0x3Aprint0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3AType0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AIdentifier0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AIdentifier0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20hermes0x3A0x3AIdentifier0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fdo_rehash0x3Ctrue0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AFunction0x2A0x3E0x28hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AFunction0x2A0x3E0x28hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AFunction0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Ahash_code0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_range_impl0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3ALiteralString0x2A0x20const0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3ALiteralString0x2A0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3ALiteralString0x2A0x20const0x2A0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20hermes0x3A0x3AModule0x3A0x3AHashRawStrings0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AModule0x3A0x3AHashRawStrings0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteralString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteralString0x2A0x3E0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3A_0x5Fdo_rehash0x3Ctrue0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateBasicBlock0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x2C0x20bool0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIdentifier0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGeneratorFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGeneratorInnerFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTopLevelFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x2C0x20bool0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAsyncFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGlobalObjectProperty0x28hermes0x3A0x3AIdentifier0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateParameter0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThisParameter0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateVariable0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralNumber0x28double0x29(w2c_hermes*, u32, f64);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralPositiveZero0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralBigInt0x28hermes0x3A0x3AUniqueString0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralString0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralBool0x28bool0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralEmpty0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralUndefined0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralNull0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetGlobalObject0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateBranchInst0x28hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetInsertionBlock0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCondBranchInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateReturnInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCatchInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThrowInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryStartInst0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryEndInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocStackInst0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocStackInst0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAsNumberInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAsNumericInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThrowIfHasRestrictedGlobalPropertyInst0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateScopeInst0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateInnerScopeInst0x28hermes0x3A0x3AScopeCreationInst0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateFunctionInst0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadFrameInst0x28hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadStackInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreFrameInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreStackInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCallInst0x28hermes0x3A0x3ALiteralString0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCCallNInst0x28hermes0x3A0x3ALiteralString0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AHBCCallNInst0x3A0x3AHBCCallNInst0x28hermes0x3A0x3ALiteralString0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteralUndefined0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateConstructInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryLoadGlobalPropertyInst0x28hermes0x3A0x3ALiteralString0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ATryLoadGlobalPropertyInst0x3A0x3ATryLoadGlobalPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteralString0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryLoadGlobalPropertyInst0x28hermes0x3A0x3AGlobalObjectProperty0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateDeletePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStorePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryStoreGlobalPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteralString0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ATryStoreGlobalPropertyInst0x3A0x3ATryStoreGlobalPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteralString0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryStoreGlobalPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreOwnPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIRBuilder0x3A0x3APropEnumerable0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreNewOwnPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3AIRBuilder0x3A0x3APropEnumerable0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AStoreNewOwnPropertyInst0x3A0x3AStoreNewOwnPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3ALiteralBool0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreGetterSetterInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIRBuilder0x3A0x3APropEnumerable0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryLoadGlobalPropertyInst0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryLoadGlobalPropertyInst0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStorePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStorePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocObjectInst0x28unsigned0x20int0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocArrayInst0x28hermes0x3A0x3ALiteralNumber0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AValue0x2A0x2C0x204u0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocArrayInst0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AValue0x2A0x2C0x204u0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AValue0x2A0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AValue0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateArgumentsInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGetNewTargetInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThrowIfEmptyInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCGetGlobalObjectInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateRegExpInst0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateUnaryOperatorInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AUnaryOperatorInst0x3A0x3AOpKind0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateBinaryOperatorInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABinaryOperatorInst0x3A0x3AOpKind0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateSwitchInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ALiteral0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreatePhiInst0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AValue0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGetPNamesInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGetNextPNameInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateMovInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateImplicitMovInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateDebuggerInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateSaveAndYieldInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateGeneratorInst0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStartGeneratorInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateResumeGeneratorInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCResolveEnvironment0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCStoreToEnvironmentInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AVariable0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCLoadFromEnvironmentInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AVariable0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateSwitchImmInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ALiteralNumber0x2A0x2C0x20hermes0x3A0x3ALiteralNumber0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ALiteralNumber0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateDirectEvalInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteralBool0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCLoadConstInst0x28hermes0x3A0x3ALiteral0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCLoadParamInst0x28hermes0x3A0x3ALiteralNumber0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCCreateEnvironmentInst0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCCreateInnerEnvironmentInst0x28hermes0x3A0x3AScopeCreationInst0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCGetThisNSInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCGetArgumentsPropByValInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCGetArgumentsLengthInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCReifyArgumentsInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCCreateThisInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCConstructInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCGetConstructedObjectInst0x28hermes0x3A0x3AHBCCreateThisInst0x2A0x2C0x20hermes0x3A0x3AHBCConstructInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCProfilePointInst0x28unsigned0x20short0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCallBuiltinInst0x28hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACallBuiltinInst0x3A0x3ACallBuiltinInst0x28hermes0x3A0x3ALiteralNumber0x2A0x2C0x20hermes0x3A0x3ALiteralUndefined0x2A0x2C0x20hermes0x3A0x3ALiteralUndefined0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGetBuiltinClosureInst0x28hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AGetBuiltinClosureInst0x3A0x3AGetBuiltinClosureInst0x28hermes0x3A0x3ALiteralNumber0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCCreateFunctionInst0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCSpillMovInst0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCCreateGeneratorInst0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCAllocObjectFromBufferInst0x28llvh0x3A0x3ASmallVector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x3E0x2C0x204u0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AHBCAllocObjectFromBufferInst0x3A0x3AHBCAllocObjectFromBufferInst0x28hermes0x3A0x3ALiteralNumber0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x3E0x2C0x204u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCompareBranchInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABinaryOperatorInst0x3A0x3AOpKind0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIteratorBeginInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIteratorNextInst0x28hermes0x3A0x3AAllocStackInst0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIteratorCloseInst0x28hermes0x3A0x3AAllocStackInst0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateUnreachableInst0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AsetInsertionBlock0x28hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AsetInsertionPointAfter0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AsetInsertionPoint0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInternalIdentifierMaker0x3A0x3Anext0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetParams0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetBlockStatement0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetProperty0x28hermes0x3A0x3AESTree0x3A0x3AMemberExpressionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetComputed0x28hermes0x3A0x3AESTree0x3A0x3AMemberExpressionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetCallee0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetArguments0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AhasSimpleParams0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AhasParamExpressions0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AisGenerator0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AisAsync0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenBody0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenStatement0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AIsLoopBody0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenIfStatement0x28hermes0x3A0x3AESTree0x3A0x3AIfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForInStatement0x28hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenReturnStatement0x28hermes0x3A0x3AESTree0x3A0x3AReturnStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExpressionWrapper0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenSwitchStatement0x28hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenVariableDeclaration0x28hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenBlockStatement0x28hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AIsLoopBody0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3AinitLabel0x28hermes0x3A0x3AESTree0x3A0x3ALabelDecorationBase0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForWhileLoops0x28hermes0x3A0x3AESTree0x3A0x3ALoopStatementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3Alabel0x28hermes0x3A0x3AESTree0x3A0x3ALabelDecorationBase0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExportDefaultDeclaration0x28hermes0x3A0x3AESTree0x3A0x3AExportDefaultDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFunctionBody0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenCatchHandler0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AareAllCasesConstant0x28hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ALiteral0x2A0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenConstSwitchStmt0x28hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ALiteral0x2A0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenVariableDeclarator0x28hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclaratorNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenImportDeclaration0x28hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ALiteral0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x260x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x260x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AprepareCatch0x28hermes0x3A0x3AESTree0x3A0x3ACatchClauseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFinallyBeforeControlChange0x28hermes0x3A0x3Airgen0x3A0x3ASurroundingTry0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3ASurroundingTry0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x260x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x260x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExpression0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ANode0x3A0x3AgetNodeName0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenIdentifierExpression0x28hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenRegExpLiteral0x28hermes0x3A0x3AESTree0x3A0x3ARegExpLiteralNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAssignmentExpr0x28hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenCallExpr0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenOptionalCallExpr0x28hermes0x3A0x3AESTree0x3A0x3AOptionalCallExpressionNode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenNewExpr0x28hermes0x3A0x3AESTree0x3A0x3ANewExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenMemberExpression0x28hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AMemberExpressionOperation0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenOptionalMemberExpression0x28hermes0x3A0x3AESTree0x3A0x3AOptionalMemberExpressionNode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AMemberExpressionOperation0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenArrayFromElements0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenObjectExpr0x28hermes0x3A0x3AESTree0x3A0x3AObjectExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenLogicalExpression0x28hermes0x3A0x3AESTree0x3A0x3ALogicalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenBinaryExpression0x28hermes0x3A0x3AESTree0x3A0x3ABinaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenUnaryExpression0x28hermes0x3A0x3AESTree0x3A0x3AUnaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenMetaProperty0x28hermes0x3A0x3AESTree0x3A0x3AMetaPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenUpdateExpr0x28hermes0x3A0x3AESTree0x3A0x3AUpdateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenConditionalExpr0x28hermes0x3A0x3AESTree0x3A0x3AConditionalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenSequenceExpr0x28hermes0x3A0x3AESTree0x3A0x3ASequenceExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTemplateLiteralExpr0x28hermes0x3A0x3AESTree0x3A0x3ATemplateLiteralNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTaggedTemplateExpr0x28hermes0x3A0x3AESTree0x3A0x3ATaggedTemplateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAwaitExpr0x28hermes0x3A0x3AESTree0x3A0x3AAwaitExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x3E0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenLogicalAssignmentExpr0x28hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x2A0x2C0x20hermes0x3A0x3ABinaryOperatorInst0x3A0x3AOpKind0x2C0x20hermes0x3A0x3Airgen0x3A0x3ALReference0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenCallEvalExpr0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitCall0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionLikeNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ApropertyKeyAsString0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMap0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenObjectExpr0x28hermes0x3A0x3AESTree0x3A0x3AObjectExpressionNode0x2A0x290x3A0x3APropertyValue0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3Aoperator0x5B0x5D0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringMapIterator0x3Cllvh0x3A0x3ASMRange0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3AStringMap0x3Cllvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3ASMRange0x3E0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASMRange0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExpressionBranch0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenResumeGenerator0x28hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AGenFinally0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldOrAwaitExpr0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenLogicalExpressionBranch0x28hermes0x3A0x3AESTree0x3A0x3ALogicalExpressionNode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A0x7E_0x5Fbase0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x260x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x260x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_hashable_data0x3Cchar16_t0x20const0x3E0x3A0x3Avalue0x2C0x20llvh0x3A0x3Ahash_code0x3E0x3A0x3Atype0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_range_impl0x3Cchar16_t0x20const0x3E0x28char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3AFunctionContext0x28hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3Airgen0x3A0x3AGotoLabel0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3A0x7EFunctionContext0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x3A0x3AclearCurrentScope0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3AgenAnonymousLabelName0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3A0x3AEnterBlockScope0x28hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3A0x3A0x7EEnterBlockScope0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFunctionDeclaration0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAsyncFunction0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenGeneratorFunction0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenES5Function0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAnonymousFunctionNameIfNeeded0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AsetupLazyScope0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitFunctionPreamble0x28hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AinitCaptureStateInES5Function0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitTopLevelDeclarations0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3ADoEmitParameters0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitFunctionEpilogue0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitCreateFunction0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AhoistCreateFunctions0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFunctionExpression0x28hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAnonymousLabelName0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenArrowFunctionExpression0x28hermes0x3A0x3AESTree0x3A0x3AArrowFunctionExpressionNode0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x260x20std0x3A0x3A_0x5F20x3A0x3Aoptional0x3Chermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x3A0x3Aemplace0x5Babi0x3Av150070x5D0x3Chermes0x3A0x3Airgen0x3A0x3AFunctionContext0x2A0x2C0x20void0x3E0x28hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitParameters0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AcreateNewBinding0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AcreateScopeBindings0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFunctionDeclarations0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x3A0x3AsetInCurrentScope0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20hermes0x3A0x3AValue0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenSyntaxErrorFunction0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_decltype0x28auto0x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fvisitation0x3A0x3A_0x5Fbase0x3A0x3A_0x5Fdispatcher0x3C0ul0x3E0x3A0x3A_0x5Fdispatch0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fdtor0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Ftraits0x3Cstd0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x2C0x200x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x3E0x3A0x3A_0x5Fdestroy0x5Babi0x3Av150070x5D0x280x290x3A0x3A0x27lambda0x270x28auto0x260x290x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x3E0x28auto0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_decltype0x28auto0x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fvisitation0x3A0x3A_0x5Fbase0x3A0x3A_0x5Fdispatcher0x3C1ul0x3E0x3A0x3A_0x5Fdispatch0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fdtor0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Ftraits0x3Cstd0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x2C0x200x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x3E0x3A0x3A_0x5Fdestroy0x5Babi0x3Av150070x5D0x280x290x3A0x3A0x27lambda0x270x28auto0x260x290x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x3E0x28auto0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_decltype0x28auto0x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fvisitation0x3A0x3A_0x5Fbase0x3A0x3A_0x5Fdispatcher0x3C2ul0x3E0x3A0x3A_0x5Fdispatch0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fdtor0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Ftraits0x3Cstd0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x2C0x200x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x3E0x3A0x3A_0x5Fdestroy0x5Babi0x3Av150070x5D0x280x290x3A0x3A0x27lambda0x270x28auto0x260x290x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x3E0x28auto0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x3A0x3Apop0x28hermes0x3A0x3AIdentifier0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20const0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AisConstantExpr0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AemitLoad0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitLoad0x28hermes0x3A0x3AValue0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AemitStore0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitStore0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringAssignment0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3APatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringArray0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringObject0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AcastAsVariable0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AcastAsGlobalObjectProperty0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AESTreeIRGen0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x3E0x3E0x20const0x260x2C0x20hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AScopeChain0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AresolveScopeIdentifiers0x28hermes0x3A0x3AScopeChain0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AdoIt0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AmaterializeScopeChain0x28hermes0x3A0x3AIRBuilder0x260x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3ASerializedScope0x20const0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ApopulateNameTable0x28hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x260x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AprocessDeclarationFile0x28hermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20hermes0x3A0x3AValue0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3A0x3AshouldVisit0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AESTreeVisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AdeclareAmbientGlobalProperty0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x3A0x3AFindAndConstruct0x28unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AdoLazyFunction0x28hermes0x3A0x3Ahbc0x3A0x3ALazyCompilationData0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AIdentifier0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AdeclareVariableOrGlobalProperty0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AProgramNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AensureVariableExists0x28hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenMemberExpressionProperty0x28hermes0x3A0x3AESTree0x3A0x3AMemberExpressionLikeNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AcanCreateLRefWithoutSideEffects0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AcreateLRef0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenHermesInternalCall0x28llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenBuiltinCall0x28hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitEnsureObject0x28hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitGetIteratorSlow0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitIteratorCompleteSlow0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitIteratorValueSlow0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitIteratorCloseSlow0x28hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AIteratorRecordSlow0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitGetIterator0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringArray0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitRestElement0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3ARestElementNode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AIteratorRecord0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3ASharedExceptionHandler0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitOptionalInitialization0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitRestProperty0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3ARestElementNode0x2A0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AValue0x2A0x3E0x20const0x260x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASetVector0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ALiteral0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28hermes0x3A0x3ALiteral0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AserializeScope0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenRaiseNativeError0x28hermes0x3A0x3AIRBuilder0x260x2C0x20hermes0x3A0x3ANativeErrorTypes0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AnewDeclarativeEnvironment0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AblockDeclarationInstantiation0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AIdentifier0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20hermes0x3A0x3AIdentifier0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AIdentifier0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x20const0x260x2C0x20unsigned0x20int0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Cunsigned0x20int0x3E0x28unsigned0x20int0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AIdentifier0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20hermes0x3A0x3AIdentifier0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AIdentifier0x3E0x28hermes0x3A0x3AIdentifier0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AScopedHashTableNode0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AArrowFunctionExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AComponentDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AHookDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AWhileStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADoWhileStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ABreakStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AContinueStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AThrowStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AReturnStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ALabeledStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AExpressionStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AIfStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ASequenceExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AArrayExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ASpreadElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ANewExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AAwaitExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AImportExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AOptionalCallExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AUnaryExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AUpdateExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AOptionalMemberExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ALogicalExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AConditionalExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ABinaryExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADirectiveNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3APrivateNameNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AMetaPropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ASwitchCaseNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ACatchClauseNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclaratorNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATemplateLiteralNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATaggedTemplateExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3APropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassBodyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassPropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassPrivatePropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AMethodDefinitionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AImportSpecifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AImportDefaultSpecifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AImportNamespaceSpecifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AImportAttributeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AExportNamedDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AExportSpecifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AExportNamespaceSpecifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AExportDefaultDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AExportAllDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ARestElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentPatternNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXMemberExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXNamespacedNameNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXExpressionContainerNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXSpreadChildNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXOpeningElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXClosingElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXAttributeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXSpreadAttributeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AJSXFragmentNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AHookTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeParamNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeParameterNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ANullableTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeIdentifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeofTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AKeyofTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeOperatorNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeofIdentifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeSpreadElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeLabeledElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AArrayTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AInferTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AUnionTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AIntersectionTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AGenericTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AIndexedAccessTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AOptionalIndexedAccessTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AConditionalTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypePredicateNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeAliasNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AOpaqueTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareTypeAliasNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareOpaqueTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareInterfaceNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareClassNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareFunctionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareHookNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareComponentNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareVariableNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareEnumNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportAllDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareNamespaceNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleExportsNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceExtendsNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassImplementsNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypePropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeSpreadPropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeInternalSlotNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeCallPropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeIndexerNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeMappedTypePropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeParameterDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeParameterNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeParameterInstantiationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATypeCastExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AAsExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AAsConstExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ADeclaredPredicateNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumStringBodyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumNumberBodyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumBooleanBodyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumSymbolBodyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumDefaultedMemberNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumStringMemberNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumNumberMemberNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AEnumBooleanMemberNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AComponentParameterNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAnnotationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSLiteralTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexedAccessTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSArrayTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeReferenceNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSQualifiedNameNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSFunctionTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSConstructorTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypePredicateNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTupleTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAssertionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSAsExpressionNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSParameterPropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAliasDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceHeritageNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceBodyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumMemberNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleBlockNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleMemberNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeParameterDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeParameterNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeParameterInstantiationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSUnionTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSIntersectionTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeQueryNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSConditionalTypeNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeLiteralNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSPropertySignatureNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSMethodSignatureNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexSignatureNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ATSCallSignatureDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ACoverInitializerNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ACoverRestElementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3ACoverTypedIdentifierNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ALiteral0x2A0x3E0x28hermes0x3A0x3ALiteral0x2A0x20const0x260x2C0x20hermes0x3A0x3ALiteral0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ALiteral0x2A0x3E0x28hermes0x3A0x3ALiteral0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A_0x5Fon_zero_shared_weak0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeAnnotationTS0x28llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTypeParameters0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSFunctionOrParenthesizedType0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AIsConstructorType0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSUnionType0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTypeParameter0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSFunctionTypeParam0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseIdentifierAsTSTypeAnnotation0x28hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSIntersectionType0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSPostfixType0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSPrimaryType0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTupleType0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSFunctionTypeParams0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSDeclaration0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSInterfaceDeclaration0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTypeAliasDeclaration0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSNamespaceDeclaration0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSEnumDeclaration0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTypeReference0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSObjectTypeMember0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSQualifiedName0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSEnumMember0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTypeArguments0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSIndexSignature0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSObjectType0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTSTypeQuery0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFlowDeclaration0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentDeclarationFlow0x28llvh0x3A0x3ASMLoc0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseHookDeclarationFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseEnumDeclarationFlow0x28llvh0x3A0x3ASMLoc0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeAliasFlow0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ATypeAliasKind0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseInterfaceDeclarationFlow0x28llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckComponentDeclarationFlow0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeParamsFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentTypeParametersFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentParametersFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentRenderTypeFlow0x28bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ADeclareComponentNode0x3A0x3ADeclareComponentNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AComponentDeclarationNode0x3A0x3AComponentDeclarationNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckHookDeclarationFlow0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseReturnTypeAnnotationFlow0x28llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowAnonFunctionType0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AHookDeclarationNode0x3A0x3AHookDeclarationNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseEnumBodyFlow0x28hermes0x3A0x3AOptValue0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AEnumKind0x3E0x2C0x20llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseConditionalTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseInterfaceTailFlow0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareFLow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareClassFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareFunctionOrHookFlow0x28llvh0x3A0x3ASMLoc0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareHookFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareModuleFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareNamespaceFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclareExportFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseInterfaceExtends0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassImplementsFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseObjectTypeAnnotationFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowProtoProperty0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowStaticProperty0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowSpreadProperty0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ADeclareClassNode0x3A0x3ADeclareClassNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ADeclareExportDeclarationNode0x3A0x3ADeclareExportDeclarationNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeParamFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentTypeRestParameterFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentTypeParameterFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentParameterFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseRenderTypeOperator0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePrefixTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePostfixTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeAnnotationFlow0x28llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowAnonFunctionType0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseComponentTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeAnnotationBeforeColonFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseTypeAnnotationAsIdFlow0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseGenericTypeFlow0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseObjectTypePropertiesFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowProtoProperty0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowStaticProperty0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowSpreadProperty0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20bool0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AObjectTypeAnnotationNode0x3A0x3AObjectTypeAnnotationNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeArgsFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionTypeAnnotationParamsFlow0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePredicateFlow0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AFunctionTypeAnnotationNode0x3A0x3AFunctionTypeAnnotationNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AHookTypeAnnotationNode0x3A0x3AHookTypeAnnotationNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionTypeAnnotationParamFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExportTypeDeclarationFlow0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseUnionTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseIntersectionTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAnonFunctionWithoutParensTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionTypeAnnotationWithParamsFlow0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePrimaryTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionOrHookTypeAnnotationFlow0x28bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionOrGroupTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeofTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTupleTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseHookTypeAnnotationFlow0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AInterfaceTypeAnnotationNode0x3A0x3AInterfaceTypeAnnotationNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTupleElementFlow0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePropertyTypeAnnotationFlow0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowProtoProperty0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowStaticProperty0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseMethodishTypeAnnotationFlow0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeMappedTypePropertyFlow0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeIndexerPropertyFlow0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseMethodTypePropertyFlow0x28llvh0x3A0x3ASMLoc0x2C0x20bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeCallPropertyFlow0x28llvh0x3A0x3ASMLoc0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypePropertyFlow0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseGetOrSetTypePropertyFlow0x28llvh0x3A0x3ASMLoc0x2C0x20bool0x2C0x20bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseEnumMemberFlow0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSX0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXFragment0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXElement0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXChildren0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXOpeningElement0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXElementName0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowJSXMemberExpression0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXSpreadAttribute0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXAttribute0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXClosing0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseJSXChildExpression0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AJSParserImpl0x28hermes0x3A0x3AContext0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AMemoryBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AinitializeIdentifiers0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AJSParserImpl0x28hermes0x3A0x3AContext0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Aparser0x3A0x3AParserPass0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3APreParsedData0x3A0x3AgetBufferInfo0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3Aparse0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseProgram0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDirective0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseStatementListItem0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowImportExport0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AerrorExpected0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3Aparser0x3A0x3ATokenKind0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3Aneed0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3Aeat0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckAndEat0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckAndEat0x28hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckAsyncFunction0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AeatSemi0x28bool0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ArecursionDepthExceeded0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ANode0x3A0x3Aoperator0x20new0x28unsigned0x20long0x2C0x20hermes0x3A0x3AContext0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionHelper0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingIdentifier0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFormalParameters0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x3A0x3AFunctionDeclarationNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x3A0x3ABlockStatementNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x3A0x3AFunctionExpressionNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionBody0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20bool0x2C0x20bool0x2C0x20bool0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AvalidateBindingIdentifier0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3ATokenKind0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingRestElement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingElement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3AFindAndConstruct0x28llvh0x3A0x3ASMLoc0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBlock0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x3A0x3Aemplace_back0x3Cllvh0x3A0x3AStringRef0x20const0x260x3E0x28llvh0x3A0x3AStringRef0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3AFindAndConstruct0x28llvh0x3A0x3ASMLoc0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTypeAnnotation0x28llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowAnonFunctionType0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseObjectBindingPattern0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseArrayBindingPattern0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingInitializer0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseLexicalDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseEmptyStatement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseIfStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseWhileStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDoWhileStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseForStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseContinueStatement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBreakStatement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseReturnStatement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseWithStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseSwitchStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseThrowStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTryStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDebuggerStatement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExpressionOrLabelledStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseIfStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseVariableDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseLeftHandSideExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseAssignmentPattern0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssignmentExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AensureDestructuringInitialized0x28hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckDeclaration0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassTail0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AClassParseKind0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckDeclareType0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseImportDeclaration0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExportDeclaration0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssertClause0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseImportClause0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFromClause0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x3A0x3AImportDeclarationNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExportClause0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASMRange0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AToken0x3A0x3AgetResWordOrIdentifier0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePrivateName0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssignmentExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssignmentExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x290x3A0x3AState0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingProperty0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingRestProperty0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePropertyName0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseNewExpressionOrOptionalExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AIsConstructorCall0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3ASavePoint0x3A0x3ASavePoint0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3ASavePoint0x3A0x3Arestore0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseCallExpression0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseArrayAsignmentPattern0x28hermes0x3A0x3AESTree0x3A0x3AArrayExpressionNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseObjectAssignmentPattern0x28hermes0x3A0x3AESTree0x3A0x3AObjectExpressionNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePrimaryExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionExpression0x28bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseArrayLiteral0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseObjectLiteral0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTemplateLiteral0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseSpreadElement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePropertyAssignment0x28bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTemplateLiteral0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28bool0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ATemplateLiteralNode0x3A0x3ATemplateLiteralNode0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseReturnTypeAnnotation0x28llvh0x3A0x3AOptional0x3Cllvh0x3A0x3ASMLoc0x3E0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowAnonFunctionType0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseOptionalExpressionExceptNew0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AIsConstructorCall0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseOptionalExpressionExceptNew_tail0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AIsConstructorCall0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseMemberSelect0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseArguments0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3ASMLoc0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AunsafeSetPunctuator0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePostfixExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseUnaryExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBinaryExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBinaryExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_10x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconvertCurTokenToIdentOp0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBinaryExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3ATokenKind0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMLoc0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseConditionalExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AtryParseCoverTypedIdentifierNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseYieldExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassBody0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x3A0x3AClassDeclarationNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x3A0x3AClassExpressionNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassElement0x28bool0x2C0x20llvh0x3A0x3ASMRange0x2C0x20bool0x2C0x20bool0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseArrowParameters0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20bool0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseArrowFunctionExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AtryParseTypedAsyncArrowFunction0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACollectMessagesRAII0x3A0x3A0x7ECollectMessagesRAII0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseNameSpaceImport0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseNamedImports0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseImportSpecifier0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Chermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x260x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExportSpecifier0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASMRange0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ApreParseBuffer0x28hermes0x3A0x3AContext0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseLazyFunction0x28hermes0x3A0x3AESTree0x3A0x3ANodeKind0x2C0x20bool0x2C0x20bool0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x3E0x3E0x3E0x3A0x3Aresize0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x3E0x3E0x3A0x3Areset0x5Babi0x3Av150070x5D0x28hermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x3E0x3E0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cllvh0x3A0x3ASMLoc0x3E0x28llvh0x3A0x3ASMLoc0x20const0x260x2C0x20llvh0x3A0x3ASMLoc0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3ASMLoc0x3E0x28llvh0x3A0x3ASMLoc0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A_0x5Fon_zero_shared_weak0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AJSParser0x28hermes0x3A0x3AContext0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AMemoryBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AJSParser0x28hermes0x3A0x3AContext0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Aparser0x3A0x3AParserPass0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3A0x7EJSParser0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AsetStrictMode0x28bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AregisterMagicURLs0x28unsigned0x20char0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AgetUseStaticBuiltin0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3Aparse0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3ApreParseBuffer0x28hermes0x3A0x3AContext0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AparseLazyFunction0x28hermes0x3A0x3AESTree0x3A0x3ANodeKind0x2C0x20bool0x2C0x20bool0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A_0x5Fon_zero_shared_weak0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3AcanonicalizeForBlockScoping0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AvisitAndRewriteForInOf0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AvisitAndRewriteFor0x28hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ALabeledStatementNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrowFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AHookDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADoWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABreakStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AContinueStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AThrowStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AReturnStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ALabeledStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExpressionStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASpreadElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANewExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAwaitExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalCallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AUnaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AUpdateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ALogicalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AConditionalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABinaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADirectiveNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3APrivateNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMetaPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASwitchCaseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACatchClauseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclaratorNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATemplateLiteralNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATaggedTemplateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3APropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPrivatePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMethodDefinitionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportDefaultSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportNamespaceSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportNamedDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportNamespaceSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportDefaultDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportAllDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ARestElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXNamespacedNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXExpressionContainerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXSpreadChildNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXOpeningElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXClosingElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXSpreadAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXFragmentNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AHookTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeParamNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANullableTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeofTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AKeyofTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeOperatorNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeofIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeSpreadElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeLabeledElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInferTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AGenericTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AConditionalTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypePredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeAliasNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOpaqueTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareTypeAliasNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareOpaqueTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareInterfaceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareClassNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareFunctionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareHookNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareComponentNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareVariableNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareEnumNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportAllDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareNamespaceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleExportsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceExtendsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassImplementsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeSpreadPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeInternalSlotNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeCallPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeIndexerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeMappedTypePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeCastExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAsExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAsConstExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclaredPredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumDefaultedMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumStringMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumNumberMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumBooleanMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSLiteralTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSArrayTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeReferenceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSQualifiedNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSFunctionTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSConstructorTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypePredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAssertionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSAsExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSParameterPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAliasDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceHeritageNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeQueryNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSConditionalTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSPropertySignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSMethodSignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexSignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSCallSignatureDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverInitializerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverRestElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTypedIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AmakeBlock0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AmakeVarDeclaration0x28hermes0x3A0x3AUniqueString0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AmakeVarDeclarator0x28hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AcollectAllIDs0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AtraverseForLexicalDecl0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ASequenceExpressionNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Atry_emplace0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x260x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AtransformES6Classes0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrowFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AHookDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADoWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABreakStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AContinueStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AThrowStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AReturnStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ALabeledStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExpressionStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASpreadElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANewExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAwaitExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalCallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AUnaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AUpdateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ALogicalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AConditionalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABinaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADirectiveNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3APrivateNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMetaPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASwitchCaseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACatchClauseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclaratorNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATemplateLiteralNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATaggedTemplateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3APropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPrivatePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMethodDefinitionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportDefaultSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportNamespaceSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportNamedDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportNamespaceSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportDefaultDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportAllDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ARestElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXNamespacedNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXExpressionContainerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXSpreadChildNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXOpeningElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXClosingElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXSpreadAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXFragmentNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AHookTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeParamNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANullableTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeofTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AKeyofTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeOperatorNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeofIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeSpreadElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeLabeledElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInferTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AGenericTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AConditionalTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypePredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeAliasNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOpaqueTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareTypeAliasNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareOpaqueTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareInterfaceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareClassNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareFunctionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareHookNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareComponentNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareVariableNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareEnumNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportAllDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareNamespaceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleExportsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceExtendsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassImplementsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeSpreadPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeInternalSlotNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeCallPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeIndexerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeMappedTypePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeCastExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAsExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAsConstExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclaredPredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumDefaultedMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumStringMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumNumberMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumBooleanMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSLiteralTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSArrayTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeReferenceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSQualifiedNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSFunctionTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSConstructorTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypePredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAssertionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSAsExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSParameterPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAliasDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceHeritageNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeQueryNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSConditionalTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSPropertySignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSMethodSignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexSignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSCallSignatureDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverInitializerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverRestElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTypedIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcloneNodeInternal0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateCallWithForwardedThis0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x200x28anonymous0x20namespace0x290x3A0x3ANodeVector0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x20hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateTransformedNode0x3Chermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2C0x20hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateGetSuperProperty0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateClass0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassBodyNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcopyIdentifier0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x20hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateTransformedNode0x3Chermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateClassCtor0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassBodyNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AMethodDefinitionNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AmakeHermesES6InternalCall0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AStringRef0x2C0x200x28anonymous0x20namespace0x290x3A0x3ANodeVector0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x20hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateTransformedNode0x3Chermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x20hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateTransformedNode0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2C0x20std0x3A0x3Anullptr_t0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x2C0x20std0x3A0x3Anullptr_t0x2C0x20std0x3A0x3Anullptr_t0x2C0x20bool0x2C0x20bool0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20bool0x260x260x2C0x20bool0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x20hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateTransformedNode0x3Chermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateThisPropertyInitializer0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateTransformedNode0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x2C0x20std0x3A0x3Anullptr_t0x2C0x20std0x3A0x3Anullptr_t0x2C0x20bool0x2C0x20bool0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20std0x3A0x3Anullptr_t0x260x260x2C0x20bool0x260x260x2C0x20bool0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3Aconstants0x3A0x3AErrorType0x20hermes0x3A0x3Aregex0x3A0x3AparseRegex0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3E0x28char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x2C0x20unsigned0x20int0x2C0x20bool0x2C0x20unsigned0x20int0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeDisjunction0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AspliceOut0x28hermes0x3A0x3Aregex0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AopenAlternation0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x204u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AopenNamedCapturingGroup0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x204u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AopenCapturingGroup0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x204u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AcloseAlternation0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x204u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AcloseGroup0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x204u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeTerm0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3Aconsume0x28char16_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3A0x3Aoperator0x3D0x5Babi0x3Av150070x5D0x28hermes0x3A0x3Aregex0x3A0x3ANode0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeGroupName0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Adeque0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x3E0x3E0x3A0x3Aemplace_back0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x3E0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20unsigned0x20int0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x260x260x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ApushLookaround0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20unsigned0x20short0x2C0x20unsigned0x20short0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeQuantifierPrefix0x28hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AQuantifier0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AapplyQuantifier0x28hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AQuantifier0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x3E0x28hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARightAnchorNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ARightAnchorNode0x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AWordBoundaryNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AWordBoundaryNode0x2C0x20bool0x260x3E0x28bool0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeAtomEscape0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x3E0x28hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeCharacterClass0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x2C0x20llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x3E0x28llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x260x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeUnicodeEscapeSequence0x28bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AwriteCodePointToUTF160x28unsigned0x20int0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeRegExpIdentifier0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x2C0x20bool0x200x280x2A0x290x28unsigned0x20int0x290x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeAndAppendSurrogatePair0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x2C0x20bool0x200x280x2A0x290x28unsigned0x20int0x290x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeHexDigits0x28unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Autf16SurrogatePairToCodePoint0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adeque0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x3E0x3E0x3A0x3A_0x5Fadd_back_capacity0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x3E0x3E0x3A0x3Apush_back0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x3E0x3E0x3A0x3Apush_front0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x3E0x260x3E0x3A0x3Apush_back0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x3E0x260x3E0x3A0x3Apush_front0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AAlternationNode0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3A0x7EAlternationNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3A0x7EAlternationNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fvalue_func0x3Cbool0x200x280x290x3E0x3A0x3Aswap0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fvalue_func0x3Cbool0x200x280x290x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x280x290x3E0x3A0x3A0x7E_0x5Fbase0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finvoke_void_return_wrapper0x3Cbool0x2C0x20false0x3E0x3A0x3A_0x5Fcall0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x260x3E0x28hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x260x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20unsigned0x20short0x260x2C0x20unsigned0x20short0x260x2C0x20bool0x260x2C0x20bool0x260x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x260x260x2C0x20unsigned0x20short0x260x2C0x20unsigned0x20short0x260x2C0x20bool0x260x2C0x20bool0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x28unsigned0x20int0x260x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x2C0x20bool0x260x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20short0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3A0x7EMarkedSubexpressionNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3A0x7EMarkedSubexpressionNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3A0x7ELookaroundNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3A0x7ELookaroundNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fvalue_func0x3Cvoid0x200x280x290x3E0x3A0x3Aswap0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fvalue_func0x3Cvoid0x200x280x290x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x3A0x3A0x7E_0x5Fbase0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3A0x7ELoopNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3A0x7ELoopNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x260x2C0x20bool0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x3E0x28hermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x260x2C0x20bool0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AaddClass0x28hermes0x3A0x3Aregex0x3A0x3ACharacterClass0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeLegacyOctalEscapeSequence0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ApushNamedBackRef0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeCharacterEscape0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeBracketClassAtom0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x3A0x3A0x7ELeftAnchorNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARightAnchorNode0x3A0x3A0x7ERightAnchorNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARightAnchorNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AWordBoundaryNode0x3A0x3A0x7EWordBoundaryNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AWordBoundaryNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AidentityEscape0x28char16_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2C0x20int0x3E0x28int0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x3E0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x260x3E0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2C0x20unsigned0x20int0x3E0x28unsigned0x20int0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3A0x7EBracketNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3A0x7EBracketNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ApopulateInstruction0x3Chermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x3A0x3AInstructionWrapper0x3Chermes0x3A0x3Aregex0x3A0x3AU16BracketInsn0x3E0x3E0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x3A0x3AInstructionWrapper0x3Chermes0x3A0x3Aregex0x3A0x3AU16BracketInsn0x3E0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ApopulateInstruction0x3Chermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x3A0x3AInstructionWrapper0x3Chermes0x3A0x3Aregex0x3A0x3ABracketInsn0x3E0x3E0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x3A0x3AInstructionWrapper0x3Chermes0x3A0x3Aregex0x3A0x3ABracketInsn0x3E0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x3A0x3A0x7EBackRefNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3A0x7EMatchAnyNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACompiledRegExp0x3A0x3ACompiledRegExp0x28hermes0x3A0x3ACompiledRegExp0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ACompiledRegExp0x3A0x3A0x7ECompiledRegExp0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ACompiledRegExp0x3A0x3AtryCompile0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Ctrue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cstd0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cstd0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3AencodeUTF160x3Cstd0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ARegex0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3Acompile0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3A0x7ERegex0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3Aconstants0x3A0x3AErrorType0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3Aparse0x3Cchar16_t0x20const0x2A0x3E0x28char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3Acompile0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x20const0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AUniquingRegExpTable0x3A0x3AgetEntryList0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AUniquingRegExpTable0x3A0x3AgetBytecodeBuffer0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x206u0x3E0x3E0x3A0x3Aoperator0x3D0x5Babi0x3Av150070x5D0x28char16_t0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3Aconstants0x3A0x3AErrorType0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AparseWithBackRefLimit0x3Cchar16_t0x20const0x2A0x3E0x28char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20bool0x2C0x20unsigned0x20int0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Ashrink_and_clear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AGoalNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AGoalNode0x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AoptimizeNodeList0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x3E0x3E0x3A0x3Ainsert0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2A0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Chermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x2A0x3E0x28hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3A0x7ENode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AtryCoalesceCharacters0x28llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AisGoal0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3A0x7ENode0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AGoalNode0x3A0x3A0x7EGoalNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AGoalNode0x3A0x3AisGoal0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AGoalNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x2C0x20unsigned0x20char0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3A0x7EMatchCharNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3A0x7EMatchCharNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AtryCoalesceCharacters0x28llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AemitASCIIList0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AemitNonASCIIList0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3A0x3Ainsert0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3A0x3Ainsert0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AKeywords0x3A0x3AKeywords0x28hermes0x3A0x3AContext0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3ASemanticValidator0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3Asem0x3A0x3ASemContext0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AdoIt0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3Avisit0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AdoFunction0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x260x20std0x3A0x3A_0x5F20x3A0x3Adeque0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3E0x3E0x3A0x3Aemplace_back0x3C0x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3A0x7EFunctionContext0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3AFunctionContext0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3ASourceVisibility0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AscanDirectivePrologue0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AVariableDeclaratorNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvalidateDeclarationNames0x28hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AMetaPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3AaddHoistingCandidate0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvisitFunction0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AMapVector0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x2C0x20llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3Aoperator0x5B0x5D0x28hermes0x3A0x3AUniqueString0x20const0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AUniqueString0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvisitParamsAndBody0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AArrowFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvisitForInOf0x28hermes0x3A0x3AESTree0x3A0x3ALoopStatementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvalidateAssignmentTarget0x28hermes0x3A0x3AESTree0x3A0x3ANode0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AisLValue0x28hermes0x3A0x3AESTree0x3A0x3ANode0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ABinaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3ArecursionDepthExceeded0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AUpdateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ALabeledStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x3A0x3Atry_emplace0x3Chermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x28hermes0x3A0x3AUniqueString0x2A0x260x260x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ARegExpLiteralNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20void0x2A0x3E0x2A0x2C0x20long0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x260x260x2C0x20hermes0x3A0x3ACompiledRegExp0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvalidateCatchClause0x28hermes0x3A0x3AESTree0x3A0x3ANode0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvisitTryHandler0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3ABlockContext0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3AensureScopedNamesAreUnique0x28hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3AIsFunctionBody0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3AstopHoisting0x28hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ADoWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ABreakStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AContinueStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AReturnStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AAwaitExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AUnaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ASpreadElementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3APrivateNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AClassPrivatePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AImportDefaultSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AImportNamespaceSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AImportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AExportNamedDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AExportDefaultDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AExportAllDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AMapVector0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x2C0x20llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3Aerase0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x2A0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3AfinalizeHoisting0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Atry_emplace0x3Cunsigned0x20int0x20const0x260x3E0x28hermes0x3A0x3AUniqueString0x20const0x2A0x20const0x260x2C0x20unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x204u0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adeque0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3E0x3E0x3A0x3A_0x5Fadd_back_capacity0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x3E0x3E0x3A0x3Apush_back0x28hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x3E0x3E0x3A0x3Apush_front0x28hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x3E0x260x3E0x3A0x3Apush_back0x28hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x3E0x260x3E0x3A0x3Apush_front0x28hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3Adetail0x3A0x3AVisitCaller0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2C0x20void0x3E0x3A0x3Acall0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3Adetail0x3A0x3AVisitCaller0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverEmptyArgsNode0x2C0x20void0x3E0x3A0x3Acall0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverEmptyArgsNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3Adetail0x3A0x3AVisitCaller0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTrailingCommaNode0x2C0x20void0x3E0x3A0x3Acall0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTrailingCommaNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3Adetail0x3A0x3AVisitCaller0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverRestElementNode0x2C0x20void0x3E0x3A0x3Acall0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverRestElementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3Adetail0x3A0x3AVisitCaller0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTypedIdentifierNode0x2C0x20void0x3E0x3A0x3Acall0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTypedIdentifierNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrowFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AHookDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADoWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASwitchStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ALabeledStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIfStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANewExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalCallExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ALogicalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AConditionalExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ABinaryExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMetaPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ASwitchCaseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACatchClauseNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclaratorNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATemplateLiteralNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATaggedTemplateExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3APropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPrivatePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AMethodDefinitionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AImportAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportNamedDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AExportSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAssignmentPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXMemberExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXNamespacedNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXOpeningElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXAttributeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AJSXFragmentNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AHookTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionTypeParamNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentTypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeofTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AQualifiedTypeofIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeSpreadElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATupleTypeLabeledElementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AGenericTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOptionalIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AConditionalTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypePredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeAliasNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AOpaqueTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareTypeAliasNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareOpaqueTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareInterfaceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareClassNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareFunctionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareComponentNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareEnumNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareExportDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareModuleNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ADeclareNamespaceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AInterfaceExtendsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassImplementsNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeAnnotationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeInternalSlotNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeIndexerNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectTypeMappedTypePropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATypeCastExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AAsExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumStringBodyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumNumberBodyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumBooleanBodyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumSymbolBodyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumStringMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumNumberMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AEnumBooleanMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AComponentParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexedAccessTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeReferenceNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSQualifiedNameNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSFunctionTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSConstructorTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypePredicateNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAssertionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSAsExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeAliasDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSInterfaceHeritageNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSEnumMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSModuleMemberNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSTypeParameterNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSConditionalTypeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSPropertySignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSMethodSignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSIndexSignatureNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATSCallSignatureDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ACoverTypedIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3ALabel0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x28hermes0x3A0x3AUniqueString0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x28hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x28hermes0x3A0x3AUniqueString0x20const0x2A0x20const0x260x2C0x20hermes0x3A0x3AUniqueString0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AvalidateAST0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3Asem0x3A0x3ASemContext0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AvalidateFunctionAST0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3Asem0x3A0x3ASemContext0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AgenerateIRFromESTree0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AModule0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x3E0x3E0x20const0x260x2C0x20hermes0x3A0x3AScopeChain0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AgenerateLazyFunctionIR0x28hermes0x3A0x3Ahbc0x3A0x3ALazyCompilationData0x2A0x2C0x20hermes0x3A0x3AModule0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AScopeDesc0x3A0x3AcreateInnerScope0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3A0x7EFunctionInfo0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3APassManager0x3A0x3APassManager0x28hermes0x3A0x3ACodeGenerationSettings0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3APassManager0x3A0x3A0x7EPassManager0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3APassManager0x3A0x3AmakeDumpPass0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3APassManager0x3A0x3AaddPass0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3APassManager0x3A0x3Arun0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3APassManager0x3A0x3Arun0x28hermes0x3A0x3AModule0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ATimer0x3E0x3A0x3Aemplace_back0x3Cchar0x20const0x200x280x260x290x200x5B10x5D0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ATimerGroup0x260x3E0x28char0x20const0x200x280x260x290x200x5B10x5D0x2C0x20llvh0x3A0x3AStringRef0x260x260x2C0x20llvh0x3A0x3ATimerGroup0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cllvh0x3A0x3ATimer0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3A0x7EDumpModule0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3A0x7EDumpModule0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3ArunOnModule0x28hermes0x3A0x3AModule0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3AdumpIfEnabled0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3ACodeGenerationSettings_DumpSettings0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3A0x7EDumpFunction0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3A0x7EDumpFunction0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3AdumpIfEnabled0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ACodeGenerationSettings_DumpSettings0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x3A0x3Afind0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3AupdateDFSNumbers0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3Adominates0x28llvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x20const0x2A0x2C0x20llvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3AdominatedBySlowTreeWalk0x28llvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x20const0x2A0x2C0x20llvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3AproperlyDominates0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3Adominates0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3A0x3AaddChild0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3ACalculateFromScratch0x28llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x260x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3ABatchUpdateInfo0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3Ashrink_and_clear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ADominanceInfo0x3A0x3ADominanceInfo0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ADominanceInfo0x3A0x3AproperlyDominates0x28hermes0x3A0x3AInstruction0x20const0x2A0x2C0x20hermes0x3A0x3AInstruction0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Acfg0x3A0x3AUpdate0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3A0x3Adump0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Acfg0x3A0x3AUpdate0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3A0x3Aprint0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AChildrenGetter0x3Cfalse0x3E0x3A0x3AGet0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3ABatchUpdateInfo0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3ArunSemiNCA0x28llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AattachNewSubtree0x28llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x260x2C0x20llvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3Aeval0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AgetNodeForBlock0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3A0x3Aappend0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cllvh0x3A0x3ASuccIterator0x3Chermes0x3A0x3ATerminatorInst0x2C0x20hermes0x3A0x3ABasicBlock0x3E0x3E0x2C0x20void0x3E0x28std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cllvh0x3A0x3ASuccIterator0x3Chermes0x3A0x3ATerminatorInst0x2C0x20hermes0x3A0x3ABasicBlock0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cllvh0x3A0x3ASuccIterator0x3Chermes0x3A0x3ATerminatorInst0x2C0x20hermes0x3A0x3ABasicBlock0x3E0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3A0x3Aerase0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABasicBlock0x2A0x2A0x20std0x3A0x3A_0x5F20x3A0x3Auninitialized_copy0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cllvh0x3A0x3ASuccIterator0x3Chermes0x3A0x3ATerminatorInst0x2C0x20hermes0x3A0x3ABasicBlock0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cllvh0x3A0x3ASuccIterator0x3Chermes0x3A0x3ATerminatorInst0x2C0x20hermes0x3A0x3ABasicBlock0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cllvh0x3A0x3ASuccIterator0x3Chermes0x3A0x3ATerminatorInst0x2C0x20hermes0x3A0x3ABasicBlock0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AAlwaysDescend0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3ArunDFS0x3Cfalse0x2C0x20bool0x200x280x2A0x290x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20unsigned0x20int0x2C0x20bool0x200x280x2A0x290x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3APostOrderAnalysis0x3A0x3AvisitPostOrder0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3APostOrderAnalysis0x3A0x3AvisitPostOrder0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x260x290x3A0x3AState0x3E0x3A0x3Aemplace_back0x3Chermes0x3A0x3ABasicBlock0x2A0x260x3E0x28hermes0x3A0x3ABasicBlock0x2A0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3APostOrderAnalysis0x3A0x3APostOrderAnalysis0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALoopAnalysis0x3A0x3ALoopAnalysis0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ADominanceInfo0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x3A0x3A0x7ESmallDenseMap0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ALoopAnalysis0x3A0x3AgetLoopHeader0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALoopAnalysis0x3A0x3AgetLoopPreheader0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AcalculateFunctionScopeData0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20llvh0x3A0x3AOptional0x3Cint0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x2C0x20hermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AScopeDesc0x20const0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AgetScopeDepth0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x2C0x20hermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x28hermes0x3A0x3AScopeDesc0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x2C0x20hermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x28hermes0x3A0x3AScopeDesc0x20const0x2A0x20const0x260x2C0x20hermes0x3A0x3AScopeDesc0x20const0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x2C0x20hermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x20const0x2A0x2C0x20hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AScopeData0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3ASegment0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInterval0x3A0x3Acompress0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterFile0x3A0x3AkillRegister0x28hermes0x3A0x3ARegister0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterFile0x3A0x3AallocateRegister0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterFile0x3A0x3AtailAllocateConsecutive0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ABitVector0x3A0x3Areset0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AlowerPhis0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AInstruction0x2A0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AValue0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AcalculateLocalLiveness0x28hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetInstructionNumber0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Chermes0x3A0x3AInterval0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ASegment0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ASegment0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AInstruction0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AcalculateGlobalLiveness0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ABitVector0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ABitVector0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ABitVector0x3A0x3Atest0x28llvh0x3A0x3ABitVector0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_dumpVector0x28llvh0x3A0x3ABitVector0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Araw_ostream0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetRegisterForInstructionAt0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetRegister0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x3E0x3E0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AValue0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3Acoalesce0x28llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x260x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AInterval0x3A0x3Aadd0x28hermes0x3A0x3AInterval0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AInstruction0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AInstruction0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInterval0x3A0x3Aintersects0x28hermes0x3A0x3AInterval0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AisAllocated0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AallocateFastPass0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AupdateRegister0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AcalculateLiveIntervals0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_10x3A0x3Aoperator0x280x290x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apriority_queue0x3Cunsigned0x20int0x2C0x20llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x2032u0x3E0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_00x3E0x3A0x3Apop0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3Ashrink_and_clear0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3Adump0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ARegister0x3E0x3A0x3AgetHashValue0x28hermes0x3A0x3ARegister0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ARegister0x3E0x3A0x3AisEqual0x28hermes0x3A0x3ARegister0x2C0x20hermes0x3A0x3ARegister0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AScopeRegisterAnalysis0x3A0x3AScopeRegisterAnalysis0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AScopeDesc0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x3E0x3E0x3A0x3AFindAndConstruct0x28hermes0x3A0x3AScopeDesc0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AScopeRegisterAnalysis0x3A0x3AregisterAndScopeAt0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AScopeRegisterAnalysis0x3A0x3AregisterAndScopeForInstruction0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_LivenessRegAllocIRPrinter0x3A0x3A0x7ELivenessRegAllocIRPrinter0x280x29(w2c_hermes*, u32);
void w2c_hermes_LivenessRegAllocIRPrinter0x3A0x3AprintValueLabel0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_LivenessRegAllocIRPrinter0x3A0x3AprintInstructionDestination0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3AValue0x2A0x3E0x28hermes0x3A0x3AValue0x2A0x20const0x260x2C0x20hermes0x3A0x3AValue0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3AValue0x2A0x3E0x28hermes0x3A0x3AValue0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AMovInst0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x28hermes0x3A0x3ABasicBlock0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2