/*
 * Copyright 2006-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.esotericsoftware.kryo.kryo5.objenesis.instantiator.sun;

import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.annotations.Instantiator;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.annotations.Typology;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.basic.DelegatingToExoticInstantiator;

/**
 * Shell keeping compatibility but delegating to objenesis-exotic which contains the real implementation.
 *
 * @param <T> type of the class instantiated
 */
@Instantiator(Typology.STANDARD)
public class MagicInstantiator<T> extends DelegatingToExoticInstantiator<T> {

   public MagicInstantiator(Class<T> type) {
      super("com.esotericsoftware.kryo.kryo5.objenesis.instantiator.exotic.MagicInstantiator", type);
   }

}
