/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import io.reactivex.Maybe;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.StandardSystemProperty;
import rp.com.google.common.collect.Lists;

public class LaunchFile {
    public static final String FILE_PREFIX = "rplaunch";
    private static final Pattern FILENAME_PATTERN = Pattern.compile("rplaunch-(.*)-#(\\d)+-(.*)\\.tmp");
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchFile.class);
    private final File file;

    private LaunchFile(File file) {
        this.file = file;
    }

    public static Maybe<String> find(String name) {
        File tempDir = LaunchFile.getTempDir();
        final String prefix = "rplaunch-" + name;
        List<String> files = Arrays.asList(tempDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && FILENAME_PATTERN.matcher(name).matches();
            }
        }));
        ArrayList<StartLaunchRS> fileRSs = new ArrayList<StartLaunchRS>(Lists.transform(files, new rp.com.google.common.base.Function<String, StartLaunchRS>(){

            @Override
            public StartLaunchRS apply(String input) {
                Matcher m = FILENAME_PATTERN.matcher(input);
                if (m.find()) {
                    return new StartLaunchRS(m.group(3), Long.valueOf(Long.parseLong(m.group(2))));
                }
                throw new RuntimeException("Does not match:" + input);
            }
        }));
        Collections.sort(fileRSs, new Comparator<StartLaunchRS>(){

            @Override
            public int compare(StartLaunchRS o1, StartLaunchRS o2) {
                return -1 * o1.getNumber().compareTo(o2.getNumber());
            }
        });
        return Maybe.just((Object)((StartLaunchRS)fileRSs.get(0)).getId());
    }

    public static Maybe<LaunchFile> create(final String name, Maybe<StartLaunchRS> id) {
        Maybe lfPromise = id.map((Function)new Function<StartLaunchRS, LaunchFile>(){

            public LaunchFile apply(StartLaunchRS launchId) throws Exception {
                try {
                    File file = new File(LaunchFile.getTempDir(), String.format("%s-%s-#%d-%s.tmp", LaunchFile.FILE_PREFIX, name, launchId.getNumber(), launchId.getId()));
                    if (file.createNewFile()) {
                        LOGGER.debug("ReportPortal's temp file '{}' is created", (Object)file.getAbsolutePath());
                    }
                    return new LaunchFile(file);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot create ReportPortal launch file", (Throwable)e);
                    throw e;
                }
            }
        }).cache().onErrorReturnItem((Object)new LaunchFile(null));
        lfPromise.subscribe(SubscriptionUtils.logMaybeResults("Launch file create"));
        return lfPromise;
    }

    public File getFile() {
        return this.file;
    }

    public void remove() {
        if (null != this.file && this.file.exists() && this.file.delete()) {
            LOGGER.debug("ReportPortal's temp file '{}' has been removed", (Object)this.file.getAbsolutePath());
        }
    }

    public static File getTempDir() {
        File tempDir = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value(), "reportportal");
        if (tempDir.mkdirs()) {
            LOGGER.debug("Temp directory for ReportPortal launch files is created: '{}'", (Object)tempDir.getAbsolutePath());
        }
        return tempDir;
    }

    private static class RemoveFileHook
    implements Runnable {
        private final LaunchFile file;

        private RemoveFileHook(LaunchFile file) {
            this.file = file;
        }

        @Override
        public void run() {
            if (null != this.file) {
                this.file.remove();
            }
        }
    }
}

