/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.restendpoint.http.HttpClientRestEndpoint;
import com.epam.reportportal.restendpoint.http.RestEndpoint;
import com.epam.reportportal.restendpoint.http.RestEndpoints;
import com.epam.reportportal.restendpoint.serializer.ByteArraySerializer;
import com.epam.reportportal.restendpoint.serializer.Serializer;
import com.epam.reportportal.restendpoint.serializer.json.JacksonSerializer;
import com.epam.reportportal.service.BearerAuthInterceptor;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchImpl;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.ReportPortalErrorHandler;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.SslUtils;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Function;
import rp.com.google.common.io.Files;
import rp.com.google.common.util.concurrent.ThreadFactoryBuilder;
import rp.org.apache.http.client.HttpClient;
import rp.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import rp.org.apache.http.impl.client.HttpClientBuilder;
import rp.org.apache.http.impl.client.HttpClients;
import rp.org.apache.http.ssl.SSLContextBuilder;

public class ReportPortal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortal.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private ReportPortalClient rpClient;
    private ListenerParameters parameters;

    ReportPortal(ReportPortalClient rpClient, ListenerParameters parameters) {
        this.rpClient = rpClient;
        this.parameters = parameters;
    }

    public Launch newLaunch(StartLaunchRQ rq) {
        if (!this.parameters.getEnable().booleanValue()) {
            return Launch.NOOP_LAUNCH;
        }
        LaunchImpl service = new LaunchImpl(this.rpClient, this.parameters, rq);
        return service;
    }

    public Launch withLaunch(Maybe<String> currentLaunchId) {
        return new LaunchImpl(this.rpClient, this.parameters, currentLaunchId);
    }

    public ListenerParameters getParameters() {
        return this.parameters;
    }

    public ReportPortalClient getClient() {
        return this.rpClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReportPortal create(ReportPortalClient client, ListenerParameters params) {
        return new ReportPortal(client, params);
    }

    public static boolean emitLog(Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.CONTEXT_THREAD_LOCAL.get();
        if (null != loggingContext) {
            loggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(final String message, final String level, final Date time) {
        return ReportPortal.emitLog(new Function<String, SaveLogRQ>(){

            @Override
            public SaveLogRQ apply(@Nullable String id) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(id);
                rq.setMessage(message);
                return rq;
            }
        });
    }

    public static boolean emitLog(final String message, final String level, final Date time, final File file) {
        return ReportPortal.emitLog(new Function<String, SaveLogRQ>(){

            @Override
            public SaveLogRQ apply(@Nullable String id) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(id);
                rq.setMessage(message);
                try {
                    SaveLogRQ.File f = new SaveLogRQ.File();
                    f.setContentType(MimeTypeDetector.detect(file));
                    f.setContent(Files.toByteArray(file));
                    f.setName(UUID.randomUUID().toString());
                    rq.setFile(f);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
                }
                return rq;
            }
        });
    }

    public static boolean emitLog(final ReportPortalMessage message, final String level, final Date time) {
        return ReportPortal.emitLog(new Function<String, SaveLogRQ>(){

            @Override
            public SaveLogRQ apply(@Nullable String id) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(id);
                rq.setMessage(message.getMessage());
                try {
                    TypeAwareByteSource data = message.getData();
                    SaveLogRQ.File file = new SaveLogRQ.File();
                    file.setContent(data.read());
                    file.setContentType(data.getMediaType());
                    file.setName(UUID.randomUUID().toString());
                    rq.setFile(file);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
                }
                return rq;
            }
        });
    }

    public static class Builder {
        public static final String API_BASE = "/api/v1";
        private static final String HTTPS = "https";
        private HttpClientBuilder httpClient;
        private ListenerParameters parameters;
        private ExecutorService executorService;

        public Builder withHttpClient(HttpClientBuilder client) {
            this.httpClient = client;
            return this;
        }

        public Builder withParameters(ListenerParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public ReportPortal build() {
            try {
                ListenerParameters params = null == this.parameters ? new ListenerParameters(this.defaultPropertiesLoader()) : this.parameters;
                this.executorService = Executors.newFixedThreadPool(params.getIoPoolSize(), new ThreadFactoryBuilder().setNameFormat("rp-io-%s").build());
                return new ReportPortal(this.buildClient(ReportPortalClient.class, params), params);
            }
            catch (Exception e) {
                String errMsg = "Cannot build ReportPortal client";
                LOGGER.error(errMsg, (Throwable)e);
                throw new InternalReportPortalClientException(errMsg, e);
            }
        }

        public <T extends ReportPortalClient> T buildClient(Class<T> clientType, ListenerParameters params) {
            try {
                HttpClient client = null == this.httpClient ? this.defaultClient(params) : this.httpClient.addInterceptorLast(new BearerAuthInterceptor(params.getUuid())).build();
                return (T)((ReportPortalClient)RestEndpoints.forInterface(clientType, this.buildRestEndpoint(params, client)));
            }
            catch (Exception e) {
                String errMsg = "Cannot build ReportPortal client";
                LOGGER.error(errMsg, (Throwable)e);
                throw new InternalReportPortalClientException(errMsg, e);
            }
        }

        protected RestEndpoint buildRestEndpoint(ListenerParameters parameters, HttpClient client) {
            ObjectMapper om = new ObjectMapper();
            om.setDateFormat((DateFormat)new SimpleDateFormat(ReportPortal.DEFAULT_DATE_FORMAT));
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            String baseUrl = parameters.getBaseUrl();
            String project = parameters.getProjectName();
            final JacksonSerializer jacksonSerializer = new JacksonSerializer(om);
            return new HttpClientRestEndpoint(client, (List<Serializer>)new LinkedList<Serializer>(){
                {
                    this.add(jacksonSerializer);
                    this.add(new ByteArraySerializer());
                }
            }, new ReportPortalErrorHandler(jacksonSerializer), this.buildEndpointUrl(baseUrl, project), this.executorService);
        }

        protected String buildEndpointUrl(String baseUrl, String project) {
            return baseUrl + API_BASE + "/" + project;
        }

        protected HttpClient defaultClient(ListenerParameters parameters) throws MalformedURLException {
            String baseUrl = parameters.getBaseUrl();
            String keyStore = parameters.getKeystore();
            String keyStorePassword = parameters.getKeystorePassword();
            String uuid = parameters.getUuid();
            HttpClientBuilder builder = HttpClients.custom();
            if (HTTPS.equals(new URL(baseUrl).getProtocol()) && keyStore != null) {
                if (null == keyStorePassword) {
                    throw new InternalReportPortalClientException("You should provide keystore password parameter [" + (Object)((Object)ListenerProperty.KEYSTORE_PASSWORD) + "] if you use HTTPS protocol");
                }
                try {
                    builder.setSSLContext(SSLContextBuilder.create().loadTrustMaterial(SslUtils.loadKeyStore(keyStore, keyStorePassword), TrustSelfSignedStrategy.INSTANCE).build());
                }
                catch (Exception e) {
                    throw new InternalReportPortalClientException("Unable to load trust store");
                }
            }
            builder.setMaxConnPerRoute(parameters.getMaxConnectionsPerRoute()).setMaxConnTotal(parameters.getMaxConnectionsTotal()).evictExpiredConnections();
            return builder.addInterceptorLast(new BearerAuthInterceptor(uuid)).build();
        }

        protected PropertiesLoader defaultPropertiesLoader() {
            return PropertiesLoader.load();
        }
    }
}

