/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.restendpoint.http.uri;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import rp.com.google.common.base.Joiner;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.net.UrlEscapers;

public class UrlTemplate {
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private final String template;
    private final List<String> pathVariables = new LinkedList<String>();

    private UrlTemplate(String template) {
        this.template = template;
        this.parsePathVariables();
    }

    public static UrlTemplate create(String template) {
        return new UrlTemplate(template);
    }

    public boolean hasPathVariable(String name) {
        return this.pathVariables.contains(name);
    }

    public List<String> getPathVariables() {
        return this.pathVariables;
    }

    public Merger merge() {
        return new Merger(this.template);
    }

    private void parsePathVariables() {
        Matcher m = PATH_VARIABLE_PATTERN.matcher(this.template);
        while (m.find()) {
            this.pathVariables.add(m.group(1));
        }
    }

    public static class Merger {
        private StringBuilder template;

        private Merger(String template) {
            this.template = new StringBuilder(template);
        }

        public Merger expand(Map<String, Object> pathParameters) {
            Matcher m = PATH_VARIABLE_PATTERN.matcher(this.template);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                Object replacement = pathParameters.get(m.group(1));
                Preconditions.checkState(null != replacement, "Unknown path variable: %s", (Object)m.group(1));
                m.appendReplacement(sb, Matcher.quoteReplacement(UrlEscapers.urlPathSegmentEscaper().escape(replacement.toString())));
            }
            m.appendTail(sb);
            this.template = new StringBuilder(sb);
            return this;
        }

        public Merger appendQueryParameters(@Nullable Map<String, ?> parameters) {
            if (null == parameters || parameters.isEmpty()) {
                return this;
            }
            int lastCharIndex = this.template.length() - 1;
            if ('/' == this.template.charAt(lastCharIndex)) {
                this.template.deleteCharAt(lastCharIndex);
            }
            if (this.template.indexOf("?") == -1) {
                this.template.append("?");
            }
            Joiner.on('&').withKeyValueSeparator("=").appendTo(this.template, parameters);
            return this;
        }

        public String build() {
            return this.template.toString();
        }
    }
}

