/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import rp.org.apache.http.HttpClientConnection;
import rp.org.apache.http.HttpHost;
import rp.org.apache.http.annotation.Contract;
import rp.org.apache.http.annotation.ThreadingBehavior;
import rp.org.apache.http.config.ConnectionConfig;
import rp.org.apache.http.config.SocketConfig;
import rp.org.apache.http.impl.pool.BasicConnFactory;
import rp.org.apache.http.impl.pool.BasicPoolEntry;
import rp.org.apache.http.params.HttpParams;
import rp.org.apache.http.pool.AbstractConnPool;
import rp.org.apache.http.pool.ConnFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

