/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.notification;

import android.app.NotificationChannel;
import android.app.Service;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.echatsoft.echatsdk.R;
import com.echatsoft.echatsdk.core.EChatConstants;
import com.echatsoft.echatsdk.utils.pub.notification.BaseData;
import com.echatsoft.echatsdk.utils.pub.notification.BaseNotification;

@Keep
public class StaticNotification
extends BaseNotification<BaseData> {
    private static int foregroundId = EChatConstants.NF_FOREGROUND_ID;

    public static int getForegroundId() {
        return foregroundId;
    }

    public static void setForegroundId(int n4) {
        foregroundId = n4;
    }

    public StaticNotification(Context object) {
        BaseData baseData;
        StaticNotification staticNotification = object2;
        Context context = object;
        Object object2 = baseData;
        Context context2 = object;
        object = context2.getString(R.string.echat_notification_group_id);
        String string2 = context2.getString(R.string.echat_notification_group_name);
        String string3 = context2.getString(R.string.echat_notification_foreground_channel_id);
        String string4 = context2.getString(R.string.echat_notification_foreground_channel_name);
        baseData = new BaseData((String)object, string2, string3, string4);
        super(context, object2);
    }

    @Override
    public String TAG() {
        return "EChat_Service";
    }

    @Override
    public void show() {
        throw new UnsupportedOperationException("u can't call me...");
    }

    @Override
    @RequiresApi(api=26)
    public void configureChannel(NotificationChannel notificationChannel) {
        NotificationChannel notificationChannel2 = notificationChannel;
        notificationChannel2.setLockscreenVisibility(-1);
        notificationChannel2.setImportance(1);
    }

    @Override
    public void configureNotify(NotificationCompat.Builder builder) {
        builder.setOngoing(true).setSmallIcon(this.getSmallIcon()).setContentTitle((CharSequence)this.getString(R.string.echat_notification_running_in_background)).setCategory("service");
    }

    public void show(Service service) {
        StaticNotification staticNotification = this;
        super.show();
        staticNotification.show(service, null);
    }

    public void show(Service service, String string2) {
        super.show();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.getBuilder().setContentTitle((CharSequence)string2);
        }
        if (Build.VERSION.SDK_INT > 18) {
            service.startForeground(foregroundId, this.getBuilder().build());
        }
    }

    public void cancel(Service service) {
        if (Build.VERSION.SDK_INT >= 26) {
            service.stopForeground(true);
        }
        this.manager.cancel(foregroundId);
    }

    public void cancel() {
        this.manager.cancel(foregroundId);
    }
}

