/*
 * Decompiled with CFR 0.152.
 */
package com.echatsoft.echatsdk.utils.pub.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.echatsoft.echatsdk.R;
import com.echatsoft.echatsdk.core.utils.ScreenUtils;
import com.echatsoft.echatsdk.utils.pub.imageloader.EChatImageLoader;

public class GlideImageLoader
implements EChatImageLoader {
    public void loadThumbnail(Context context, int n4, Drawable drawable2, ImageView imageView, Uri uri) {
        Glide.with((Context)context).asBitmap().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(n4, n4)).placeholder(drawable2)).centerCrop()).into(imageView);
    }

    public void loadGifThumbnail(Context context, int n4, Drawable drawable2, ImageView imageView, Uri uri) {
        Glide.with((Context)context).asBitmap().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(n4, n4)).placeholder(drawable2)).centerCrop()).into(imageView);
    }

    public void loadImage(Context context, int n4, int n5, ImageView imageView, Uri uri) {
        Glide.with((Context)context).load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(n4, n5)).priority(Priority.HIGH)).fitCenter()).into(imageView);
    }

    public void loadImage(Context context, String string2, ImageView imageView, final View view, View view2) {
        view2 = (RequestOptions)((RequestOptions)new RequestOptions().fitCenter()).error(R.drawable.echat_default_img_failed);
        double d5 = ScreenUtils.getScreenHeight() > ScreenUtils.getScreenWidth() ? ScreenUtils.getScreenHeight() : ScreenUtils.getScreenWidth();
        view2.override((int)(d5 * 1.6));
        Glide.with((Context)context).load(string2).apply((BaseRequestOptions)view2).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException glideException, Object object, Target<Drawable> target, boolean bl) {
                view.setVisibility(8);
                return false;
            }

            public boolean onResourceReady(Drawable drawable2, Object object, Target<Drawable> target, DataSource dataSource, boolean bl) {
                view.setVisibility(8);
                return false;
            }
        }).into(imageView);
    }

    public void loadGifImage(Context context, int n4, int n5, ImageView imageView, Uri uri) {
        Glide.with((Context)context).asGif().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(n4, n5)).priority(Priority.HIGH)).fitCenter()).into(imageView);
    }

    public void loadBoxIcon(Context context, String string2, @DrawableRes int n4, ImageView imageView) {
        Glide.with((Context)context).load(string2).apply(((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).dontAnimate()).placeholder(n4)).into(imageView);
    }

    public void loadDrawable(Context context, String string2, int n4, int n5, final @NonNull EChatImageLoader.CustomCallback<Drawable> customCallback) {
        RequestOptions requestOptions;
        RequestOptions requestOptions2 = requestOptions;
        requestOptions = new RequestOptions();
        if (n4 > 0 && n5 > 0) {
            requestOptions2.override(n4, n5);
        }
        Glide.with((Context)context).load(string2).apply((BaseRequestOptions)requestOptions2).into((Target)new CustomTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable drawable2, @Nullable Transition<? super Drawable> transition) {
                customCallback.set((Object)drawable2);
            }

            public void onLoadCleared(@Nullable Drawable drawable2) {
                customCallback.clear(drawable2);
            }
        });
    }

    public void loadBitmap(Context context, String string2, int n4, int n5, final @NonNull EChatImageLoader.CustomCallback<Bitmap> customCallback) {
        RequestOptions requestOptions;
        RequestOptions requestOptions2 = requestOptions;
        requestOptions = new RequestOptions();
        if (n4 > 0 && n5 > 0) {
            requestOptions2.override(n4, n5);
        }
        Glide.with((Context)context).asBitmap().load(string2).apply((BaseRequestOptions)requestOptions2).into((Target)new CustomTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                customCallback.set((Object)bitmap);
            }

            public void onLoadCleared(@Nullable Drawable drawable2) {
                customCallback.clear(drawable2);
            }
        });
    }

    public boolean supportAnimatedGif() {
        return true;
    }
}

