/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.biome.BiomeSettings;
import com.diffplug.spotless.biome.BiomeStep;
import com.diffplug.spotless.maven.FileLocator;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractBiome
implements FormatterStepFactory {
    @Parameter
    private String configPath;
    @Parameter
    private String downloadDir;
    @Parameter
    private String pathToExe;
    @Parameter
    private String version;

    protected AbstractBiome() {
    }

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig config) {
        BiomeStep builder = this.newBuilder(config);
        if (this.configPath != null) {
            String resolvedConfigFile = this.resolveConfigFile(config);
            builder.withConfigPath(resolvedConfigFile);
        }
        if (this.getLanguage() != null) {
            builder.withLanguage(this.getLanguage());
        }
        return builder.create();
    }

    protected abstract String getLanguage();

    private BiomeStep newBuilder(FormatterStepConfig config) {
        if (this.pathToExe != null) {
            String resolvedExePath = this.resolveExePath(config);
            return BiomeStep.withExePath((String)resolvedExePath);
        }
        String downloadDir = this.resolveDownloadDir(config);
        return BiomeStep.withExeDownload((String)this.version, (String)downloadDir);
    }

    private String resolveConfigFile(FormatterStepConfig config) {
        return config.getFileLocator().getBaseDir().toPath().resolve(this.configPath).toAbsolutePath().toString();
    }

    private String resolveExePath(FormatterStepConfig config) {
        Path path = Paths.get(this.pathToExe, new String[0]);
        if (path.getNameCount() == 1) {
            return path.toString();
        }
        return config.getFileLocator().getBaseDir().toPath().resolve(path).toAbsolutePath().toString();
    }

    private String resolveDownloadDir(FormatterStepConfig config) {
        FileLocator fileLocator = config.getFileLocator();
        if (this.downloadDir != null && !this.downloadDir.isBlank()) {
            return fileLocator.getBaseDir().toPath().resolve(this.downloadDir).toAbsolutePath().toString();
        }
        return fileLocator.getDataDir().toPath().resolve(BiomeSettings.shortName()).toString();
    }
}

