/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.biome;

enum Architecture {
    ARM64,
    X64;


    public static Architecture guess() {
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        if (arch == null || arch.isBlank()) {
            throw new IllegalStateException("No OS information is available, specify the Biome executable manually");
        }
        String msg = "Unsupported architecture " + arch + "/" + version + ", specify the path to the Biome executable manually";
        if ("ppc64le".equals(arch)) {
            throw new IllegalStateException(msg);
        }
        if ("s390x".equals(arch)) {
            throw new IllegalStateException(msg);
        }
        if ("ppc64".equals(arch)) {
            throw new IllegalStateException(msg);
        }
        if ("ppc".equals(arch)) {
            throw new IllegalStateException(msg);
        }
        if ("aarch64".equals(arch)) {
            return ARM64;
        }
        if ("arm".equals(arch)) {
            if (version.contains("v7")) {
                throw new IllegalStateException(msg);
            }
            return ARM64;
        }
        if (arch.contains("64")) {
            return X64;
        }
        throw new IllegalStateException(msg);
    }
}

