/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.PlatformInfo;
import java.io.File;
import java.util.Optional;

final class NodeExecutableResolver {
    private NodeExecutableResolver() {
    }

    static String nodeExecutableName() {
        Object nodeName = "node";
        if (PlatformInfo.normalizedOS() == PlatformInfo.OS.WINDOWS) {
            nodeName = (String)nodeName + ".exe";
        }
        return nodeName;
    }

    static Optional<File> tryFindNextTo(File npmExecutable) {
        if (npmExecutable == null) {
            return Optional.empty();
        }
        File nodeExecutable = new File(npmExecutable.getParentFile(), NodeExecutableResolver.nodeExecutableName());
        if (nodeExecutable.exists() && nodeExecutable.isFile() && nodeExecutable.canExecute()) {
            return Optional.of(nodeExecutable);
        }
        return Optional.empty();
    }

    public static String explainMessage() {
        return "Spotless was unable to find a node executable.\nEither specify the node executable explicitly or make sure it can be found next to the npm executable.";
    }
}

