/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.biome;

import com.diffplug.spotless.biome.Architecture;
import com.diffplug.spotless.biome.OS;

class Platform {
    private final Architecture architecture;
    private final OS os;

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        return new Platform(os, architecture);
    }

    public Platform(OS os, Architecture architecture) {
        this.os = os;
        this.architecture = architecture;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public OS getOs() {
        return this.os;
    }

    public boolean isLinux() {
        return this.os == OS.LINUX;
    }

    public boolean isMac() {
        return this.os == OS.MAC_OS;
    }

    public boolean isWindows() {
        return this.os == OS.WINDOWS;
    }

    public String toString() {
        return "Platform[os=%s,architecture=%s]".formatted(new Object[]{this.os, this.architecture});
    }
}

