/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.MoreIterables;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class FormatterProperties {
    private final Properties properties = new Properties();

    private FormatterProperties() {
    }

    public static FormatterProperties from(File ... files) throws IllegalArgumentException {
        Objects.requireNonNull(files);
        return FormatterProperties.from(Arrays.asList(files));
    }

    public static FormatterProperties from(Iterable<File> files) throws IllegalArgumentException {
        List<File> nonNullFiles = MoreIterables.toNullHostileList(files);
        FormatterProperties properties = new FormatterProperties();
        nonNullFiles.forEach(properties::add);
        return properties;
    }

    public static FormatterProperties fromPropertiesContent(Iterable<String> content) throws IllegalArgumentException {
        List<String> nonNullElements = MoreIterables.toNullHostileList(content);
        FormatterProperties properties = new FormatterProperties();
        nonNullElements.forEach(contentElement -> {
            try (ByteArrayInputStream is = new ByteArrayInputStream(contentElement.getBytes(StandardCharsets.UTF_8));){
                properties.properties.load(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load properties: " + contentElement);
            }
        });
        return properties;
    }

    public static FormatterProperties fromXmlContent(Iterable<String> content) throws IllegalArgumentException {
        List<String> nonNullElements = MoreIterables.toNullHostileList(content);
        FormatterProperties properties = new FormatterProperties();
        nonNullElements.forEach(contentElement -> {
            try {
                Properties newSettings = FileParser.XML.executeXmlContent((String)contentElement);
                properties.properties.putAll((Map<?, ?>)newSettings);
            }
            catch (IOException | IllegalArgumentException exception) {
                Object message = "Failed to add preferences from XML:%n%s%n".formatted(contentElement);
                String detailedMessage = exception.getMessage();
                if (null != detailedMessage) {
                    message = (String)message + " %s".formatted(detailedMessage);
                }
                throw new IllegalArgumentException((String)message, exception);
            }
        });
        return properties;
    }

    public static FormatterProperties merge(Properties ... properties) {
        FormatterProperties merged = new FormatterProperties();
        List.of(properties).stream().forEach(source -> merged.properties.putAll((Map<?, ?>)source));
        return merged;
    }

    private void add(File settingsFile) throws IllegalArgumentException {
        Objects.requireNonNull(settingsFile);
        if (!settingsFile.isFile() || !settingsFile.canRead()) {
            String msg = "Settings file '%s' does not exist or can not be read.".formatted(settingsFile);
            throw new IllegalArgumentException(msg);
        }
        try {
            Properties newSettings = FileParser.parse(settingsFile);
            this.properties.putAll((Map<?, ?>)newSettings);
        }
        catch (IOException | IllegalArgumentException exception) {
            Object message = "Failed to add properties from '%s' to formatter settings.".formatted(settingsFile);
            String detailedMessage = exception.getMessage();
            if (null != detailedMessage) {
                message = (String)message + " %s".formatted(detailedMessage);
            }
            throw new IllegalArgumentException((String)message, exception);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum FileParser {
        LINE_ORIENTED(new String[]{"properties", "prefs"}){

            @Override
            protected Properties execute(File file) throws IOException, IllegalArgumentException {
                Properties properties = new Properties();
                try (FileInputStream inputProperties = new FileInputStream(file);){
                    properties.load(inputProperties);
                }
                return properties;
            }

            @Override
            protected Properties executeXmlContent(String content) throws IOException, IllegalArgumentException {
                throw new RuntimeException("Not implemented");
            }
        }
        ,
        XML(new String[]{"xml"}){

            @Override
            protected Properties execute(File file) throws IOException, IllegalArgumentException {
                return this.executeWithSupplier(() -> {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException("File not found: " + String.valueOf(file), e);
                    }
                });
            }

            @Override
            protected Properties executeXmlContent(String content) throws IOException, IllegalArgumentException {
                return this.executeWithSupplier(() -> new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            }

            private Properties executeWithSupplier(Supplier<InputStream> isSupplier) throws IOException, IllegalArgumentException {
                Node rootNode;
                try (InputStream input = isSupplier.get();){
                    rootNode = this.getRootNode(input);
                    String nodeName = rootNode.getNodeName();
                    if (null == nodeName) {
                        throw new IllegalArgumentException("XML document does not contain a root node.");
                    }
                }
                input = isSupplier.get();
                try {
                    Properties properties = XmlParser.parse(input, rootNode);
                    return properties;
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }

            private Node getRootNode(InputStream is) throws IOException, IllegalArgumentException {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setFeature(FileParser.LOAD_EXTERNAL_DTD_PROP, false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    return db.parse(is).getDocumentElement();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IllegalArgumentException("File has no valid XML syntax.", e);
                }
            }
        };

        private static final String LOAD_EXTERNAL_DTD_PROP = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        private static final char FILE_EXTENSION_SEPARATOR = '.';
        private final List<String> supportedFileNameExtensions;

        private FileParser(String ... supportedFileNameExtensions) {
            this.supportedFileNameExtensions = Arrays.asList(supportedFileNameExtensions);
        }

        protected abstract Properties execute(File var1) throws IOException, IllegalArgumentException;

        protected abstract Properties executeXmlContent(String var1) throws IOException, IllegalArgumentException;

        public static Properties parse(File file) throws IOException, IllegalArgumentException {
            String fileNameExtension = FileParser.getFileNameExtension(file);
            for (FileParser parser : FileParser.values()) {
                if (!parser.supportedFileNameExtensions.contains(fileNameExtension)) continue;
                return parser.execute(file);
            }
            String msg = "The file name extension '%1$s' is not part of the supported file extensions [%2$s].".formatted(fileNameExtension, Arrays.toString((Object[])FileParser.values()));
            throw new IllegalArgumentException(msg);
        }

        private static String getFileNameExtension(File file) {
            String fileName = file.getName();
            int seperatorPos = fileName.lastIndexOf(46);
            return 0 > seperatorPos ? "" : fileName.substring(seperatorPos + 1);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum XmlParser {
        PROPERTIES("properties"){

            @Override
            protected Properties execute(InputStream xmlFile, Node rootNode) throws IOException, IllegalArgumentException {
                Properties properties = new Properties();
                properties.loadFromXML(xmlFile);
                return properties;
            }
        }
        ,
        PROFILES("profiles"){

            @Override
            protected Properties execute(InputStream file, Node rootNode) throws IOException, IllegalArgumentException {
                Properties properties = new Properties();
                Node firstProfile = this.getSingleProfile(rootNode);
                Iterator<Node> iterator = this.getChildren(firstProfile, "setting").iterator();
                while (iterator.hasNext()) {
                    Node settingObj;
                    Node setting = settingObj = iterator.next();
                    NamedNodeMap attributes = setting.getAttributes();
                    Node id = attributes.getNamedItem("id");
                    Node value = attributes.getNamedItem("value");
                    if (null == id) {
                        throw new IllegalArgumentException("Node 'setting' does not possess an 'id' attribute.");
                    }
                    String idString = id.getNodeValue();
                    String valString = null == value ? "" : value.getNodeValue();
                    properties.setProperty(idString, valString);
                }
                return properties;
            }

            private Node getSingleProfile(Node rootNode) throws IllegalArgumentException {
                List<Node> profiles = this.getChildren(rootNode, "profile");
                if (profiles.isEmpty()) {
                    throw new IllegalArgumentException("The formatter configuration profile files does not contain any 'profile' elements.");
                }
                if (profiles.size() > 1) {
                    Object message = "Formatter configuration file contains multiple profiles: [";
                    message = (String)message + profiles.stream().map(XmlParser::getProfileName).collect(Collectors.joining("; "));
                    message = (String)message + "]%n The formatter can only cope with a single profile per configuration file. Please remove the other profiles.";
                    throw new IllegalArgumentException((String)message);
                }
                return profiles.iterator().next();
            }

            private List<Node> getChildren(Node node, String nodeName) {
                NodeList children = node.getChildNodes();
                return IntStream.range(0, children.getLength()).mapToObj(children::item).filter(child -> child.getNodeName().equals(nodeName)).collect(Collectors.toCollection(LinkedList::new));
            }
        };

        private final String rootNodeName;

        private static String getProfileName(Node profile) {
            Node nameAttribute = profile.getAttributes().getNamedItem("name");
            return null == nameAttribute ? "" : nameAttribute.getNodeValue();
        }

        private XmlParser(String rootNodeName) {
            this.rootNodeName = rootNodeName;
        }

        public String toString() {
            return this.rootNodeName;
        }

        protected abstract Properties execute(InputStream var1, Node var2) throws IOException, IllegalArgumentException;

        public static Properties parse(InputStream is, Node rootNode) throws IOException, IllegalArgumentException {
            String rootNodeName = rootNode.getNodeName();
            for (XmlParser parser : XmlParser.values()) {
                if (!parser.rootNodeName.equals(rootNodeName)) continue;
                return parser.execute(is, rootNode);
            }
            String msg = "The XML root node '%1$s' is not part of the supported root nodes [%2$s].".formatted(rootNodeName, Arrays.toString((Object[])XmlParser.values()));
            throw new IllegalArgumentException(msg);
        }
    }
}

