/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.NodeExecutableResolver;
import com.diffplug.spotless.npm.NpmExecutableResolver;
import com.diffplug.spotless.npm.NpmResourceHelper;
import com.diffplug.spotless.npm.NpmrcResolver;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class NpmPathResolver {
    private final File explicitNpmExecutable;
    private final File explicitNodeExecutable;
    private final File explicitNpmrcFile;
    private final List<File> additionalNpmrcLocations;

    public NpmPathResolver(File explicitNpmExecutable, File explicitNodeExecutable, File explicitNpmrcFile, List<File> additionalNpmrcLocations) {
        this.explicitNpmExecutable = explicitNpmExecutable;
        this.explicitNodeExecutable = explicitNodeExecutable;
        this.explicitNpmrcFile = explicitNpmrcFile;
        this.additionalNpmrcLocations = List.copyOf(additionalNpmrcLocations);
    }

    public File resolveNpmExecutable() {
        File nodeExecutableCandidate;
        if (this.explicitNpmExecutable != null) {
            return this.explicitNpmExecutable;
        }
        if (this.explicitNodeExecutable != null && (nodeExecutableCandidate = new File(this.explicitNodeExecutable.getParentFile(), NpmExecutableResolver.npmExecutableName())).canExecute()) {
            return nodeExecutableCandidate;
        }
        return NpmExecutableResolver.tryFind().orElseThrow(() -> new IllegalStateException("Can't automatically determine npm executable and none was specifically supplied!\n\n" + NpmExecutableResolver.explainMessage()));
    }

    public File resolveNodeExecutable() {
        if (this.explicitNodeExecutable != null) {
            return this.explicitNodeExecutable;
        }
        File npmExecutable = this.resolveNpmExecutable();
        return NodeExecutableResolver.tryFindNextTo(npmExecutable).orElseThrow(() -> new IllegalStateException("Can't automatically determine node executable and none was specifically supplied!\n\n" + NodeExecutableResolver.explainMessage()));
    }

    public String resolveNpmrcContent() {
        File npmrcFile = Optional.ofNullable(this.explicitNpmrcFile).orElseGet(() -> new NpmrcResolver(this.additionalNpmrcLocations).tryFind().orElse(null));
        if (npmrcFile != null) {
            return NpmResourceHelper.readUtf8StringFromFile(npmrcFile);
        }
        return null;
    }
}

