/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.java;

import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import com.diffplug.spotless.extra.P2Provisioner;
import dev.equo.solstice.p2.P2Model;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;

public final class EclipseJdtFormatterStep {
    private static final String NAME = "eclipse jdt formatter";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse jdt formatter").add(17, (Object)"4.35");

    private EclipseJdtFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static Builder createBuilder(Provisioner provisioner, P2Provisioner p2Provisioner) {
        return new Builder(NAME, provisioner, p2Provisioner, EclipseJdtFormatterStep.defaultVersion(), (SerializedFunction<EquoBasedStepBuilder.State, FormatterFunc>)((SerializedFunction & Serializable)EclipseJdtFormatterStep::apply), (ImmutableMap.Builder<String, String>)ImmutableMap.builder());
    }

    private static FormatterFunc apply(EquoBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.getJarState().getClassLoader().loadClass("com.diffplug.spotless.extra.glue.jdt.EclipseJdtFormatterStepImpl");
        Object formatter = formatterClazz.getConstructor(Properties.class, Map.class).newInstance(state.getPreferences(), state.getStepProperties());
        Method method = formatterClazz.getMethod("format", String.class, File.class);
        FormatterFunc.NeedsFile formatterFunc = (input, file) -> (String)method.invoke(formatter, input, file);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), (FormatterFunc)formatterFunc);
    }

    public static class Builder
    extends EquoBasedStepBuilder {
        private final ImmutableMap.Builder<String, String> stepProperties;

        Builder(String formatterName, Provisioner mavenProvisioner, P2Provisioner p2Provisioner, String defaultVersion, SerializedFunction<EquoBasedStepBuilder.State, FormatterFunc> stateToFormatter, ImmutableMap.Builder<String, String> stepProperties) {
            super(formatterName, mavenProvisioner, p2Provisioner, defaultVersion, stateToFormatter, stepProperties);
            this.stepProperties = stepProperties;
        }

        @Override
        protected P2Model model(String version) {
            P2Model model = new P2Model();
            this.addPlatformRepo(model, version);
            model.getInstall().add("org.eclipse.jdt.core");
            return model;
        }

        @Override
        public void setVersion(String version) {
            if (version.endsWith(".0")) {
                String newVersion = version.substring(0, version.length() - 2);
                System.err.println("Recommend replacing '" + version + "' with '" + newVersion + "' for Eclipse JDT");
                version = newVersion;
            }
            super.setVersion(version);
        }

        public void sortMembersDoNotSortFields(boolean doNotSortFields) {
            boolean sortAllMembers = !doNotSortFields;
            this.stepProperties.put((Object)"sp_cleanup.sort_members_all", (Object)String.valueOf(sortAllMembers));
        }

        public void sortMembersEnabled(boolean enabled) {
            this.stepProperties.put((Object)"sp_cleanup.sort_members", (Object)String.valueOf(enabled));
        }

        public void sortMembersOrder(String order) {
            this.stepProperties.put((Object)"outlinesortoption", (Object)order);
        }

        public void sortMembersVisibilityOrder(String order) {
            this.stepProperties.put((Object)"org.eclipse.jdt.ui.visibility.order", (Object)order);
        }

        public void sortMembersVisibilityOrderEnabled(boolean enabled) {
            this.stepProperties.put((Object)"org.eclipse.jdt.ui.enable.visibility.order", (Object)String.valueOf(enabled));
        }
    }
}

