/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.HashMap;

@SuppressForbidden
class JenkinsInfo
extends CIProviderInfo {
    public static final String JENKINS = "JENKINS_URL";
    public static final String JENKINS_PROVIDER_NAME = "jenkins";
    public static final String JENKINS_PIPELINE_ID = "BUILD_TAG";
    public static final String JENKINS_PIPELINE_NUMBER = "BUILD_NUMBER";
    public static final String JENKINS_PIPELINE_URL = "BUILD_URL";
    public static final String JENKINS_PIPELINE_NAME = "JOB_NAME";
    public static final String JENKINS_JOB_URL = "JOB_URL";
    public static final String JENKINS_WORKSPACE_PATH = "WORKSPACE";
    public static final String JENKINS_GIT_REPOSITORY_URL = "GIT_URL";
    public static final String JENKINS_GIT_COMMIT = "GIT_COMMIT";
    public static final String JENKINS_GIT_BRANCH = "GIT_BRANCH";

    JenkinsInfo() {
    }

    @Override
    protected GitInfo buildCIGitInfo() {
        return new GitInfo(this.filterSensitiveInfo(System.getenv(JENKINS_GIT_REPOSITORY_URL)), this.buildGitBranch(), this.buildGitTag(), new CommitInfo(System.getenv(JENKINS_GIT_COMMIT)));
    }

    @Override
    protected CIProviderInfo.CIInfo buildCIInfo() {
        String gitBranch = this.buildGitBranch();
        return CIProviderInfo.CIInfo.builder().ciProviderName(JENKINS_PROVIDER_NAME).ciPipelineId(System.getenv(JENKINS_PIPELINE_ID)).ciPipelineName(this.buildCiPipelineName(gitBranch)).ciPipelineNumber(System.getenv(JENKINS_PIPELINE_NUMBER)).ciPipelineUrl(System.getenv(JENKINS_PIPELINE_URL)).ciWorkspace(this.expandTilde(System.getenv(JENKINS_WORKSPACE_PATH))).build();
    }

    private String buildGitBranch() {
        String gitBranchOrTag = System.getenv(JENKINS_GIT_BRANCH);
        if (gitBranchOrTag != null && !gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitTag() {
        String gitBranchOrTag = System.getenv(JENKINS_GIT_BRANCH);
        if (gitBranchOrTag != null && gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildCiPipelineName(String branch) {
        String jobName = System.getenv(JENKINS_PIPELINE_NAME);
        return this.filterJenkinsJobName(jobName, branch);
    }

    private String filterJenkinsJobName(String jobName, String gitBranch) {
        if (jobName == null) {
            return null;
        }
        String jobNameNoBranch = gitBranch != null ? jobName.trim().replace("/" + gitBranch, "") : jobName;
        HashMap<String, String> configurations = new HashMap<String, String>();
        String[] jobNameParts = jobNameNoBranch.split("/");
        if (jobNameParts.length > 1 && jobNameParts[1].contains("=")) {
            String[] configsKeyValue;
            String configsStr = jobNameParts[1].toLowerCase().trim();
            for (String configKeyValue : configsKeyValue = configsStr.split(",")) {
                String[] keyValue = configKeyValue.trim().split("=");
                configurations.put(keyValue[0], keyValue[1]);
            }
        }
        if (configurations.isEmpty()) {
            return jobNameNoBranch;
        }
        return jobNameParts[0];
    }
}

