/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

final class ConfigConverter {
    private static final Logger log = LoggerFactory.getLogger(ConfigConverter.class);
    private static final Pattern COMMA_SEPARATED = Pattern.compile("(([^,:]+:[^,:]*,)*([^,:]+:[^,:]*),?)?");
    private static final Pattern SPACE_SEPARATED = Pattern.compile("((\\S+:\\S*)\\s+)*(\\S+:\\S*)?");
    private static final Pattern ILLEGAL_SPACE_SEPARATED = Pattern.compile("(:\\S+:)+");
    private static final ValueOfLookup LOOKUP = new ValueOfLookup();

    ConfigConverter() {
    }

    static <T> T valueOf(String value, @Nonnull Class<T> tClass) {
        Objects.requireNonNull(tClass, "tClass is marked non-null but is null");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            return (T)((MethodHandle)LOOKUP.get(tClass)).invoke(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Throwable e) {
            log.debug("Can't parse: ", e);
            throw new NumberFormatException(e.toString());
        }
    }

    @Nonnull
    static List<String> parseList(String str) {
        return ConfigConverter.parseList(str, ",");
    }

    @Nonnull
    @SuppressForbidden
    static List<String> parseList(String str, String separator) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = str.split(separator, -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    @Nonnull
    static Map<String, String> parseMap(String str, String settingName) {
        if (str == null) {
            return Collections.emptyMap();
        }
        String trimmed = str.trim();
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        if (COMMA_SEPARATED.matcher(trimmed).matches()) {
            return ConfigConverter.parseMap(str, settingName, ",");
        }
        if (SPACE_SEPARATED.matcher(trimmed).matches() && !ILLEGAL_SPACE_SEPARATED.matcher(trimmed).find()) {
            return ConfigConverter.parseMap(str, settingName, "\\s+");
        }
        log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2' or 'key1:value1 key2:value2'.", (Object)settingName, (Object)str);
        return Collections.emptyMap();
    }

    @SuppressForbidden
    private static Map<String, String> parseMap(String str, String settingName, String separator) {
        String[] tokens = str.split(separator);
        Map<String, String> map = ConfigConverter.newHashMap(tokens.length);
        for (String token : tokens) {
            String[] keyValue = token.split(":", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            if (value.length() <= 0) {
                log.warn("Ignoring empty value for key '{}' in config for {}", (Object)key, (Object)settingName);
                continue;
            }
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    @Nonnull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @Nonnull
    @SuppressForbidden
    static BitSet parseIntegerRangeSet(@Nonnull String str, String settingName) throws NumberFormatException {
        String[] tokens;
        if (!(str = str.replaceAll("\\s", "")).matches("\\d{3}(?:-\\d{3})?(?:,\\d{3}(?:-\\d{3})?)*")) {
            log.warn("Invalid config for {}: '{}'. Must be formatted like '400-403,405,410-499'.", (Object)settingName, (Object)str);
            throw new NumberFormatException();
        }
        int lastSeparator = Math.max(str.lastIndexOf(44), str.lastIndexOf(45));
        int maxValue = Integer.parseInt(str.substring(lastSeparator + 1));
        BitSet set = new BitSet(maxValue);
        for (String token : tokens = str.split(",", -1)) {
            int separator = token.indexOf(45);
            if (separator == -1) {
                set.set(Integer.parseInt(token));
                continue;
            }
            if (separator <= 0) continue;
            int left = Integer.parseInt(token.substring(0, separator));
            int right = Integer.parseInt(token.substring(separator + 1));
            int min = Math.min(left, right);
            int max = Math.max(left, right);
            set.set(min, max + 1);
        }
        return set;
    }

    private static class ValueOfLookup
    extends ClassValue<MethodHandle> {
        private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

        private ValueOfLookup() {
        }

        @Override
        protected MethodHandle computeValue(Class<?> type) {
            try {
                return PUBLIC_LOOKUP.findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                log.debug("Can't invoke or access 'valueOf': ", e);
                throw new RuntimeException(e);
            }
        }
    }
}

