/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.cache;

import datadog.trace.api.Function;
import datadog.trace.api.Pair;
import datadog.trace.api.cache.DDCache;

final class FixedSizeCache<K, V>
implements DDCache<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private final int mask;
    private final Pair<K, V>[] elements;

    public FixedSizeCache(int capacity) {
        int n;
        if (capacity <= 0) {
            throw new IllegalArgumentException("Cache capacity must be > 0");
        }
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        n = (n = -1 >>> Integer.numberOfLeadingZeros(capacity - 1)) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
        Pair[] lmnts = new Pair[n];
        this.elements = lmnts;
        this.mask = n - 1;
    }

    @Override
    public V computeIfAbsent(K key, Function<K, ? extends V> creator) {
        V value;
        if (key == null) {
            return null;
        }
        int h = key.hashCode();
        int firstPos = h & this.mask;
        int i = 1;
        while (true) {
            int pos;
            Pair<K, V> current;
            if ((current = this.elements[pos = h & this.mask]) == null) {
                value = this.createAndStoreValue(key, creator, pos);
                break;
            }
            if (key.equals(current.getLeft())) {
                value = current.getRight();
                break;
            }
            if (i == 3) {
                value = this.createAndStoreValue(key, creator, firstPos);
                break;
            }
            h = this.rehash(h);
            ++i;
        }
        return value;
    }

    private V createAndStoreValue(K key, Function<K, ? extends V> creator, int pos) {
        V value = creator.apply(key);
        this.elements[pos] = Pair.of(key, value);
        return value;
    }

    private int rehash(int v) {
        int h = v * -1640532531;
        h = Integer.reverseBytes(h);
        return h * -1640532531;
    }
}

