/*
 * Decompiled with CFR 0.152.
 */
package datadog.common.exec;

import java.util.concurrent.ThreadFactory;

public final class DaemonThreadFactory
implements ThreadFactory {
    public static final DaemonThreadFactory TRACE_PROCESSOR = new DaemonThreadFactory("dd-trace-processor");
    public static final DaemonThreadFactory TRACE_WRITER = new DaemonThreadFactory("dd-trace-writer");
    public static final DaemonThreadFactory TASK_SCHEDULER = new DaemonThreadFactory("dd-task-scheduler");
    private final String threadName;
    private final Runnable initializer;

    public DaemonThreadFactory(String threadName) {
        this(threadName, null);
    }

    private DaemonThreadFactory(String threadName, Runnable initializer) {
        this.threadName = threadName;
        this.initializer = initializer;
    }

    public ThreadFactory withInitializer(Runnable initializer) {
        return new DaemonThreadFactory(this.threadName, initializer);
    }

    @Override
    public Thread newThread(final Runnable r) {
        Runnable runnable = r;
        if (this.initializer != null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    DaemonThreadFactory.this.initializer.run();
                    r.run();
                }
            };
        }
        Thread thread = new Thread(runnable, this.threadName);
        thread.setDaemon(true);
        thread.setContextClassLoader(null);
        return thread;
    }
}

