/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.config.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsOAuth2ClientProperties;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOAuth2LogoutRequestUriBuilder
implements LogoutRequestUriBuilder {
    private static final String OIDC_RP_INITIATED_LOGOUT_CONFIGURATION_ENTRY = "end_session_endpoint";
    private static final String OIDC_RP_INITIATED_LOGOUT_CLIENT_ID_REQUEST_PARAM = "client_id";
    private static final String OIDC_RP_INITIATED_LOGOUT_ID_TOKEN_HINT_REQUEST_PARAM = "id_token_hint";
    private static final String OIDC_RP_INITIATED_LOGOUT_POST_LOGOUT_URI_REQUEST_PARAM = "post_logout_redirect_uri";
    private final SpringAddonsOAuth2ClientProperties clientProperties;

    @Override
    public String getLogoutRequestUri(ClientRegistration clientRegistration, String idToken, URI postLogoutUri) {
        Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps = this.clientProperties.getLogoutProperties(clientRegistration.getRegistrationId());
        URI logoutEndpointUri = this.getLogoutEndpointUri(logoutProps, clientRegistration).orElseThrow(() -> new MisconfiguredProviderException(clientRegistration.getRegistrationId()));
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)logoutEndpointUri);
        this.getIdTokenHintRequestParam(logoutProps).ifPresent(idTokenHintParamName -> {
            if (StringUtils.hasText((String)idToken)) {
                builder.queryParam(idTokenHintParamName, new Object[]{idToken});
            }
        });
        this.getClientIdRequestParam(logoutProps).ifPresent(clientIdParamName -> {
            if (StringUtils.hasText((String)clientRegistration.getClientId())) {
                builder.queryParam(clientIdParamName, new Object[]{clientRegistration.getClientId()});
            }
        });
        this.getPostLogoutUriRequestParam(logoutProps).ifPresent(postLogoutUriParamName -> {
            if (postLogoutUri != null && StringUtils.hasText((String)postLogoutUri.toString())) {
                builder.queryParam(postLogoutUriParamName, new Object[]{postLogoutUri});
            }
        });
        return builder.encode(StandardCharsets.UTF_8).build().toUriString();
    }

    @Override
    public String getLogoutRequestUri(ClientRegistration clientRegistration, String idToken) {
        return this.getLogoutRequestUri(clientRegistration, idToken, this.clientProperties.getPostLogoutRedirectUri());
    }

    public Optional<URI> getLogoutEndpointUri(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps, ClientRegistration clientRegistration) {
        if (logoutProps.isPresent()) {
            return Optional.ofNullable(logoutProps.get().getUri());
        }
        Map oidcConfig = clientRegistration.getProviderDetails().getConfigurationMetadata();
        return Optional.ofNullable(oidcConfig.get(OIDC_RP_INITIATED_LOGOUT_CONFIGURATION_ENTRY)).map(Object::toString).map(URI::create);
    }

    public Optional<String> getIdTokenHintRequestParam(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_ID_TOKEN_HINT_REQUEST_PARAM);
        }
        return logoutProps.get().getIdTokenHintRequestParam();
    }

    public Optional<String> getClientIdRequestParam(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_CLIENT_ID_REQUEST_PARAM);
        }
        return logoutProps.get().getClientIdRequestParam();
    }

    public Optional<String> getPostLogoutUriRequestParam(Optional<SpringAddonsOAuth2ClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_POST_LOGOUT_URI_REQUEST_PARAM);
        }
        return logoutProps.get().getPostLogoutUriRequestParam();
    }

    @Generated
    public SpringAddonsOAuth2ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOAuth2LogoutRequestUriBuilder)) {
            return false;
        }
        SpringAddonsOAuth2LogoutRequestUriBuilder other = (SpringAddonsOAuth2LogoutRequestUriBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SpringAddonsOAuth2ClientProperties this$clientProperties = this.getClientProperties();
        SpringAddonsOAuth2ClientProperties other$clientProperties = other.getClientProperties();
        return !(this$clientProperties == null ? other$clientProperties != null : !((Object)this$clientProperties).equals(other$clientProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOAuth2LogoutRequestUriBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpringAddonsOAuth2ClientProperties $clientProperties = this.getClientProperties();
        result = result * 59 + ($clientProperties == null ? 43 : ((Object)$clientProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOAuth2LogoutRequestUriBuilder(clientProperties=" + this.getClientProperties() + ")";
    }

    @Generated
    public SpringAddonsOAuth2LogoutRequestUriBuilder(SpringAddonsOAuth2ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    static final class MisconfiguredProviderException
    extends RuntimeException {
        private static final long serialVersionUID = -7076019485141231080L;

        public MisconfiguredProviderException(String clientRegistrationId) {
            super("OAuth2 client registration for %s RP-Initiated Logout is missconfigured: it is neither OIDC complient nor difiend in spring-addons properties".formatted(clientRegistrationId));
        }
    }
}

