/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.report.api;

import com.synopsys.integration.blackduck.report.api.BomComponent;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class ReportData {
    private String projectName;
    private String projectURL;
    private String projectVersion;
    private String projectVersionURL;
    private String phase;
    private String distribution;
    private List<BomComponent> components;
    private int totalComponents;
    private int vulnerabilityRiskHighCount;
    private int vulnerabilityRiskMediumCount;
    private int vulnerabilityRiskLowCount;
    private int vulnerabilityRiskNoneCount;
    private int licenseRiskHighCount;
    private int licenseRiskMediumCount;
    private int licenseRiskLowCount;
    private int licenseRiskNoneCount;
    private int operationalRiskHighCount;
    private int operationalRiskMediumCount;
    private int operationalRiskLowCount;
    private int operationalRiskNoneCount;

    public String htmlEscape(String valueToEscape) {
        if (StringUtils.isBlank((CharSequence)valueToEscape)) {
            return null;
        }
        return StringEscapeUtils.escapeHtml4((String)valueToEscape);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectURL() {
        return this.projectURL;
    }

    public void setProjectURL(String projectURL) {
        this.projectURL = projectURL;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getProjectVersionURL() {
        return this.projectVersionURL;
    }

    public void setProjectVersionURL(String projectVersionURL) {
        this.projectVersionURL = projectVersionURL;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public int getTotalComponents() {
        return this.totalComponents;
    }

    public int getVulnerabilityRiskHighCount() {
        return this.vulnerabilityRiskHighCount;
    }

    public int getVulnerabilityRiskMediumCount() {
        return this.vulnerabilityRiskMediumCount;
    }

    public int getVulnerabilityRiskLowCount() {
        return this.vulnerabilityRiskLowCount;
    }

    public int getVulnerabilityRiskNoneCount() {
        return this.vulnerabilityRiskNoneCount;
    }

    public int getLicenseRiskHighCount() {
        return this.licenseRiskHighCount;
    }

    public int getLicenseRiskMediumCount() {
        return this.licenseRiskMediumCount;
    }

    public int getLicenseRiskLowCount() {
        return this.licenseRiskLowCount;
    }

    public int getLicenseRiskNoneCount() {
        return this.licenseRiskNoneCount;
    }

    public int getOperationalRiskHighCount() {
        return this.operationalRiskHighCount;
    }

    public int getOperationalRiskMediumCount() {
        return this.operationalRiskMediumCount;
    }

    public int getOperationalRiskLowCount() {
        return this.operationalRiskLowCount;
    }

    public int getOperationalRiskNoneCount() {
        return this.operationalRiskNoneCount;
    }

    public List<BomComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<BomComponent> components) {
        this.components = components;
        this.vulnerabilityRiskHighCount = 0;
        this.vulnerabilityRiskMediumCount = 0;
        this.vulnerabilityRiskLowCount = 0;
        this.licenseRiskHighCount = 0;
        this.licenseRiskMediumCount = 0;
        this.licenseRiskLowCount = 0;
        this.operationalRiskHighCount = 0;
        this.operationalRiskMediumCount = 0;
        this.operationalRiskLowCount = 0;
        for (BomComponent component : components) {
            if (component == null) continue;
            if (component.getSecurityRiskHighCount() > 0) {
                ++this.vulnerabilityRiskHighCount;
            } else if (component.getSecurityRiskMediumCount() > 0) {
                ++this.vulnerabilityRiskMediumCount;
            } else if (component.getSecurityRiskLowCount() > 0) {
                ++this.vulnerabilityRiskLowCount;
            }
            if (component.getLicenseRiskHighCount() > 0) {
                ++this.licenseRiskHighCount;
            } else if (component.getLicenseRiskMediumCount() > 0) {
                ++this.licenseRiskMediumCount;
            } else if (component.getLicenseRiskLowCount() > 0) {
                ++this.licenseRiskLowCount;
            }
            if (component.getOperationalRiskHighCount() > 0) {
                ++this.operationalRiskHighCount;
                continue;
            }
            if (component.getOperationalRiskMediumCount() > 0) {
                ++this.operationalRiskMediumCount;
                continue;
            }
            if (component.getOperationalRiskLowCount() <= 0) continue;
            ++this.operationalRiskLowCount;
        }
        this.totalComponents = components.size();
        this.vulnerabilityRiskNoneCount = this.totalComponents - this.vulnerabilityRiskHighCount - this.vulnerabilityRiskMediumCount - this.vulnerabilityRiskLowCount;
        this.licenseRiskNoneCount = this.totalComponents - this.licenseRiskHighCount - this.licenseRiskMediumCount - this.licenseRiskLowCount;
        this.operationalRiskNoneCount = this.totalComponents - this.operationalRiskHighCount - this.operationalRiskMediumCount - this.operationalRiskLowCount;
    }
}

