/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Compare;
import com.baomidou.mybatisplus.core.conditions.interfaces.Func;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.interfaces.Nested;
import com.baomidou.mybatisplus.core.conditions.segments.ColumnSegment;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.enums.WrapperKeyword;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.SerializationUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractWrapper<T, R, Children extends AbstractWrapper<T, R, Children>>
extends Wrapper<T>
implements Compare<Children, R>,
Nested<Children, Children>,
Join<Children>,
Func<Children, R> {
    protected final Children typedThis = this;
    protected AtomicInteger paramNameSeq;
    protected Map<String, Object> paramNameValuePairs;
    protected SharedString paramAlias;
    protected SharedString lastSql;
    protected SharedString sqlComment;
    protected SharedString sqlFirst;
    private T entity;
    protected MergeSegments expression;
    private Class<T> entityClass;

    @Override
    public T getEntity() {
        return this.entity;
    }

    public Children setEntity(T entity) {
        this.entity = entity;
        return this.typedThis;
    }

    public Class<T> getEntityClass() {
        if (this.entityClass == null && this.entity != null) {
            this.entityClass = this.entity.getClass();
        }
        return this.entityClass;
    }

    public Children setEntityClass(Class<T> entityClass) {
        if (entityClass != null) {
            this.entityClass = entityClass;
        }
        return this.typedThis;
    }

    @Override
    public <V> Children allEq(boolean condition, Map<R, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (StringUtils.checkValNotNull(v)) {
                    this.eq(k, v);
                } else if (null2IsNull) {
                    this.isNull(k);
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public <V> Children allEq(boolean condition, BiPredicate<R, V> filter, Map<R, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (filter.test(k, v)) {
                    if (StringUtils.checkValNotNull(v)) {
                        this.eq(k, v);
                    } else if (null2IsNull) {
                        this.isNull(k);
                    }
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public Children eq(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.EQ, val);
    }

    @Override
    public Children ne(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.NE, val);
    }

    @Override
    public Children gt(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GT, val);
    }

    @Override
    public Children ge(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GE, val);
    }

    @Override
    public Children lt(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LT, val);
    }

    @Override
    public Children le(boolean condition, R column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LE, val);
    }

    @Override
    public Children like(boolean condition, R column, Object val) {
        return this.likeValue(condition, SqlKeyword.LIKE, column, val, SqlLike.DEFAULT);
    }

    @Override
    public Children notLike(boolean condition, R column, Object val) {
        return this.likeValue(condition, SqlKeyword.NOT_LIKE, column, val, SqlLike.DEFAULT);
    }

    @Override
    public Children likeLeft(boolean condition, R column, Object val) {
        return this.likeValue(condition, SqlKeyword.LIKE, column, val, SqlLike.LEFT);
    }

    @Override
    public Children likeRight(boolean condition, R column, Object val) {
        return this.likeValue(condition, SqlKeyword.LIKE, column, val, SqlLike.RIGHT);
    }

    @Override
    public Children notLikeLeft(boolean condition, R column, Object val) {
        return this.likeValue(condition, SqlKeyword.NOT_LIKE, column, val, SqlLike.LEFT);
    }

    @Override
    public Children notLikeRight(boolean condition, R column, Object val) {
        return this.likeValue(condition, SqlKeyword.NOT_LIKE, column, val, SqlLike.RIGHT);
    }

    @Override
    public Children between(boolean condition, R column, Object val1, Object val2) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.BETWEEN, () -> this.formatParam(null, val1), SqlKeyword.AND, () -> this.formatParam(null, val2)));
    }

    @Override
    public Children notBetween(boolean condition, R column, Object val1, Object val2) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.NOT_BETWEEN, () -> this.formatParam(null, val1), SqlKeyword.AND, () -> this.formatParam(null, val2)));
    }

    @Override
    public Children and(boolean condition, Consumer<Children> consumer) {
        return ((AbstractWrapper)this.and(condition)).addNestedCondition(condition, consumer);
    }

    @Override
    public Children or(boolean condition, Consumer<Children> consumer) {
        return ((AbstractWrapper)this.or(condition)).addNestedCondition(condition, consumer);
    }

    @Override
    public Children nested(boolean condition, Consumer<Children> consumer) {
        return this.addNestedCondition(condition, consumer);
    }

    @Override
    public Children not(boolean condition, Consumer<Children> consumer) {
        return ((AbstractWrapper)this.not(condition)).addNestedCondition(condition, consumer);
    }

    @Override
    public Children or(boolean condition) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.OR));
    }

    @Override
    public Children apply(boolean condition, String applySql, Object ... values) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(WrapperKeyword.APPLY, () -> this.formatSqlMaybeWithParam(applySql, values)));
    }

    @Override
    public Children last(boolean condition, String lastSql) {
        if (condition) {
            this.lastSql.setStringValue(" " + lastSql);
        }
        return this.typedThis;
    }

    @Override
    public Children comment(boolean condition, String comment) {
        if (condition) {
            this.sqlComment.setStringValue(comment);
        }
        return this.typedThis;
    }

    @Override
    public Children first(boolean condition, String firstSql) {
        if (condition) {
            this.sqlFirst.setStringValue(firstSql);
        }
        return this.typedThis;
    }

    @Override
    public Children exists(boolean condition, String existsSql, Object ... values) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.EXISTS, () -> String.format("(%s)", this.formatSqlMaybeWithParam(existsSql, values))));
    }

    @Override
    public Children notExists(boolean condition, String existsSql, Object ... values) {
        return (Children)((AbstractWrapper)this.not(condition)).exists(condition, existsSql, values);
    }

    @Override
    public Children isNull(boolean condition, R column) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.IS_NULL));
    }

    @Override
    public Children isNotNull(boolean condition, R column) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.IS_NOT_NULL));
    }

    @Override
    public Children in(boolean condition, R column, Collection<?> coll) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.IN, this.inExpression(coll)));
    }

    @Override
    public Children in(boolean condition, R column, Object ... values) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.IN, this.inExpression(values)));
    }

    @Override
    public Children notIn(boolean condition, R column, Collection<?> coll) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.NOT_IN, this.inExpression(coll)));
    }

    @Override
    public Children notIn(boolean condition, R column, Object ... values) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.NOT_IN, this.inExpression(values)));
    }

    @Override
    public Children eqSql(boolean condition, R column, String eqValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.EQ, () -> String.format("(%s)", eqValue)));
    }

    @Override
    public Children inSql(boolean condition, R column, String inValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.IN, () -> String.format("(%s)", inValue)));
    }

    @Override
    public Children gtSql(boolean condition, R column, String inValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.GT, () -> String.format("(%s)", inValue)));
    }

    @Override
    public Children geSql(boolean condition, R column, String inValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.GE, () -> String.format("(%s)", inValue)));
    }

    @Override
    public Children ltSql(boolean condition, R column, String inValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.LT, () -> String.format("(%s)", inValue)));
    }

    @Override
    public Children leSql(boolean condition, R column, String inValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.LE, () -> String.format("(%s)", inValue)));
    }

    @Override
    public Children notInSql(boolean condition, R column, String inValue) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), SqlKeyword.NOT_IN, () -> String.format("(%s)", inValue)));
    }

    @Override
    public Children groupBy(boolean condition, R column, R ... columns) {
        return this.doGroupBy(condition, column, CollectionUtils.toList(columns));
    }

    @Override
    public Children groupBy(boolean condition, R column, List<R> columns) {
        return this.doGroupBy(condition, column, columns);
    }

    public Children doGroupBy(boolean condition, R column, List<R> columns) {
        return this.maybeDo(condition, () -> {
            String one = "";
            if (column != null) {
                one = this.columnToString(column);
            }
            if (CollectionUtils.isNotEmpty(columns)) {
                one = one + (column != null ? "," + this.columnsToString(columns) : this.columnsToString(columns));
            }
            String finalOne = one;
            this.appendSqlSegments(SqlKeyword.GROUP_BY, () -> finalOne);
        });
    }

    public Children doOrderBy(boolean condition, boolean isAsc, R column, List<R> columns) {
        return this.maybeDo(condition, () -> {
            SqlKeyword mode;
            SqlKeyword sqlKeyword = mode = isAsc ? SqlKeyword.ASC : SqlKeyword.DESC;
            if (column != null) {
                this.appendSqlSegments(SqlKeyword.ORDER_BY, this.columnToSqlSegment(column), mode);
            }
            if (CollectionUtils.isNotEmpty(columns)) {
                columns.forEach(c -> this.appendSqlSegments(SqlKeyword.ORDER_BY, this.columnToSqlSegment(c), mode));
            }
        });
    }

    @Override
    public Children orderBy(boolean condition, boolean isAsc, R column, R ... columns) {
        return this.doOrderBy(condition, isAsc, column, CollectionUtils.toList(columns));
    }

    @Override
    public Children orderBy(boolean condition, boolean isAsc, R column, List<R> columns) {
        return this.doOrderBy(condition, isAsc, column, columns);
    }

    @Override
    public Children groupBy(boolean condition, R column) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.GROUP_BY, () -> this.columnToString(column)));
    }

    @Override
    public Children groupBy(boolean condition, List<R> columns) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.GROUP_BY, () -> this.columnsToString(columns)));
    }

    @Override
    public Children orderBy(boolean condition, boolean isAsc, R column) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.ORDER_BY, this.columnToSqlSegment(column), isAsc ? SqlKeyword.ASC : SqlKeyword.DESC));
    }

    @Override
    public Children orderBy(boolean condition, boolean isAsc, List<R> columns) {
        return this.maybeDo(condition, () -> columns.forEach(c -> this.appendSqlSegments(SqlKeyword.ORDER_BY, this.columnToSqlSegment(c), isAsc ? SqlKeyword.ASC : SqlKeyword.DESC)));
    }

    @Override
    public Children having(boolean condition, String sqlHaving, Object ... params) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.HAVING, () -> this.formatSqlMaybeWithParam(sqlHaving, params)));
    }

    @Override
    public Children func(boolean condition, Consumer<Children> consumer) {
        return this.maybeDo(condition, () -> consumer.accept(this.typedThis));
    }

    protected Children not(boolean condition) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.NOT));
    }

    protected Children and(boolean condition) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(SqlKeyword.AND));
    }

    protected Children likeValue(boolean condition, SqlKeyword keyword, R column, Object val, SqlLike sqlLike) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), keyword, () -> this.formatParam(null, SqlUtils.concatLike(val, sqlLike))));
    }

    protected Children addCondition(boolean condition, R column, SqlKeyword sqlKeyword, Object val) {
        return this.maybeDo(condition, () -> this.appendSqlSegments(this.columnToSqlSegment(column), sqlKeyword, () -> this.formatParam(null, val)));
    }

    protected Children addNestedCondition(boolean condition, Consumer<Children> consumer) {
        return this.maybeDo(condition, () -> {
            Children instance = this.instance();
            consumer.accept(instance);
            this.appendSqlSegments(new ISqlSegment[]{WrapperKeyword.APPLY, instance});
        });
    }

    protected abstract Children instance();

    protected final String formatSqlMaybeWithParam(String sqlStr, Object ... params) {
        if (StringUtils.isBlank(sqlStr)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty(params)) {
            for (int i = 0; i < params.length; ++i) {
                String target = "{" + i + "}";
                if (sqlStr.contains(target)) {
                    sqlStr = sqlStr.replace(target, this.formatParam(null, params[i]));
                    continue;
                }
                Matcher matcher = Pattern.compile("[{]" + i + ",[a-zA-Z0-9.,=]+}").matcher(sqlStr);
                if (!matcher.find()) {
                    throw ExceptionUtils.mpe("Please check the syntax correctness! sql not contains: \"%s\"", target);
                }
                String group = matcher.group();
                sqlStr = sqlStr.replace(group, this.formatParam(group.substring(target.length(), group.length() - 1), params[i]));
            }
        }
        return sqlStr;
    }

    protected final String formatParam(String mapping, Object param) {
        String genParamName = "MPGENVAL" + this.paramNameSeq.incrementAndGet();
        String paramStr = this.getParamAlias() + ".paramNameValuePairs." + genParamName;
        this.paramNameValuePairs.put(genParamName, param);
        return SqlScriptUtils.safeParam(paramStr, mapping);
    }

    protected final Children maybeDo(boolean condition, DoSomething something) {
        if (condition) {
            something.doIt();
        }
        return this.typedThis;
    }

    protected ISqlSegment inExpression(Collection<?> value) {
        if (CollectionUtils.isEmpty(value)) {
            return () -> "()";
        }
        return () -> value.stream().map(i -> this.formatParam(null, i)).collect(Collectors.joining(",", "(", ")"));
    }

    protected ISqlSegment inExpression(Object[] values) {
        if (ArrayUtils.isEmpty(values)) {
            return () -> "()";
        }
        return () -> Arrays.stream(values).map(i -> this.formatParam(null, i)).collect(Collectors.joining(",", "(", ")"));
    }

    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap<String, Object>(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
    }

    @Override
    public void clear() {
        this.entity = null;
        this.paramNameSeq.set(0);
        this.paramNameValuePairs.clear();
        this.expression.clear();
        this.lastSql.toEmpty();
        this.sqlComment.toEmpty();
        this.sqlFirst.toEmpty();
    }

    protected void appendSqlSegments(ISqlSegment ... sqlSegments) {
        this.expression.add(sqlSegments);
    }

    public boolean isUseAnnotationOrderBy() {
        String _sqlSegment = this.getSqlSegment();
        if (StringUtils.isBlank(_sqlSegment)) {
            return true;
        }
        String _sqlSegmentUpper = _sqlSegment.toUpperCase();
        return !_sqlSegmentUpper.contains("ORDER BY") && !_sqlSegmentUpper.contains("LIMIT");
    }

    @Override
    public String getSqlSegment() {
        return this.expression.getSqlSegment() + this.lastSql.getStringValue();
    }

    @Override
    public String getSqlComment() {
        if (StringUtils.isNotBlank(this.sqlComment.getStringValue())) {
            return "/*" + this.sqlComment.getStringValue() + "*/";
        }
        return null;
    }

    @Override
    public String getSqlFirst() {
        if (StringUtils.isNotBlank(this.sqlFirst.getStringValue())) {
            return this.sqlFirst.getStringValue();
        }
        return null;
    }

    @Override
    public MergeSegments getExpression() {
        return this.expression;
    }

    public String getParamAlias() {
        return this.paramAlias == null ? "ew" : this.paramAlias.getStringValue();
    }

    public Children setParamAlias(String paramAlias) {
        Assert.notEmpty(paramAlias, "paramAlias can not be empty!", new Object[0]);
        Assert.isEmpty(this.paramNameValuePairs, "Please call this method before working!", new Object[0]);
        Assert.isNull(this.paramAlias, "Please do not call the method repeatedly!", new Object[0]);
        this.paramAlias = new SharedString(paramAlias);
        return this.typedThis;
    }

    protected final ColumnSegment columnToSqlSegment(R column) {
        return () -> this.columnToString(column);
    }

    protected String columnToString(R column) {
        return (String)column;
    }

    protected String columnsToString(R ... columns) {
        return Arrays.stream(columns).map(this::columnToString).collect(Collectors.joining(","));
    }

    protected String columnsToString(List<R> columns) {
        return columns.stream().map(this::columnToString).collect(Collectors.joining(","));
    }

    public Children clone() {
        return (Children)((AbstractWrapper)SerializationUtils.clone(this.typedThis));
    }

    public Map<String, Object> getParamNameValuePairs() {
        return this.paramNameValuePairs;
    }

    @FunctionalInterface
    public static interface DoSomething {
        public void doIt();
    }
}

