// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Container group log analytics information. */
@Fluent
public final class LogAnalytics {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LogAnalytics.class);

    /*
     * The workspace id for log analytics
     */
    @JsonProperty(value = "workspaceId", required = true)
    private String workspaceId;

    /*
     * The workspace key for log analytics
     */
    @JsonProperty(value = "workspaceKey", required = true)
    private String workspaceKey;

    /*
     * The log type to be used.
     */
    @JsonProperty(value = "logType")
    private LogAnalyticsLogType logType;

    /*
     * Metadata for log analytics.
     */
    @JsonProperty(value = "metadata")
    private Map<String, String> metadata;

    /*
     * The workspace resource id for log analytics
     */
    @JsonProperty(value = "workspaceResourceId")
    private Map<String, String> workspaceResourceId;

    /**
     * Get the workspaceId property: The workspace id for log analytics.
     *
     * @return the workspaceId value.
     */
    public String workspaceId() {
        return this.workspaceId;
    }

    /**
     * Set the workspaceId property: The workspace id for log analytics.
     *
     * @param workspaceId the workspaceId value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    /**
     * Get the workspaceKey property: The workspace key for log analytics.
     *
     * @return the workspaceKey value.
     */
    public String workspaceKey() {
        return this.workspaceKey;
    }

    /**
     * Set the workspaceKey property: The workspace key for log analytics.
     *
     * @param workspaceKey the workspaceKey value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withWorkspaceKey(String workspaceKey) {
        this.workspaceKey = workspaceKey;
        return this;
    }

    /**
     * Get the logType property: The log type to be used.
     *
     * @return the logType value.
     */
    public LogAnalyticsLogType logType() {
        return this.logType;
    }

    /**
     * Set the logType property: The log type to be used.
     *
     * @param logType the logType value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withLogType(LogAnalyticsLogType logType) {
        this.logType = logType;
        return this;
    }

    /**
     * Get the metadata property: Metadata for log analytics.
     *
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata for log analytics.
     *
     * @param metadata the metadata value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the workspaceResourceId property: The workspace resource id for log analytics.
     *
     * @return the workspaceResourceId value.
     */
    public Map<String, String> workspaceResourceId() {
        return this.workspaceResourceId;
    }

    /**
     * Set the workspaceResourceId property: The workspace resource id for log analytics.
     *
     * @param workspaceResourceId the workspaceResourceId value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withWorkspaceResourceId(Map<String, String> workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (workspaceId() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property workspaceId in model LogAnalytics"));
        }
        if (workspaceKey() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property workspaceKey in model LogAnalytics"));
        }
    }
}
