/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ReflectionUtilsApi;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ReflectionUtils
implements ReflectionUtilsApi {
    private static final MethodHandle PRIVATE_LOOKUP_IN;

    @Override
    public MethodHandles.Lookup getLookupToUse(Class<?> targetClass) throws Exception {
        try {
            return PRIVATE_LOOKUP_IN.invoke(targetClass);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
    }

    @Override
    public int getJavaImplementationMajorVersion() {
        return 8;
    }

    ReflectionUtils() {
    }

    static {
        try {
            Constructor privateLookupInConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            if (!privateLookupInConstructor.isAccessible()) {
                privateLookupInConstructor.setAccessible(true);
            }
            PRIVATE_LOOKUP_IN = MethodHandles.lookup().unreflectConstructor(privateLookupInConstructor);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Unable to use private lookup in constructor.", ex);
        }
    }
}

