/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.DigestListBuilder;
import com.authlete.sd.Disclosure;
import com.authlete.sd.SDUtility;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SDObjectBuilder {
    private final String hashAlgorithm;
    private final Map<String, Object> claims;
    private final DigestListBuilder digestListBuilder;

    public SDObjectBuilder() {
        this("sha-256");
    }

    public SDObjectBuilder(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm != null ? hashAlgorithm : "sha-256";
        this.claims = new LinkedHashMap<String, Object>();
        this.digestListBuilder = new DigestListBuilder(this.hashAlgorithm);
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void putClaim(String claimName, Object claimValue) {
        if (claimName == null) {
            throw new IllegalArgumentException("'claimName' is missing.");
        }
        if (SDUtility.isReservedKey(claimName)) {
            throw new IllegalArgumentException(String.format("The claim name ('%s') is a reserved key.", claimName));
        }
        this.digestListBuilder.removeDigestByClaimName(claimName);
        this.claims.put(claimName, claimValue);
    }

    public Disclosure putSDClaim(Disclosure disclosure) {
        if (disclosure == null) {
            throw new IllegalArgumentException("'disclosure' is missing.");
        }
        if (disclosure.getClaimName() == null) {
            throw new IllegalArgumentException("The disclosure is not for an object property.");
        }
        this.digestListBuilder.addDisclosureDigest(disclosure);
        this.claims.remove(disclosure.getClaimName());
        return disclosure;
    }

    public Disclosure putSDClaim(String claimName, Object claimValue) {
        return this.putSDClaim(new Disclosure(claimName, claimValue));
    }

    public Disclosure putSDClaim(String salt, String claimName, Object claimValue) {
        return this.putSDClaim(new Disclosure(salt, claimName, claimValue));
    }

    public String putDecoyDigest() {
        return this.digestListBuilder.addDecoyDigest();
    }

    public List<String> putDecoyDigests(int count) {
        return this.digestListBuilder.addDecoyDigests(count);
    }

    public Map<String, Object> build() {
        return this.build(false);
    }

    public Map<String, Object> build(boolean hashAlgorithmIncluded) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.putAll(this.claims);
        List<String> digestList = this.digestListBuilder.build();
        if (digestList.size() != 0) {
            output.put("_sd", digestList);
        }
        if (hashAlgorithmIncluded) {
            output.put("_sd_alg", this.getHashAlgorithm());
        }
        return output;
    }
}

