/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.core.MergedNdkConfig;
import com.android.build.gradle.internal.core.NdkConfig;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.GroupableProductFlavor;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import java.util.List;
import java.util.Set;

public class GradleVariantConfiguration
extends VariantConfiguration<BuildType, com.android.build.gradle.internal.dsl.ProductFlavor, GroupableProductFlavor> {
    private final MergedNdkConfig mMergedNdkConfig = new MergedNdkConfig();

    public GradleVariantConfiguration(@NonNull com.android.build.gradle.internal.dsl.ProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildType buildType, @Nullable SourceProvider buildTypeSourceProvider, @Nullable SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (com.android.builder.model.BuildType)buildType, buildTypeSourceProvider, signingConfigOverride);
        this.computeNdkConfig();
    }

    public GradleVariantConfiguration(@NonNull com.android.build.gradle.internal.dsl.ProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildType buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull VariantConfiguration.Type type, @Nullable SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (com.android.builder.model.BuildType)buildType, buildTypeSourceProvider, type, signingConfigOverride);
        this.computeNdkConfig();
    }

    public GradleVariantConfiguration(@NonNull com.android.build.gradle.internal.dsl.ProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildType buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull VariantConfiguration.Type type, @Nullable VariantConfiguration testedConfig, @Nullable SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (com.android.builder.model.BuildType)buildType, buildTypeSourceProvider, type, testedConfig, signingConfigOverride);
        this.computeNdkConfig();
    }

    @NonNull
    public VariantConfiguration addProductFlavor(@NonNull GroupableProductFlavor productFlavor, @NonNull SourceProvider sourceProvider, @NonNull String dimensionName) {
        super.addProductFlavor((ProductFlavor)productFlavor, sourceProvider, dimensionName);
        this.computeNdkConfig();
        return this;
    }

    @NonNull
    public NdkConfig getNdkConfig() {
        return this.mMergedNdkConfig;
    }

    @Nullable
    public Set<String> getSupportedAbis() {
        return this.mMergedNdkConfig.getAbiFilters();
    }

    public boolean isMinifyEnabled() {
        VariantConfiguration.Type type = this.getType();
        return ((BuildType)this.getBuildType()).isMinifyEnabled() && (type != VariantConfiguration.Type.TEST || this.getTestedConfig().getType() != VariantConfiguration.Type.LIBRARY);
    }

    public boolean getUseJack() {
        Boolean value = ((BuildType)this.getBuildType()).getUseJack();
        if (value != null) {
            return value;
        }
        for (GroupableProductFlavor productFlavor : this.getProductFlavors()) {
            value = productFlavor.getUseJack();
            if (value == null) continue;
            return value;
        }
        value = ((com.android.build.gradle.internal.dsl.ProductFlavor)this.getDefaultConfig()).getUseJack();
        if (value != null) {
            return value;
        }
        return false;
    }

    private void computeNdkConfig() {
        this.mMergedNdkConfig.reset();
        if (((com.android.build.gradle.internal.dsl.ProductFlavor)this.getDefaultConfig()).getNdkConfig() != null) {
            this.mMergedNdkConfig.append(((com.android.build.gradle.internal.dsl.ProductFlavor)this.getDefaultConfig()).getNdkConfig());
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            NdkConfig ndkConfig = ((GroupableProductFlavor)flavors.get(i)).getNdkConfig();
            if (ndkConfig == null) continue;
            this.mMergedNdkConfig.append(ndkConfig);
        }
        if (((BuildType)this.getBuildType()).getNdkConfig() != null && this.getType() != VariantConfiguration.Type.TEST) {
            this.mMergedNdkConfig.append(((BuildType)this.getBuildType()).getNdkConfig());
        }
    }
}

