/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;

public class ApkOutputFile
implements OutputFile,
Serializable {
    @NonNull
    private final Collection<FilterData> filters;
    @NonNull
    private final Collection<String> filterTypes;
    @NonNull
    private final OutputFile.OutputType outputType;
    @NonNull
    private final Callable<File> outputFile;

    public ApkOutputFile(@NonNull OutputFile.OutputType outputType, @NonNull Collection<FilterData> filters, @NonNull Callable<File> outputFile) {
        this.outputType = outputType;
        this.outputFile = outputFile;
        this.filters = filters;
        ImmutableList.Builder filterTypes = ImmutableList.builder();
        for (FilterData filter : filters) {
            filterTypes.add((Object)filter.getFilterType());
        }
        this.filterTypes = filterTypes.build();
    }

    @NonNull
    public OutputFile.OutputType getType() {
        return this.outputType;
    }

    @NonNull
    public File getOutputFile() {
        try {
            return this.outputFile.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public String getSplitIdentifiers(char separatorChar) {
        return Joiner.on((char)separatorChar).join(Iterables.transform(this.filters, (Function)new Function<FilterData, Object>(){

            public Object apply(FilterData filterData) {
                return filterData.getIdentifier();
            }
        }));
    }

    @NonNull
    public Collection<FilterData> getFilters() {
        return this.filters;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("OutputType", (Object)this.outputType).add("Filters", (Object)Joiner.on((char)',').join(this.filters, (Object)new Function<FilterData, String>(){

            public String apply(FilterData splitData) {
                return '[' + splitData.getFilterType() + ':' + splitData.getIdentifier() + ']';
            }
        }, new Object[0])).add("File", (Object)this.getOutputFile().getAbsolutePath()).toString();
    }

    @NonNull
    public String getOutputType() {
        return this.outputType.name();
    }

    @NonNull
    public Collection<String> getFilterTypes() {
        return this.filterTypes;
    }

    @Nullable
    public String getFilterByType(OutputFile.FilterType filterType) {
        for (FilterData filter : this.filters) {
            if (!filter.getFilterType().equals(filterType.name())) continue;
            return filter.getIdentifier();
        }
        return null;
    }

    @Nullable
    public String getFilter(String filterType) {
        return this.getFilterByType(OutputFile.FilterType.valueOf((String)filterType));
    }
}

