/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListGeoLocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListGeoLocationsRequestMarshaller
implements Marshaller<Request<ListGeoLocationsRequest>, ListGeoLocationsRequest> {
    public Request<ListGeoLocationsRequest> marshall(ListGeoLocationsRequest listGeoLocationsRequest) {
        if (listGeoLocationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listGeoLocationsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocations";
        request.setResourcePath(uriResourcePath);
        if (listGeoLocationsRequest.getStartContinentCode() != null) {
            request.addParameter("startcontinentcode", StringUtils.fromString((String)listGeoLocationsRequest.getStartContinentCode()));
        }
        if (listGeoLocationsRequest.getStartCountryCode() != null) {
            request.addParameter("startcountrycode", StringUtils.fromString((String)listGeoLocationsRequest.getStartCountryCode()));
        }
        if (listGeoLocationsRequest.getStartSubdivisionCode() != null) {
            request.addParameter("startsubdivisioncode", StringUtils.fromString((String)listGeoLocationsRequest.getStartSubdivisionCode()));
        }
        if (listGeoLocationsRequest.getMaxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listGeoLocationsRequest.getMaxItems()));
        }
        return request;
    }
}

