/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.S3DataSpec;

public class S3DataSpecJsonMarshaller {
    private static S3DataSpecJsonMarshaller instance;

    public void marshall(S3DataSpec s3DataSpec, StructuredJsonGenerator jsonGenerator) {
        if (s3DataSpec == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3DataSpec.getDataLocationS3() != null) {
                jsonGenerator.writeFieldName("DataLocationS3").writeValue(s3DataSpec.getDataLocationS3());
            }
            if (s3DataSpec.getDataRearrangement() != null) {
                jsonGenerator.writeFieldName("DataRearrangement").writeValue(s3DataSpec.getDataRearrangement());
            }
            if (s3DataSpec.getDataSchema() != null) {
                jsonGenerator.writeFieldName("DataSchema").writeValue(s3DataSpec.getDataSchema());
            }
            if (s3DataSpec.getDataSchemaLocationS3() != null) {
                jsonGenerator.writeFieldName("DataSchemaLocationS3").writeValue(s3DataSpec.getDataSchemaLocationS3());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DataSpecJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DataSpecJsonMarshaller();
        }
        return instance;
    }
}

