/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.FunctionCode;

public class FunctionCodeJsonMarshaller {
    private static FunctionCodeJsonMarshaller instance;

    public void marshall(FunctionCode functionCode, StructuredJsonGenerator jsonGenerator) {
        if (functionCode == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (functionCode.getZipFile() != null) {
                jsonGenerator.writeFieldName("ZipFile").writeValue(functionCode.getZipFile());
            }
            if (functionCode.getS3Bucket() != null) {
                jsonGenerator.writeFieldName("S3Bucket").writeValue(functionCode.getS3Bucket());
            }
            if (functionCode.getS3Key() != null) {
                jsonGenerator.writeFieldName("S3Key").writeValue(functionCode.getS3Key());
            }
            if (functionCode.getS3ObjectVersion() != null) {
                jsonGenerator.writeFieldName("S3ObjectVersion").writeValue(functionCode.getS3ObjectVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FunctionCodeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionCodeJsonMarshaller();
        }
        return instance;
    }
}

