/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UnassignPrivateIpAddressesRequestMarshaller
implements Marshaller<Request<UnassignPrivateIpAddressesRequest>, UnassignPrivateIpAddressesRequest> {
    public Request<UnassignPrivateIpAddressesRequest> marshall(UnassignPrivateIpAddressesRequest unassignPrivateIpAddressesRequest) {
        SdkInternalList privateIpAddressesList;
        if (unassignPrivateIpAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)unassignPrivateIpAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "UnassignPrivateIpAddresses");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (unassignPrivateIpAddressesRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)unassignPrivateIpAddressesRequest.getNetworkInterfaceId()));
        }
        if (!(privateIpAddressesList = (SdkInternalList)unassignPrivateIpAddressesRequest.getPrivateIpAddresses()).isEmpty() || !privateIpAddressesList.isAutoConstruct()) {
            int privateIpAddressesListIndex = 1;
            for (String privateIpAddressesListValue : privateIpAddressesList) {
                if (privateIpAddressesListValue != null) {
                    request.addParameter("PrivateIpAddress." + privateIpAddressesListIndex, StringUtils.fromString((String)privateIpAddressesListValue));
                }
                ++privateIpAddressesListIndex;
            }
        }
        return request;
    }
}

