/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.Query;
import com.amazonaws.services.datapipeline.model.Selector;
import com.amazonaws.services.datapipeline.model.transform.SelectorJsonMarshaller;

public class QueryJsonMarshaller {
    private static QueryJsonMarshaller instance;

    public void marshall(Query query, StructuredJsonGenerator jsonGenerator) {
        if (query == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList selectorsList = (SdkInternalList)query.getSelectors();
            if (!selectorsList.isEmpty() || !selectorsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("selectors");
                jsonGenerator.writeStartArray();
                for (Selector selectorsListValue : selectorsList) {
                    if (selectorsListValue == null) continue;
                    SelectorJsonMarshaller.getInstance().marshall(selectorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static QueryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new QueryJsonMarshaller();
        }
        return instance;
    }
}

