/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateDefaultBranchRequestMarshaller
implements Marshaller<Request<UpdateDefaultBranchRequest>, UpdateDefaultBranchRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateDefaultBranchRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateDefaultBranchRequest> marshall(UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        if (updateDefaultBranchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDefaultBranchRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.UpdateDefaultBranch");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateDefaultBranchRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(updateDefaultBranchRequest.getRepositoryName());
            }
            if (updateDefaultBranchRequest.getDefaultBranchName() != null) {
                jsonGenerator.writeFieldName("defaultBranchName").writeValue(updateDefaultBranchRequest.getDefaultBranchName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

