/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.request;

import com.alibaba.nacos.common.http.BaseHttpMethod;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.request.HttpClientRequest;
import com.alibaba.nacos.common.http.client.response.DefaultClientHttpResponse;
import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import com.alibaba.nacos.common.utils.IoUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.util.Timeout;

public class DefaultHttpClientRequest
implements HttpClientRequest {
    private final CloseableHttpClient client;
    private final RequestConfig defaultConfig;

    public DefaultHttpClientRequest(CloseableHttpClient client, RequestConfig defaultConfig) {
        this.client = client;
        this.defaultConfig = defaultConfig;
    }

    @Override
    public HttpClientResponse execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity) throws Exception {
        HttpUriRequestBase request = DefaultHttpClientRequest.build(uri, httpMethod, requestHttpEntity, this.defaultConfig);
        SimpleHttpResponse response = (SimpleHttpResponse)this.client.execute((ClassicHttpRequest)request, httpResponse -> {
            SimpleHttpResponse simpleHttpResponse = SimpleHttpResponse.copy((HttpResponse)httpResponse);
            ContentType contentType = ContentType.parse((CharSequence)httpResponse.getEntity().getContentType());
            String body = IoUtils.toString(httpResponse.getEntity().getContent(), null);
            simpleHttpResponse.setBody(body, contentType);
            return simpleHttpResponse;
        });
        return new DefaultClientHttpResponse(response);
    }

    static HttpUriRequestBase build(URI uri, String method, RequestHttpEntity requestHttpEntity, RequestConfig defaultConfig) throws Exception {
        Header headers = requestHttpEntity.getHeaders();
        BaseHttpMethod httpMethod = BaseHttpMethod.sourceOf(method);
        HttpUriRequestBase httpRequestBase = httpMethod.init(uri.toString());
        HttpUtils.initRequestHeader((ClassicHttpRequest)httpRequestBase, headers);
        if ("application/x-www-form-urlencoded;charset=UTF-8".equals(headers.getValue("Content-Type")) && requestHttpEntity.getBody() instanceof Map) {
            HttpUtils.initRequestFromEntity((ClassicHttpRequest)httpRequestBase, (Map)requestHttpEntity.getBody(), headers.getCharset());
        } else {
            HttpUtils.initRequestEntity((ClassicHttpRequest)httpRequestBase, requestHttpEntity.getBody(), headers);
        }
        DefaultHttpClientRequest.mergeDefaultConfig(httpRequestBase, requestHttpEntity.getHttpClientConfig(), defaultConfig);
        return httpRequestBase;
    }

    private static void mergeDefaultConfig(HttpUriRequestBase requestBase, HttpClientConfig httpClientConfig, RequestConfig defaultConfig) {
        if (httpClientConfig == null) {
            return;
        }
        requestBase.setConfig(RequestConfig.copy((RequestConfig)defaultConfig).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)httpClientConfig.getConTimeOutMillis())).setResponseTimeout(Timeout.ofMilliseconds((long)httpClientConfig.getReadTimeOutMillis())).build());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

