/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import com.alibaba.hbase.haclient.dualservice.DualScannerResult;
import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;

public class AliHBaseResultScanner
extends AbstractClientScanner {
    private HTable activeTable;
    private HTable standbyTable;
    private ResultScanner activeScanner = null;
    private ResultScanner standbyScanner = null;
    private volatile ResultScanner currentScanner = null;
    private DualExecutor dualExecutor;
    private Scan activeScan;
    private Scan standbyScan;
    private int glitchTimeout;
    private int scannerTimeout;

    public AliHBaseResultScanner(HTable activeTable, HTable standbyTable, DualExecutor dualExecutor, Scan scan, int glitchTimeout, int scannerTimeout) throws IOException {
        this.activeTable = activeTable;
        this.standbyTable = standbyTable;
        this.dualExecutor = dualExecutor;
        this.activeScan = new Scan(scan);
        this.standbyScan = new Scan(scan);
        this.activeScanner = this.activeTable.getScanner(this.activeScan);
        this.standbyScanner = this.standbyTable.getScanner(this.standbyScan);
        this.glitchTimeout = glitchTimeout;
        this.scannerTimeout = scannerTimeout;
    }

    public Result next() throws IOException {
        if (this.currentScanner == null) {
            DualScannerResult dualScannerResult = this.dualExecutor.dualNext(this.activeScanner, this.standbyScanner, this.activeTable.getName().getName(), this.glitchTimeout, this.scannerTimeout);
            this.currentScanner = dualScannerResult.getScanner();
            return dualScannerResult.getResult();
        }
        return this.currentScanner.next();
    }

    public void close() {
        if (this.activeScanner != null) {
            this.activeScanner.close();
        }
        if (this.standbyScanner != null) {
            this.standbyScanner.close();
        }
    }

    public boolean renewLease() {
        return false;
    }
}

