/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.SilenceIndex;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DescriptorAttributes;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LindormTableDescriptor
extends DescriptorAttributes
implements Comparable<LindormTableDescriptor> {
    private String name;
    private Map<byte[], ColumnFamilyDescriptor> families = new TreeMap<byte[], ColumnFamilyDescriptor>(Bytes.BYTES_COMPARATOR);
    private List<PrimaryKeySchema> pkColumns;
    private List<ColumnSchema> nonPkColumns;
    private List<LindormIndexDescriptor> indexes = Collections.emptyList();
    private List<String> indexNames = Collections.emptyList();
    private Map<Byte, String> indexIds = Collections.emptyMap();
    private Map<String, SilenceIndex> silenceIndexs = Collections.emptyMap();
    protected int metaVersion;
    private String searchIndexConfig;

    public LindormTableDescriptor() {
        this.init();
    }

    private void init() {
        this.tableAttributes.setAllowFiltering(false);
    }

    public LindormTableDescriptor(String name) {
        this.name = name;
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPkColumns(List<PrimaryKeySchema> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public void addPkColumn(PrimaryKeySchema onePk) {
        if (this.pkColumns == null) {
            this.pkColumns = CollectionUtils.newArrayList();
        }
        this.pkColumns.add(onePk);
    }

    public List<PrimaryKeySchema> getPkColumns() {
        return this.pkColumns;
    }

    public void setNonPkColumns(List<ColumnSchema> nonPkColumns) {
        this.nonPkColumns = nonPkColumns;
    }

    public void addNonPkcolumn(ColumnSchema nonPk) {
        if (this.nonPkColumns == null) {
            this.nonPkColumns = CollectionUtils.newArrayList();
        }
        this.nonPkColumns.add(nonPk);
    }

    public List<ColumnSchema> getNonPkColumns() {
        return this.nonPkColumns;
    }

    public void addFamily(ColumnFamilyDescriptor family) {
        this.families.put(family.getName(), family);
    }

    public boolean removeFamily(byte[] familyName) {
        ColumnFamilyDescriptor f = this.families.remove(familyName);
        return f != null;
    }

    public boolean removeFamily(String familyName) {
        return this.removeFamily(Bytes.toBytes(familyName));
    }

    public boolean hasFamily(byte[] familyName) {
        return this.families.containsKey(familyName);
    }

    public boolean hasFamily(String familyName) {
        return this.hasFamily(Bytes.toBytes(familyName));
    }

    public void setFamilies(List<ColumnFamilyDescriptor> families) {
        this.families.clear();
        for (ColumnFamilyDescriptor f : families) {
            this.families.put(f.getName(), f);
        }
    }

    public List<ColumnFamilyDescriptor> getFamilies() {
        ArrayList<ColumnFamilyDescriptor> ret = new ArrayList<ColumnFamilyDescriptor>(this.families.size());
        ret.addAll(this.families.values());
        return ret;
    }

    public ColumnFamilyDescriptor getFamily(byte[] familyName) {
        return this.families.get(familyName);
    }

    public ColumnFamilyDescriptor getFamily(String familyName) {
        return this.getFamily(Bytes.toBytes(familyName));
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(int metaVersion) {
        this.metaVersion = metaVersion;
    }

    public List<LindormIndexDescriptor> getIndexes() {
        return this.indexes;
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    public Map<Byte, String> getIndexIds() {
        return this.indexIds;
    }

    public Map<String, SilenceIndex> getSilenceIndexs() {
        return this.silenceIndexs;
    }

    public String getIndexDescription() {
        StringBuilder str = new StringBuilder();
        str.append(" Indexes: {");
        if (!this.indexes.isEmpty()) {
            for (LindormIndexDescriptor lid : this.indexes) {
                str.append("[");
                str.append(lid.toString());
                str.append("],");
            }
            str.setLength(str.length() - 1);
        }
        str.append("}");
        return str.toString();
    }

    private String printSearchIndexInfo() {
        StringBuilder str = new StringBuilder();
        str.append(" Search Indexes: {");
        if (null != this.searchIndexConfig) {
            str.append("[");
            str.append(this.searchIndexConfig);
            str.append("]");
        }
        str.append("}");
        return str.toString();
    }

    public String getSchema() {
        StringBuilder str = new StringBuilder();
        str.append("Table [");
        str.append(this.name);
        str.append("], MetaVerion: ");
        str.append(this.metaVersion);
        str.append(", Consistency [");
        str.append((Object)this.getConsistencyType());
        str.append("] , families:[");
        if (this.families.isEmpty()) {
            str.append("SYS");
            str.append(",");
        } else {
            for (ColumnFamilyDescriptor f : this.families.values()) {
                str.append(f.toString());
                str.append(",");
            }
        }
        str.setLength(str.length() - 1);
        str.append("], PK:");
        str.append(this.pkColumns.size());
        str.append("[");
        for (PrimaryKeySchema pks : this.pkColumns) {
            str.append(pks.toString());
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("], nonPK:");
        str.append(this.nonPkColumns.size());
        str.append("[");
        for (ColumnSchema cs : this.nonPkColumns) {
            str.append(cs.toString());
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("]");
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getSchema());
        str.append(",");
        str.append(this.printSearchIndexInfo());
        str.append(",");
        str.append(this.getIndexDescription());
        str.append(", TABLE_ATTR: ");
        str.append(this.tableAttributes.toString());
        str.append(", FAMILY_ATTR: ");
        str.append(this.familyAttributes.toString());
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof LindormTableDescriptor)) {
            return false;
        }
        LindormTableDescriptor other = (LindormTableDescriptor)obj;
        if (!this.pkColumns.equals(other.pkColumns)) {
            return false;
        }
        if (!this.nonPkColumns.equals(other.nonPkColumns)) {
            return false;
        }
        return this.compareTo((LindormTableDescriptor)obj) == 0;
    }

    @Override
    public int compareTo(LindormTableDescriptor other) {
        int result = 0;
        result = this.name == null ? (other.name == null ? 0 : -1) : this.name.compareTo(other.name);
        if (result == 0) {
            result = this.metaVersion - other.metaVersion;
        }
        return result;
    }

    public void setIndexes(List<LindormIndexDescriptor> indexes) {
        this.indexes = indexes;
    }

    public void setIndexNames(List<String> indexNames) {
        this.indexNames = indexNames;
    }

    public void setIndexIds(Map<Byte, String> indexIds) {
        this.indexIds = indexIds;
    }

    public void setSilenceIndex(Map<String, SilenceIndex> silenceIndexs) {
        this.silenceIndexs = silenceIndexs;
    }

    public void setSearchIndexConfig(String searchIndexConfig) {
        this.searchIndexConfig = searchIndexConfig;
    }

    public final String getSearchIndexConfig() {
        return this.searchIndexConfig;
    }

    @Override
    public void setFamilyAttributes(byte[] familyName, String name, String value) throws IllegalRequestException {
        ColumnFamilyDescriptor desc = this.getFamily(familyName);
        if (desc == null) {
            throw new IllegalRequestException("Unknown family name " + Bytes.toStringBinary(familyName));
        }
        desc.getFamilyAttributes().setAttribute(name, value);
    }
}

