/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

public class ConflictResolverSchema {
    public static final String DELIMETER = "\\|";
    ConflictResolverType type;
    boolean endian;

    public ConflictResolverSchema(ConflictResolverType type, boolean endian) {
        this.type = type;
        this.endian = endian;
    }

    public ConflictResolverSchema(ConflictResolverType type) {
        this.type = type;
        this.endian = true;
    }

    public ConflictResolverSchema() {
        this.type = ConflictResolverType.DEFAULT;
        this.endian = true;
    }

    public ConflictResolverType getType() {
        return this.type;
    }

    public boolean isBigEndian() {
        return this.endian;
    }

    public void setType(ConflictResolverType type) {
        this.type = type;
    }

    public void setEndian(boolean endian) {
        this.endian = endian;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE=");
        sb.append((Object)this.type);
        sb.append("|BIGENDIAN=");
        sb.append(this.endian);
        return sb.toString();
    }

    public static ConflictResolverSchema fromString(String schema) {
        String[] parts = schema.split(DELIMETER);
        if (parts.length < 1 || parts.length > 2) {
            throw new IllegalArgumentException("Invalid conflict resolver " + schema + ", Example" + "TYPE=DEFAULT " + "TYPE=VALUE_CMP|BIGENDIAN=true " + "TYPE=TAG_CMP|BIGENDIAN=false");
        }
        ConflictResolverSchema resolver = new ConflictResolverSchema();
        for (String part : parts) {
            String[] configParts = part.split("=");
            if (configParts.length != 2) {
                throw new IllegalArgumentException("Invalid conflict resolver " + schema + ", Example" + "TYPE=DEFAULT " + "TYPE=VALUE_CMP|BIGENDIAN=true " + "TYPE=TAG_CMP|BIGENDIAN=false");
            }
            if (configParts[0].equals("TYPE")) {
                resolver.setType(ConflictResolverType.valueOf(configParts[1].trim()));
            }
            if (!configParts[0].equals("BIGENDIAN")) continue;
            resolver.setEndian(Boolean.valueOf(configParts[1]));
        }
        return resolver;
    }

    public static enum ConflictResolverType {
        DEFAULT,
        VALUE_CMP,
        TAG_CMP;

    }
}

