/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OrderedColumnKey
extends ColumnKey {
    private SortOrder sortOrder;
    private ColumnKey cachedColumnKey;

    public OrderedColumnKey() {
    }

    public OrderedColumnKey(byte[] qualifier) {
        this(qualifier, SortOrder.getDefault());
    }

    public OrderedColumnKey(byte[] qualifier, SortOrder sortOrder) {
        super(qualifier);
        this.sortOrder = sortOrder;
    }

    public OrderedColumnKey(String qualifier) {
        this(qualifier, SortOrder.getDefault());
    }

    public OrderedColumnKey(String qualifier, SortOrder sortOrder) {
        super(qualifier);
        this.sortOrder = sortOrder;
    }

    public OrderedColumnKey(String family, String qualifier) {
        this(family, qualifier, SortOrder.getDefault());
    }

    public OrderedColumnKey(String family, String qualifier, SortOrder sortOrder) {
        super(family, qualifier);
        this.sortOrder = sortOrder;
    }

    public OrderedColumnKey(byte[] family, byte[] qualifier) {
        this(family, qualifier, SortOrder.getDefault());
    }

    public OrderedColumnKey(byte[] family, byte[] qualifier, SortOrder sortOrder) {
        super(family, qualifier);
        this.sortOrder = sortOrder;
    }

    public OrderedColumnKey(ColumnKey columnKey, SortOrder sortOrder) {
        super(columnKey);
        this.sortOrder = sortOrder;
    }

    public OrderedColumnKey(OrderedColumnKey other) {
        super(other);
        this.sortOrder = other.sortOrder;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.sortOrder.ordinal());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.sortOrder = SortOrder.values()[WritableUtils.readVInt(in)];
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode() * 31 + this.sortOrder.ordinal();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderedColumnKey)) {
            return false;
        }
        OrderedColumnKey other = (OrderedColumnKey)obj;
        return super.equals(other) && this.sortOrder.equals((Object)other.sortOrder);
    }

    @Override
    public String toString() {
        return super.toString() + " " + (Object)((Object)this.sortOrder);
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public ColumnKey getColumnKey() {
        if (this.cachedColumnKey == null) {
            this.cachedColumnKey = new ColumnKey(this.family, this.qualifier);
        }
        return this.cachedColumnKey;
    }
}

