/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LList;
import com.alibaba.lindorm.client.core.types.LMap;
import com.alibaba.lindorm.client.core.types.LSet;
import com.alibaba.lindorm.client.core.types.LUUID;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.CollectionOperation;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.LTag;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ColumnValue
extends VersionedObjectWithAttributes
implements Cloneable,
Comparable<ColumnValue> {
    private static final String COLLECTION_DATA_TYPE_ATTR = "C_TYPE";
    private static final String COLLECTION_OPERATION_ATTR = "C_OPERATION";
    private static LDataTypeFactory TYPE_FACTORY = LDataTypeFactory.INSTANCE;
    private ColumnKey columnKey;
    private DataType type;
    private LCollectionType lCollectionType;
    private CollectionOperation operation;
    private Object value;
    private long ts = Long.MAX_VALUE;
    private boolean isNotNull;
    protected List<LTag> tags = null;

    public ColumnValue() {
    }

    public ColumnValue(byte[] name, Object value) throws LindormException {
        this(null, name, Long.MAX_VALUE, value);
    }

    public ColumnValue(String name, Object value) throws LindormException {
        this(null, Bytes.toBytes(name), Long.MAX_VALUE, value);
    }

    public ColumnValue(String name, Object value, CollectionDataType collectionDataType, CollectionOperation operation) throws LindormException {
        this(null, Bytes.toBytes(name), Long.MAX_VALUE, value, collectionDataType.getDataTypeEnum(), collectionDataType, operation);
    }

    public ColumnValue(byte[] name, long ts, Object value) throws LindormException {
        this(null, name, ts, value);
    }

    public ColumnValue(String name, long ts, Object value) throws LindormException {
        this(null, Bytes.toBytes(name), ts, value);
    }

    public ColumnValue(String name, long ts, Object value, CollectionDataType collectionDataType, CollectionOperation operation) throws LindormException {
        this(null, Bytes.toBytes(name), ts, value, collectionDataType.getDataTypeEnum(), collectionDataType, operation);
    }

    public ColumnValue(byte[] familyName, byte[] columnName, Object value) throws LindormException {
        this(familyName, columnName, Long.MAX_VALUE, value);
    }

    public ColumnValue(String familyName, String columnName, Object value) throws LindormException {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), Long.MAX_VALUE, value);
    }

    public ColumnValue(String familyName, String columnName, long ts, Object value) throws LindormException {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), ts, value);
    }

    public ColumnValue(byte[] familyName, byte[] columnName, long ts, Object value) throws LindormException {
        this(familyName, columnName, ts, value, value == null ? DataType.VARBINARY : TYPE_FACTORY.getTypeByClass(value.getClass()).getClientType(), null, null);
    }

    public ColumnValue(byte[] familyName, byte[] columnName, long ts, Object value, DataType dataType, CollectionDataType collectionDataType, CollectionOperation operation) throws LindormException {
        SchemaUtils.validateTimestamp(ts);
        this.columnKey = new ColumnKey(familyName, columnName);
        this.ts = ts;
        this.type = dataType;
        this.operation = operation;
        if (collectionDataType != null) {
            this.lCollectionType = (LCollectionType)LDataTypeFactory.INSTANCE.getTypeInstance(collectionDataType);
        }
        if (value == null) {
            this.value = null;
            this.isNotNull = false;
        } else {
            this.value = value;
            this.isNotNull = true;
            this.validateValue();
        }
    }

    public ColumnValue(byte[] familyName, byte[] columnName, Object value, DataType type, long ts) throws LindormException {
        this(new ColumnKey(familyName, columnName), value, type, ts);
    }

    public ColumnValue(ColumnKey columnKey, Object value, DataType type, long ts) throws IllegalDataException {
        this(columnKey, value, type, ts, null, null);
    }

    public ColumnValue(ColumnKey columnKey, Object value, DataType type, long ts, LCollectionType collectionType, CollectionOperation operation) throws IllegalDataException {
        SchemaUtils.validateTimestamp(ts);
        this.columnKey = columnKey;
        this.ts = ts;
        this.setValue(value, type);
        this.lCollectionType = collectionType;
        this.operation = operation;
    }

    public void setFamilyName(byte[] familyName) {
        this.columnKey.setFamily(familyName);
    }

    public byte[] getFamilyName() {
        return this.columnKey.getFamily();
    }

    public String getFamilyNameAsString() {
        return this.columnKey.getFamilyAsString();
    }

    public void setColumnName(byte[] columnName) {
        this.columnKey.setQualifier(columnName);
    }

    public byte[] getColumnName() {
        return this.columnKey.getQualifier();
    }

    public String getColumnNameAsString() {
        return this.columnKey.getQualifierAsString();
    }

    public byte[] getFullName() {
        return this.columnKey.getFullName();
    }

    public String getFullNameAsString() {
        return this.columnKey.getFullNameAsString();
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(ColumnKey columnKey) {
        this.columnKey = columnKey;
    }

    public void setTimestamp(long ts) {
        this.ts = ts;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public void setTags(List<LTag> tags) {
        if (tags != null) {
            this.tags = new ArrayList<LTag>(tags);
        }
    }

    public List<LTag> getTags() {
        return this.tags;
    }

    public LCollectionType getlCollectionType() {
        return this.lCollectionType;
    }

    public CollectionOperation getOperation() {
        return this.operation;
    }

    public Object getValueObject() {
        return this.value;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public int getEstimatedSize() {
        int length = this.columnKey.getByteSize() + 1 + 8;
        if (this.isNotNull) {
            length = this.type.isCollection() ? (length += this.lCollectionType.getByteSize(this.value)) : (length += LDataTypeFactory.INSTANCE.getTypeInstance(this.type).getByteSize(this.value));
        }
        return length += this.getAttrEstimatedSize();
    }

    public Byte asByte() {
        this.validateDataType(DataType.BYTE);
        return this.isNotNull ? Byte.valueOf(((Number)this.value).byteValue()) : null;
    }

    @Deprecated
    public Byte getByte() {
        return this.asByte();
    }

    public Boolean asBoolean() {
        this.validateDataType(DataType.BOOLEAN);
        return (Boolean)this.value;
    }

    @Deprecated
    public Boolean getBoolean() {
        return this.asBoolean();
    }

    public Short asShort() {
        this.validateDataType(DataType.SHORT);
        return this.isNotNull ? Short.valueOf(((Number)this.value).shortValue()) : null;
    }

    @Deprecated
    public Short getShort() {
        return this.asShort();
    }

    public Integer asInt() {
        this.validateDataType(DataType.INT);
        return this.isNotNull ? Integer.valueOf(((Number)this.value).intValue()) : null;
    }

    public UUID asUUID() {
        this.validateDataType(DataType.UUID);
        return this.isNotNull ? (UUID)this.value : null;
    }

    public List asList() {
        if (this.type != DataType.LIST || this.operation != CollectionOperation.LIST_VALUE) {
            throw new IllegalStateException("The type of column [" + Bytes.toString(this.getFullName()) + "] is " + this.type.toString() + ", operation: " + (Object)((Object)this.operation) + ", cannot be converted to " + (Object)((Object)DataType.MAP));
        }
        return this.isNotNull ? (List)this.value : null;
    }

    public Set asSet() {
        if (this.type != DataType.SET || this.operation != CollectionOperation.SET_VALUE) {
            throw new IllegalStateException("The type of column [" + Bytes.toString(this.getFullName()) + "] is " + this.type.toString() + ", operation: " + (Object)((Object)this.operation) + ", cannot be converted to " + (Object)((Object)DataType.MAP));
        }
        return this.isNotNull ? (Set)this.value : null;
    }

    public Map asMap() {
        if (this.type != DataType.MAP || this.operation != CollectionOperation.MAP_VALUE) {
            throw new IllegalStateException("The type of column [" + Bytes.toString(this.getFullName()) + "] is " + this.type.toString() + ", operation: " + (Object)((Object)this.operation) + ", cannot be converted to " + (Object)((Object)DataType.MAP));
        }
        return this.isNotNull ? (Map)this.value : null;
    }

    @Deprecated
    public Integer getInt() {
        return this.asInt();
    }

    public Long asLong() {
        this.validateDataType(DataType.LONG);
        return this.isNotNull ? Long.valueOf(((Number)this.value).longValue()) : null;
    }

    @Deprecated
    public Long getLong() {
        return this.asLong();
    }

    public Float asFloat() {
        this.validateDataType(DataType.FLOAT);
        return this.isNotNull ? Float.valueOf(((Number)this.value).floatValue()) : null;
    }

    @Deprecated
    public Float getFloat() {
        return this.asFloat();
    }

    public Double asDouble() {
        this.validateDataType(DataType.DOUBLE);
        return this.isNotNull ? Double.valueOf(((Number)this.value).doubleValue()) : null;
    }

    @Deprecated
    public Double getDouble() {
        return this.asDouble();
    }

    public String asString() {
        this.validateDataType(DataType.STRING);
        return (String)this.value;
    }

    @Deprecated
    public String getString() {
        return this.asString();
    }

    public byte[] asBinary() {
        this.validateDataType(DataType.VARBINARY);
        return (byte[])this.value;
    }

    @Deprecated
    public byte[] getBinary() {
        return this.asBinary();
    }

    public BigDecimal asDecimal() {
        this.validateDataType(DataType.DECIMAL);
        if (this.type == DataType.DECIMAL || this.type == DataType.DECIMAL_V2) {
            return (BigDecimal)this.value;
        }
        try {
            return (BigDecimal)LDecimal.INSTANCE.toObject(this.value, LDataTypeFactory.INSTANCE.getTypeInstance(this.type));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed converting " + DataTypeUtils.valueToString(this.type, this.value) + " to Decimal", t);
        }
    }

    @Deprecated
    public BigDecimal getDecimal() {
        return this.asDecimal();
    }

    public Date asDate() {
        this.validateDataType(DataType.DATE);
        return this.isNotNull ? (Date)this.value : null;
    }

    @Deprecated
    public Date getDate() {
        return this.asDate();
    }

    public Time asTime() {
        this.validateDataType(DataType.TIME);
        return this.isNotNull ? (Time)this.value : null;
    }

    @Deprecated
    public Time getTime() {
        return this.asTime();
    }

    public Timestamp asTimestampValue() {
        this.validateDataType(DataType.TIMESTAMP);
        return this.isNotNull ? (Timestamp)this.value : null;
    }

    @Deprecated
    public Timestamp getTimestampValue() {
        return this.asTimestampValue();
    }

    public String asNested() {
        this.validateDataType(DataType.NESTED);
        return (String)this.value;
    }

    public void setNested(String value) throws IllegalDataException {
        this.setValue(value, DataType.NESTED);
    }

    public DataType getType() {
        return this.type;
    }

    public void setValue(Object value, DataType type) throws IllegalDataException {
        if (type == null) {
            throw new IllegalDataException("Data type must not be null.");
        }
        this.value = value;
        this.type = type;
        if (value != null) {
            this.isNotNull = true;
            this.validateValue();
        } else {
            this.isNotNull = false;
        }
    }

    public void setByte(Byte value) throws IllegalDataException {
        this.setValue(value, DataType.BYTE);
    }

    public void setUUID(UUID value) throws IllegalDataException {
        this.setValue(value, DataType.UUID);
    }

    public void setBoolean(Boolean value) throws IllegalDataException {
        this.setValue(value, DataType.BOOLEAN);
    }

    public void setShort(Short value) throws IllegalDataException {
        this.setValue(value, DataType.SHORT);
    }

    public void setInt(Integer value) throws IllegalDataException {
        this.setValue(value, DataType.INT);
    }

    public void setLong(Long value) throws IllegalDataException {
        this.setValue(value, DataType.LONG);
    }

    public void setFloat(Float value) throws IllegalDataException {
        this.setValue(value, DataType.FLOAT);
    }

    public void setDouble(Double value) throws IllegalDataException {
        this.setValue(value, DataType.DOUBLE);
    }

    public void setString(String value) throws IllegalDataException {
        this.setValue(value, DataType.STRING);
    }

    public void setBinary(byte[] value) throws IllegalDataException {
        this.setValue(value, DataType.BINARY);
    }

    public void setDecimal(BigDecimal value) throws IllegalDataException {
        this.setValue(value, DataType.DECIMAL);
    }

    public void setDate(Date value) throws IllegalDataException {
        this.setValue(value, DataType.DATE);
    }

    public void setTime(Time value) throws IllegalDataException {
        this.setValue(value, DataType.TIME);
    }

    public void setTimestampValue(Timestamp value) throws IllegalDataException {
        this.setValue(value, DataType.TIMESTAMP);
    }

    @Override
    public String toString() {
        return "(" + Bytes.toString(this.getFullName()) + "=" + DataTypeUtils.valueToString(this.type, this.value) + (this.ts != Long.MAX_VALUE ? " @" + this.ts + " " + new java.util.Date(this.ts) : "") + (this.getTTL() != Long.MAX_VALUE ? " TTL: " + this.getTTL() : "") + ")";
    }

    private void validateDataType(DataType targetType) {
        LDataType target;
        LDataType current = TYPE_FACTORY.getTypeInstance(this.type);
        if (!current.isCastableTo(target = TYPE_FACTORY.getTypeInstance(targetType))) {
            throw new IllegalStateException("The type of column [" + Bytes.toString(this.getFullName()) + "] is " + this.type.toString() + " cannot be converted to " + targetType.toString());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnValue)) {
            return false;
        }
        ColumnValue other = (ColumnValue)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (this.ts != other.ts) {
            return false;
        }
        if (this.isNotNull != other.isNotNull) {
            return false;
        }
        if (this.lCollectionType != null ? !this.lCollectionType.equals(other.lCollectionType) : other.lCollectionType != null) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        if (this.isNotNull) {
            if (this.type != other.type) {
                return false;
            }
            if (this.type == DataType.VARBINARY || this.type == DataType.BINARY || this.type == DataType.ENCODED_VARBINARY ? !Arrays.equals((byte[])this.value, (byte[])other.value) : !this.value.equals(other.value)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        this.columnKey.writeTo(out);
        WritableUtils.writeVLong(out, this.ts);
        WritableUtils.writeVInt(out, this.type.ordinal());
        if (this.isNotNull) {
            byte[] valueBytes;
            out.writeBoolean(true);
            switch (this.type) {
                case SET: {
                    valueBytes = this.lCollectionType.toTransferBytes(this.value);
                    break;
                }
                case MAP: {
                    valueBytes = this.valueAsBytesForMap();
                    break;
                }
                case LIST: {
                    valueBytes = this.valueAsBytesForList();
                    break;
                }
                default: {
                    valueBytes = LDataTypeFactory.INSTANCE.getTypeInstance(this.type).toTransferBytes(this.value);
                }
            }
            Bytes.writeByteArray(out, valueBytes);
        } else {
            out.writeBoolean(false);
        }
    }

    private byte[] valueAsBytesForMap() throws IllegalDataException {
        byte[] valueBytes;
        if (this.operation == CollectionOperation.MAP_DISCARD) {
            LSet lset = (LSet)LDataTypeFactory.INSTANCE.getTypeInstance(DataType.set(((LMap)this.lCollectionType).getKeyType()));
            valueBytes = lset.toTransferBytes((Set)this.value);
        } else {
            valueBytes = this.lCollectionType.toTransferBytes(this.value);
        }
        return valueBytes;
    }

    private Object valueFromBytesForMap(byte[] bytes) throws IllegalDataException {
        Object value;
        if (this.operation == CollectionOperation.MAP_DISCARD) {
            LSet lset = (LSet)LDataTypeFactory.INSTANCE.getTypeInstance(DataType.set(((LMap)this.lCollectionType).getKeyType()));
            value = lset.fromTransferBytes(bytes);
        } else {
            value = this.lCollectionType.fromTransferBytes(bytes);
        }
        return value;
    }

    private byte[] valueAsBytesForList() throws IllegalDataException {
        byte[] valueBytes;
        if (this.operation == CollectionOperation.LIST_SET_BY_INDEX) {
            Pair pair = (Pair)this.value;
            LDataType elementType = ((LList)this.lCollectionType).getElementType();
            if (pair.getSecond() == null) {
                valueBytes = new byte[4];
                Bytes.putInt(valueBytes, 0, (Integer)pair.getFirst());
            } else {
                byte[] bytes = elementType.toTransferBytes(pair.getSecond());
                valueBytes = new byte[bytes.length + 4];
                Bytes.putInt(valueBytes, 0, (Integer)pair.getFirst());
                Bytes.putBytes(valueBytes, 4, bytes, 0, bytes.length);
            }
        } else if (this.operation == CollectionOperation.LIST_DISCARD) {
            LSet lset = (LSet)LDataTypeFactory.INSTANCE.getTypeInstance(DataType.set(((LList)this.lCollectionType).getElementType()));
            valueBytes = lset.toTransferBytes(this.value);
        } else {
            valueBytes = this.operation == CollectionOperation.LIST_DISCARD_BY_INDEX ? Bytes.toBytes((Integer)this.value) : this.lCollectionType.toTransferBytes(this.value);
        }
        return valueBytes;
    }

    private Object valueFromBytesForList(byte[] bytes) throws IllegalDataException {
        Object value;
        if (this.operation == CollectionOperation.LIST_SET_BY_INDEX) {
            int index = Bytes.toInt(bytes, 0, 4);
            LDataType elementType = ((LList)this.lCollectionType).getElementType();
            int valueBytesLength = bytes.length - 4;
            Object obj = valueBytesLength == 0 ? null : elementType.fromTransferBytes(bytes, 4, valueBytesLength);
            value = new Pair<Integer, Object>(index, obj);
        } else if (this.operation == CollectionOperation.LIST_DISCARD) {
            LSet lset = (LSet)LDataTypeFactory.INSTANCE.getTypeInstance(DataType.set(((LList)this.lCollectionType).getElementType()));
            value = lset.fromTransferBytes(bytes);
        } else {
            value = this.operation == CollectionOperation.LIST_DISCARD_BY_INDEX ? Integer.valueOf(Bytes.toInt(bytes)) : this.lCollectionType.fromTransferBytes(bytes);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAttributes() throws IOException {
        if (this.type.isCollection()) {
            assert (this.operation != null && this.lCollectionType != null);
            this.setAttribute(COLLECTION_OPERATION_ATTR, new byte[]{this.operation.getValue()});
            this.setAttribute(COLLECTION_DATA_TYPE_ATTR, this.lCollectionType.asBytes());
        } else {
            this.removeAttribute(COLLECTION_DATA_TYPE_ATTR);
            this.removeAttribute(COLLECTION_OPERATION_ATTR);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteStream);
            try {
                WritableUtils.writeVInt(out, this.tags.size());
                for (LTag tag : this.tags) {
                    tag.writeTo(out);
                }
                out.close();
                this.setAttribute("tags", byteStream.toByteArray());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFrom(DataInput in) throws IOException {
        byte[] t;
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        this.ts = WritableUtils.readVLong(in);
        int typeOrdinal = WritableUtils.readVInt(in);
        this.type = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(typeOrdinal);
        if (this.type.isCollection()) {
            byte[] typeBytes = this.getAttribute(COLLECTION_DATA_TYPE_ATTR);
            byte[] operationBytes = this.getAttribute(COLLECTION_OPERATION_ATTR);
            assert (typeBytes != null && typeBytes.length > 0 && operationBytes != null && operationBytes.length > 0);
            this.lCollectionType = (LCollectionType)LDataType.fromBytes(typeBytes);
            this.operation = CollectionOperation.valueOf(operationBytes[0]);
        }
        this.isNotNull = in.readBoolean();
        if (this.isNotNull) {
            byte[] valueBytes = Bytes.readByteArray(in);
            switch (this.type) {
                case SET: {
                    this.value = this.lCollectionType.fromTransferBytes(valueBytes);
                    break;
                }
                case MAP: {
                    this.value = this.valueFromBytesForMap(valueBytes);
                    break;
                }
                case LIST: {
                    this.value = this.valueFromBytesForList(valueBytes);
                    break;
                }
                default: {
                    this.value = LDataTypeFactory.INSTANCE.getTypeInstance(this.type).fromTransferBytes(valueBytes);
                    break;
                }
            }
        } else {
            this.value = null;
        }
        if ((t = this.getAttribute("tags")) != null) {
            this.tags = new ArrayList<LTag>();
            DataInputBuffer tagIn = new DataInputBuffer();
            try {
                tagIn.reset(t, 0, t.length);
                int size = WritableUtils.readVInt(tagIn);
                for (int i = 0; i < size; ++i) {
                    LTag ltag = new LTag();
                    ltag.readFrom(tagIn);
                    this.tags.add(ltag);
                }
            }
            finally {
                tagIn.close();
            }
        }
    }

    public ColumnValue clone() throws CloneNotSupportedException {
        ColumnValue copy = (ColumnValue)super.clone();
        copy.columnKey = new ColumnKey(Bytes.copy(this.columnKey.getFamily()), Bytes.copy(this.columnKey.getQualifier()));
        if (this.value instanceof byte[]) {
            copy.value = Arrays.copyOf((byte[])this.value, ((byte[])this.value).length);
        }
        copy.ts = this.ts;
        return copy;
    }

    public static int compare(ColumnValue v1, ColumnValue v2) {
        Preconditions.checkNotNull(v1);
        Preconditions.checkNotNull(v2);
        if (v1.getValueObject() == null || v2.getValueObject() == null) {
            throw new IllegalStateException("Can not compare null values.");
        }
        if (v1.getType() != v2.getType()) {
            throw new IllegalStateException("Can not compare value with different type");
        }
        switch (v1.getType()) {
            case BYTE: 
            case UNSIGNED_BYTE: {
                return v1.getByte() - v2.getByte();
            }
            case BOOLEAN: {
                return v1.getBoolean().booleanValue() == v2.getBoolean().booleanValue() ? 0 : (v1.getBoolean() != false ? 1 : -1);
            }
            case SHORT: 
            case UNSIGNED_SHORT: {
                return v1.getShort() - v2.getShort();
            }
            case INT: 
            case UNSIGNED_INTEGER: {
                return v1.getInt() < v2.getInt() ? -1 : (v1.getInt().intValue() == v2.getInt().intValue() ? 0 : 1);
            }
            case LONG: 
            case UNSIGNED_LONG: 
            case ACC_LONG: {
                return v1.getLong() < v2.getLong() ? -1 : (v1.getLong().longValue() == v2.getLong().longValue() ? 0 : 1);
            }
            case FLOAT: 
            case UNSIGNED_FLOAT: {
                return Float.compare(v1.getFloat().floatValue(), v2.getFloat().floatValue());
            }
            case DOUBLE: 
            case UNSIGNED_DOUBLE: 
            case ACC_DOUBLE: {
                return Double.compare(v1.getDouble(), v2.getDouble());
            }
            case STRING: 
            case CHAR: 
            case NESTED: {
                return v1.getString().compareTo(v2.getString());
            }
            case VARBINARY: 
            case BINARY: 
            case ENCODED_VARBINARY: {
                return Bytes.compareTo(v1.getBinary(), v2.getBinary());
            }
            case DECIMAL: 
            case DECIMAL_V2: {
                return v1.getDecimal().compareTo(v2.getDecimal());
            }
            case UUID: {
                try {
                    return Bytes.compareTo(LUUID.INSTANCE.toBytes(v1.asUUID()), LUUID.INSTANCE.toBytes(v2.asUUID()));
                }
                catch (IllegalDataException e) {
                    throw new IllegalArgumentException("illegal data for uuid type");
                }
            }
        }
        throw new IllegalArgumentException("Unknown data type" + (Object)((Object)v1.getType()));
    }

    @Override
    public int compareTo(ColumnValue o) {
        return ColumnValue.compare(this, o);
    }

    private void validateValue() throws IllegalDataException {
        byte[] bytes;
        assert (this.value != null);
        if (this.value instanceof byte[] && (bytes = (byte[])this.value).length == 0) {
            throw new IllegalDataException("Must not use byte[0] for BINARY/VARBINARY, please use null instead. columnName=" + this.columnKey.toString());
        }
        if (this.lCollectionType != null) {
            this.validateCollectionValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateCollectionValue() throws IllegalDataException {
        if (this.lCollectionType instanceof LList) {
            if (this.operation == CollectionOperation.LIST_SET_BY_INDEX) {
                if (!(this.value instanceof Pair)) throw new IllegalDataException("expect type: pair, data type: " + this.value.getClass());
                Object index = ((Pair)this.value).getFirst();
                Object item = ((Pair)this.value).getSecond();
                ((LList)this.lCollectionType).getElementType().validate(item);
                LInteger.INSTANCE.validate(index);
                return;
            } else if (this.operation == CollectionOperation.LIST_DISCARD) {
                LSet lset = (LSet)LDataTypeFactory.INSTANCE.getTypeInstance(DataType.set(((LList)this.lCollectionType).getElementType()));
                lset.validate(this.value);
                return;
            } else if (this.operation == CollectionOperation.LIST_DISCARD_BY_INDEX) {
                LInteger.INSTANCE.validate(this.value);
                return;
            } else {
                this.lCollectionType.validate(this.value);
            }
            return;
        } else if (this.lCollectionType instanceof LMap && this.operation == CollectionOperation.MAP_DISCARD) {
            LSet lset = (LSet)LDataTypeFactory.INSTANCE.getTypeInstance(DataType.set(((LMap)this.lCollectionType).getKeyType()));
            lset.validate(this.value);
            return;
        } else {
            this.lCollectionType.validate(this.value);
        }
    }

    public boolean hasTTL() {
        return this.hasAttribute("_ttl");
    }

    public Long getTTL() {
        byte[] ttlBytes = this.getAttribute("_ttl");
        if (ttlBytes != null) {
            return Bytes.toLong(ttlBytes);
        }
        return Long.MAX_VALUE;
    }

    public static ColumnValue sSet(String name, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.SET_SET);
    }

    public static ColumnValue sSet(String name, long ts, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.SET_SET);
    }

    public static ColumnValue sAdd(String name, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.SET_ADD);
    }

    public static ColumnValue sAdd(String name, long ts, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.SET_ADD);
    }

    public static ColumnValue sAddElement(String name, Object value, CollectionDataType type) throws LindormException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(value);
        return ColumnValue.sAdd(name, set, type);
    }

    public static ColumnValue sAddElement(String name, long ts, Object value, CollectionDataType type) throws LindormException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(value);
        return ColumnValue.sAdd(name, ts, set, type);
    }

    public static ColumnValue sDiscard(String name, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.SET_DISCARD);
    }

    public static ColumnValue sDiscard(String name, long ts, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.SET_DISCARD);
    }

    public static ColumnValue sDiscardElement(String name, Object value, CollectionDataType type) throws LindormException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(value);
        return ColumnValue.sDiscard(name, set, type);
    }

    public static ColumnValue sDiscardElement(String name, long ts, Object value, CollectionDataType type) throws LindormException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(value);
        return ColumnValue.sDiscard(name, ts, set, type);
    }

    public static ColumnValue lSet(String name, List value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.LIST_SET);
    }

    public static ColumnValue lSet(String name, long ts, List value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.LIST_SET);
    }

    public static ColumnValue lSetByIndex(String name, int index, Object value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, new Pair<Integer, Object>(index, value), type, CollectionOperation.LIST_SET_BY_INDEX);
    }

    public static ColumnValue lSetByIndex(String name, long ts, int index, Object value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, new Pair<Integer, Object>(index, value), type, CollectionOperation.LIST_SET_BY_INDEX);
    }

    public static ColumnValue lAppend(String name, List value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.LIST_APPEND);
    }

    public static ColumnValue lAppendElement(String name, Object value, CollectionDataType type) throws LindormException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(value);
        return ColumnValue.lAppend(name, list, type);
    }

    public static ColumnValue lAppend(String name, long ts, List value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.LIST_APPEND);
    }

    public static ColumnValue lAppendElement(String name, long ts, Object value, CollectionDataType type) throws LindormException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(value);
        return ColumnValue.lAppend(name, ts, list, type);
    }

    public static ColumnValue lPrependElement(String name, Object value, CollectionDataType type) throws LindormException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(value);
        return ColumnValue.lPrepend(name, list, type);
    }

    public static ColumnValue lPrepend(String name, List value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.LIST_PREPEND);
    }

    public static ColumnValue lPrependElement(String name, long ts, Object value, CollectionDataType type) throws LindormException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(value);
        return ColumnValue.lPrepend(name, ts, list, type);
    }

    public static ColumnValue lPrepend(String name, long ts, List value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.LIST_PREPEND);
    }

    public static ColumnValue lDiscard(String name, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.LIST_DISCARD);
    }

    public static ColumnValue lDiscard(String name, long ts, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.LIST_DISCARD);
    }

    public static ColumnValue lDiscardElement(String name, Object value, CollectionDataType type) throws LindormException {
        HashSet<Object> s = new HashSet<Object>();
        s.add(value);
        return ColumnValue.lDiscard(name, s, type);
    }

    public static ColumnValue lDiscardElement(String name, long ts, Object value, CollectionDataType type) throws LindormException {
        HashSet<Object> s = new HashSet<Object>();
        s.add(value);
        return ColumnValue.lDiscard(name, ts, s, type);
    }

    public static ColumnValue lDiscardByIndex(String name, int index, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)index, type, CollectionOperation.LIST_DISCARD_BY_INDEX);
    }

    public static ColumnValue lDiscardByIndex(String name, long ts, int index, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)index, type, CollectionOperation.LIST_DISCARD_BY_INDEX);
    }

    public static ColumnValue mSet(String name, Map value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.MAP_SET);
    }

    public static ColumnValue mSet(String name, long ts, Map value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.MAP_SET);
    }

    public static ColumnValue mPut(String name, Map value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.MAP_PUT);
    }

    public static ColumnValue mPut(String name, long ts, Map value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.MAP_PUT);
    }

    public static ColumnValue mPutElement(String name, Object key, Object value, CollectionDataType type) throws LindormException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        return ColumnValue.mPut(name, map, type);
    }

    public static ColumnValue mPutElement(String name, long ts, Object key, Object value, CollectionDataType type) throws LindormException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        return ColumnValue.mPut(name, ts, map, type);
    }

    public static ColumnValue mDiscard(String name, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, (Object)value, type, CollectionOperation.MAP_DISCARD);
    }

    public static ColumnValue mDiscard(String name, long ts, Set value, CollectionDataType type) throws LindormException {
        return new ColumnValue(name, ts, (Object)value, type, CollectionOperation.MAP_DISCARD);
    }

    public static ColumnValue mDiscardElement(String name, Object key, CollectionDataType type) throws LindormException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(key);
        return ColumnValue.mDiscard(name, set, type);
    }

    public static ColumnValue mDiscardElement(String name, long ts, Object key, CollectionDataType type) throws LindormException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(key);
        return ColumnValue.mDiscard(name, ts, set, type);
    }
}

