/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;

public class StringUtils {
    public static String random(Random random, int maxLength) {
        String s;
        StringBuilder result = new StringBuilder();
        int length = 0;
        do {
            s = UUID.randomUUID().toString();
            result.append(s, 0, Math.min(random.nextInt(s.length()), s.length()));
        } while (random.nextBoolean() && (length += s.length()) < maxLength);
        return result.toString();
    }

    public static String join(CharSequence separator, Iterable<?> strings) {
        Iterator<?> i = strings.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(i.next().toString());
        while (i.hasNext()) {
            sb.append(separator);
            sb.append(i.next().toString());
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 != null && !s1.equals(s2)) {
            return false;
        }
        return s2 == null || s2.equals(s1);
    }

    public static String stringifyException(Throwable e) {
        return StringUtils.stringifyException(e, -1);
    }

    public static String stringifyException(Throwable e, int lengthLimit) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        String ret = stm.toString();
        if (lengthLimit > 0 && ret.length() > lengthLimit) {
            return ret.substring(0, lengthLimit);
        }
        return ret;
    }
}

