/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import java.util.List;

public class ConnectionUtils {
    public static long getPauseTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= LindormClientConstants.RETRY_BACKOFF.length) {
            ntries = LindormClientConstants.RETRY_BACKOFF.length - 1;
        }
        return pause * (long)LindormClientConstants.RETRY_BACKOFF[ntries];
    }

    public static boolean isServerlessMode(LindormClientConfig config, List<LDServerAddress> serverAddresses) {
        if (serverAddresses == null || serverAddresses.size() == 0) {
            return false;
        }
        int serverlessPort = config.getInt("lindorm.rpc.serverless.port", 30022);
        for (LDServerAddress address : serverAddresses) {
            if (address.getPort() == serverlessPort) continue;
            return false;
        }
        return true;
    }

    public static boolean isServerlessMode(LindormClientConfig config, LDServerAddress serverAddresses) {
        int serverlessPort = config.getInt("lindorm.rpc.serverless.port", 30022);
        return serverAddresses.getPort() == serverlessPort;
    }
}

