/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LUnsignedLong
extends LWholeNumberType<Long> {
    public static final LUnsignedLong INSTANCE = new LUnsignedLong();

    private LUnsignedLong() {
        super(DataType.UNSIGNED_LONG, Long.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return LLong.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        long longValue = ((Number)value).longValue();
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeUnsignedLong(longValue, ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        Long v = (Long)LLong.INSTANCE.toObject(value, actualType);
        if (v < 0L) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_LONG type, actual value=" + v);
        }
        return v;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeUnsignedLong(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_LONG_ARRAY;
    }

    @Override
    public Long randomData(DataGenerator dataGenerator) {
        return LLong.INSTANCE.randomData(dataGenerator);
    }
}

