/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LAccDouble;
import com.alibaba.lindorm.client.core.types.LAccLong;
import com.alibaba.lindorm.client.core.types.LBinary;
import com.alibaba.lindorm.client.core.types.LBoolean;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LChar;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LEncodedVarbinary;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LList;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LMap;
import com.alibaba.lindorm.client.core.types.LNested;
import com.alibaba.lindorm.client.core.types.LSet;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LTimestamp;
import com.alibaba.lindorm.client.core.types.LUUID;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LUnsignedTime;
import com.alibaba.lindorm.client.core.types.LUnsignedTimestamp;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.ListType;
import com.alibaba.lindorm.client.schema.MapType;
import com.alibaba.lindorm.client.schema.SetType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LDataTypeFactory {
    public static final LDataTypeFactory INSTANCE = new LDataTypeFactory();
    private final SortedSet<LDataType> types;
    final Map<CollectionDataType, LCollectionType> collectionTypes = new HashMap<CollectionDataType, LCollectionType>();
    private final LDataType[] orderedTypes;
    private final Map<Class, LDataType> classToDataType;

    private LDataTypeFactory() {
        this.types = new TreeSet<LDataType>(new Comparator<LDataType>(){

            @Override
            public int compare(LDataType t1, LDataType t2) {
                int y;
                int x = t1.getOrdinal();
                return x < (y = t2.getOrdinal()) ? -1 : (x == y ? 0 : 1);
            }
        });
        this.types.add(LByte.INSTANCE);
        this.types.add(LBoolean.INSTANCE);
        this.types.add(LShort.INSTANCE);
        this.types.add(LInteger.INSTANCE);
        this.types.add(LLong.INSTANCE);
        this.types.add(LFloat.INSTANCE);
        this.types.add(LDouble.INSTANCE);
        this.types.add(LString.INSTANCE);
        this.types.add(LVarbinary.INSTANCE);
        this.types.add(LBinary.INSTANCE);
        this.types.add(LDecimal.INSTANCE);
        this.types.add(LUnsignedByte.INSTANCE);
        this.types.add(LUnsignedShort.INSTANCE);
        this.types.add(LUnsignedInteger.INSTANCE);
        this.types.add(LUnsignedLong.INSTANCE);
        this.types.add(LUnsignedFloat.INSTANCE);
        this.types.add(LUnsignedDouble.INSTANCE);
        this.types.add(LEncodedVarbinary.INSTANCE);
        this.types.add(LAccLong.INSTANCE);
        this.types.add(LAccDouble.INSTANCE);
        this.types.add(LDate.INSTANCE);
        this.types.add(LUnsignedDate.INSTANCE);
        this.types.add(LTime.INSTANCE);
        this.types.add(LUnsignedTime.INSTANCE);
        this.types.add(LTimestamp.INSTANCE);
        this.types.add(LUnsignedTimestamp.INSTANCE);
        this.types.add(LChar.INSTANCE);
        this.types.add(LUUID.INSTANCE);
        this.types.add(LDecimalV2.INSTANCE);
        this.types.add(LNested.INSTANCE);
        this.orderedTypes = this.types.toArray(new LDataType[0]);
        this.classToDataType = CollectionUtils.newHashMapWithExpectedSize(this.types.size());
        for (LDataType type : this.orderedTypes) {
            if (type == LAccLong.INSTANCE || type == LAccDouble.INSTANCE || type == LDecimalV2.INSTANCE || type == LNested.INSTANCE) continue;
            if (DataTypeUtils.isBytesType(type.getClientType())) {
                this.classToDataType.put(type.getJavaClass(), LVarbinary.INSTANCE);
                continue;
            }
            if (type == LChar.INSTANCE) {
                this.classToDataType.put(type.getJavaClass(), LString.INSTANCE);
                continue;
            }
            if (DataTypeUtils.isUnsignedType(type.getClientType())) continue;
            this.classToDataType.put(type.getJavaClass(), type);
        }
    }

    public Set<LDataType> getTypes() {
        return this.types;
    }

    public LDataType[] getOrderedTypes() {
        return this.orderedTypes;
    }

    public LDataType getTypeInstance(DataType type) {
        return this.orderedTypes[type.ordinal()];
    }

    public synchronized LDataType getTypeInstance(CollectionDataType collectionDataType) {
        assert (collectionDataType != null);
        LCollectionType result = this.collectionTypes.get(collectionDataType);
        if (result == null) {
            if (collectionDataType instanceof SetType) {
                result = new LSet((SetType)collectionDataType);
            } else if (collectionDataType instanceof MapType) {
                result = new LMap((MapType)collectionDataType);
            } else if (collectionDataType instanceof ListType) {
                result = new LList((ListType)collectionDataType);
            } else {
                String msg = String.format("type instance not found. collectionDataType: %s", collectionDataType);
                throw new IllegalArgumentException(msg);
            }
            this.collectionTypes.put(collectionDataType, result);
        }
        return result;
    }

    public DataType getClientTypeByOrdinal(int ordinal) throws IllegalDataException {
        DataType[] clientTypes = DataType.values();
        if (ordinal < 0 || ordinal >= clientTypes.length) {
            throw new IllegalDataException("Unknown data type " + ordinal);
        }
        return clientTypes[ordinal];
    }

    public LDataType getTypeByClass(Class clazz) throws LindormException {
        LDataType type = this.classToDataType.get(clazz);
        if (type == null) {
            throw new LindormException("Unknown data type " + clazz.getSimpleName());
        }
        return type;
    }

    public String dumpOrderedTypes() {
        StringBuilder ret = new StringBuilder();
        for (LDataType t : this.orderedTypes) {
            ret.append(t.getOrdinal());
            ret.append(" ");
            ret.append(t.getName());
            ret.append("\n");
        }
        return ret.toString();
    }
}

